/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A mapping that's used to pair a logical network interface name on a Node with the physical interface name exposed in
 * the operating system.
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeInterfaceMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeInterfaceMapping.Builder, NodeInterfaceMapping> {
    private static final SdkField<String> LOGICAL_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogicalInterfaceName").getter(getter(NodeInterfaceMapping::logicalInterfaceName))
            .setter(setter(Builder::logicalInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalInterfaceName").build())
            .build();

    private static final SdkField<String> NETWORK_INTERFACE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceMode").getter(getter(NodeInterfaceMapping::networkInterfaceModeAsString))
            .setter(setter(Builder::networkInterfaceMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceMode").build())
            .build();

    private static final SdkField<String> PHYSICAL_INTERFACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhysicalInterfaceName").getter(getter(NodeInterfaceMapping::physicalInterfaceName))
            .setter(setter(Builder::physicalInterfaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalInterfaceName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_INTERFACE_NAME_FIELD,
            NETWORK_INTERFACE_MODE_FIELD, PHYSICAL_INTERFACE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logicalInterfaceName;

    private final String networkInterfaceMode;

    private final String physicalInterfaceName;

    private NodeInterfaceMapping(BuilderImpl builder) {
        this.logicalInterfaceName = builder.logicalInterfaceName;
        this.networkInterfaceMode = builder.networkInterfaceMode;
        this.physicalInterfaceName = builder.physicalInterfaceName;
    }

    /**
     * A uniform logical interface name to address in a MediaLive channel configuration.
     * 
     * @return A uniform logical interface name to address in a MediaLive channel configuration.
     */
    public final String logicalInterfaceName() {
        return logicalInterfaceName;
    }

    /**
     * Returns the value of the NetworkInterfaceMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #networkInterfaceMode} will return {@link NetworkInterfaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #networkInterfaceModeAsString}.
     * </p>
     * 
     * @return The value of the NetworkInterfaceMode property for this object.
     * @see NetworkInterfaceMode
     */
    public final NetworkInterfaceMode networkInterfaceMode() {
        return NetworkInterfaceMode.fromValue(networkInterfaceMode);
    }

    /**
     * Returns the value of the NetworkInterfaceMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #networkInterfaceMode} will return {@link NetworkInterfaceMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #networkInterfaceModeAsString}.
     * </p>
     * 
     * @return The value of the NetworkInterfaceMode property for this object.
     * @see NetworkInterfaceMode
     */
    public final String networkInterfaceModeAsString() {
        return networkInterfaceMode;
    }

    /**
     * The name of the physical interface on the hardware that will be running Elemental anywhere.
     * 
     * @return The name of the physical interface on the hardware that will be running Elemental anywhere.
     */
    public final String physicalInterfaceName() {
        return physicalInterfaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logicalInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(physicalInterfaceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeInterfaceMapping)) {
            return false;
        }
        NodeInterfaceMapping other = (NodeInterfaceMapping) obj;
        return Objects.equals(logicalInterfaceName(), other.logicalInterfaceName())
                && Objects.equals(networkInterfaceModeAsString(), other.networkInterfaceModeAsString())
                && Objects.equals(physicalInterfaceName(), other.physicalInterfaceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeInterfaceMapping").add("LogicalInterfaceName", logicalInterfaceName())
                .add("NetworkInterfaceMode", networkInterfaceModeAsString())
                .add("PhysicalInterfaceName", physicalInterfaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogicalInterfaceName":
            return Optional.ofNullable(clazz.cast(logicalInterfaceName()));
        case "NetworkInterfaceMode":
            return Optional.ofNullable(clazz.cast(networkInterfaceModeAsString()));
        case "PhysicalInterfaceName":
            return Optional.ofNullable(clazz.cast(physicalInterfaceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logicalInterfaceName", LOGICAL_INTERFACE_NAME_FIELD);
        map.put("networkInterfaceMode", NETWORK_INTERFACE_MODE_FIELD);
        map.put("physicalInterfaceName", PHYSICAL_INTERFACE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeInterfaceMapping, T> g) {
        return obj -> g.apply((NodeInterfaceMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeInterfaceMapping> {
        /**
         * A uniform logical interface name to address in a MediaLive channel configuration.
         * 
         * @param logicalInterfaceName
         *        A uniform logical interface name to address in a MediaLive channel configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalInterfaceName(String logicalInterfaceName);

        /**
         * Sets the value of the NetworkInterfaceMode property for this object.
         *
         * @param networkInterfaceMode
         *        The new value for the NetworkInterfaceMode property for this object.
         * @see NetworkInterfaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceMode
         */
        Builder networkInterfaceMode(String networkInterfaceMode);

        /**
         * Sets the value of the NetworkInterfaceMode property for this object.
         *
         * @param networkInterfaceMode
         *        The new value for the NetworkInterfaceMode property for this object.
         * @see NetworkInterfaceMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkInterfaceMode
         */
        Builder networkInterfaceMode(NetworkInterfaceMode networkInterfaceMode);

        /**
         * The name of the physical interface on the hardware that will be running Elemental anywhere.
         * 
         * @param physicalInterfaceName
         *        The name of the physical interface on the hardware that will be running Elemental anywhere.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder physicalInterfaceName(String physicalInterfaceName);
    }

    static final class BuilderImpl implements Builder {
        private String logicalInterfaceName;

        private String networkInterfaceMode;

        private String physicalInterfaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeInterfaceMapping model) {
            logicalInterfaceName(model.logicalInterfaceName);
            networkInterfaceMode(model.networkInterfaceMode);
            physicalInterfaceName(model.physicalInterfaceName);
        }

        public final String getLogicalInterfaceName() {
            return logicalInterfaceName;
        }

        public final void setLogicalInterfaceName(String logicalInterfaceName) {
            this.logicalInterfaceName = logicalInterfaceName;
        }

        @Override
        public final Builder logicalInterfaceName(String logicalInterfaceName) {
            this.logicalInterfaceName = logicalInterfaceName;
            return this;
        }

        public final String getNetworkInterfaceMode() {
            return networkInterfaceMode;
        }

        public final void setNetworkInterfaceMode(String networkInterfaceMode) {
            this.networkInterfaceMode = networkInterfaceMode;
        }

        @Override
        public final Builder networkInterfaceMode(String networkInterfaceMode) {
            this.networkInterfaceMode = networkInterfaceMode;
            return this;
        }

        @Override
        public final Builder networkInterfaceMode(NetworkInterfaceMode networkInterfaceMode) {
            this.networkInterfaceMode(networkInterfaceMode == null ? null : networkInterfaceMode.toString());
            return this;
        }

        public final String getPhysicalInterfaceName() {
            return physicalInterfaceName;
        }

        public final void setPhysicalInterfaceName(String physicalInterfaceName) {
            this.physicalInterfaceName = physicalInterfaceName;
        }

        @Override
        public final Builder physicalInterfaceName(String physicalInterfaceName) {
            this.physicalInterfaceName = physicalInterfaceName;
            return this;
        }

        @Override
        public NodeInterfaceMapping build() {
            return new NodeInterfaceMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
