/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Output Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class OutputSettings implements SdkPojo, Serializable, ToCopyableBuilder<OutputSettings.Builder, OutputSettings> {
    private static final SdkField<ArchiveOutputSettings> ARCHIVE_OUTPUT_SETTINGS_FIELD = SdkField
            .<ArchiveOutputSettings> builder(MarshallingType.SDK_POJO).memberName("ArchiveOutputSettings")
            .getter(getter(OutputSettings::archiveOutputSettings)).setter(setter(Builder::archiveOutputSettings))
            .constructor(ArchiveOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveOutputSettings").build())
            .build();

    private static final SdkField<FrameCaptureOutputSettings> FRAME_CAPTURE_OUTPUT_SETTINGS_FIELD = SdkField
            .<FrameCaptureOutputSettings> builder(MarshallingType.SDK_POJO)
            .memberName("FrameCaptureOutputSettings")
            .getter(getter(OutputSettings::frameCaptureOutputSettings))
            .setter(setter(Builder::frameCaptureOutputSettings))
            .constructor(FrameCaptureOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameCaptureOutputSettings").build())
            .build();

    private static final SdkField<HlsOutputSettings> HLS_OUTPUT_SETTINGS_FIELD = SdkField
            .<HlsOutputSettings> builder(MarshallingType.SDK_POJO).memberName("HlsOutputSettings")
            .getter(getter(OutputSettings::hlsOutputSettings)).setter(setter(Builder::hlsOutputSettings))
            .constructor(HlsOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsOutputSettings").build()).build();

    private static final SdkField<MediaPackageOutputSettings> MEDIA_PACKAGE_OUTPUT_SETTINGS_FIELD = SdkField
            .<MediaPackageOutputSettings> builder(MarshallingType.SDK_POJO)
            .memberName("MediaPackageOutputSettings")
            .getter(getter(OutputSettings::mediaPackageOutputSettings))
            .setter(setter(Builder::mediaPackageOutputSettings))
            .constructor(MediaPackageOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaPackageOutputSettings").build())
            .build();

    private static final SdkField<MsSmoothOutputSettings> MS_SMOOTH_OUTPUT_SETTINGS_FIELD = SdkField
            .<MsSmoothOutputSettings> builder(MarshallingType.SDK_POJO).memberName("MsSmoothOutputSettings")
            .getter(getter(OutputSettings::msSmoothOutputSettings)).setter(setter(Builder::msSmoothOutputSettings))
            .constructor(MsSmoothOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("msSmoothOutputSettings").build())
            .build();

    private static final SdkField<MultiplexOutputSettings> MULTIPLEX_OUTPUT_SETTINGS_FIELD = SdkField
            .<MultiplexOutputSettings> builder(MarshallingType.SDK_POJO).memberName("MultiplexOutputSettings")
            .getter(getter(OutputSettings::multiplexOutputSettings)).setter(setter(Builder::multiplexOutputSettings))
            .constructor(MultiplexOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiplexOutputSettings").build())
            .build();

    private static final SdkField<RtmpOutputSettings> RTMP_OUTPUT_SETTINGS_FIELD = SdkField
            .<RtmpOutputSettings> builder(MarshallingType.SDK_POJO).memberName("RtmpOutputSettings")
            .getter(getter(OutputSettings::rtmpOutputSettings)).setter(setter(Builder::rtmpOutputSettings))
            .constructor(RtmpOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rtmpOutputSettings").build())
            .build();

    private static final SdkField<UdpOutputSettings> UDP_OUTPUT_SETTINGS_FIELD = SdkField
            .<UdpOutputSettings> builder(MarshallingType.SDK_POJO).memberName("UdpOutputSettings")
            .getter(getter(OutputSettings::udpOutputSettings)).setter(setter(Builder::udpOutputSettings))
            .constructor(UdpOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("udpOutputSettings").build()).build();

    private static final SdkField<CmafIngestOutputSettings> CMAF_INGEST_OUTPUT_SETTINGS_FIELD = SdkField
            .<CmafIngestOutputSettings> builder(MarshallingType.SDK_POJO).memberName("CmafIngestOutputSettings")
            .getter(getter(OutputSettings::cmafIngestOutputSettings)).setter(setter(Builder::cmafIngestOutputSettings))
            .constructor(CmafIngestOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmafIngestOutputSettings").build())
            .build();

    private static final SdkField<SrtOutputSettings> SRT_OUTPUT_SETTINGS_FIELD = SdkField
            .<SrtOutputSettings> builder(MarshallingType.SDK_POJO).memberName("SrtOutputSettings")
            .getter(getter(OutputSettings::srtOutputSettings)).setter(setter(Builder::srtOutputSettings))
            .constructor(SrtOutputSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtOutputSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_OUTPUT_SETTINGS_FIELD,
            FRAME_CAPTURE_OUTPUT_SETTINGS_FIELD, HLS_OUTPUT_SETTINGS_FIELD, MEDIA_PACKAGE_OUTPUT_SETTINGS_FIELD,
            MS_SMOOTH_OUTPUT_SETTINGS_FIELD, MULTIPLEX_OUTPUT_SETTINGS_FIELD, RTMP_OUTPUT_SETTINGS_FIELD,
            UDP_OUTPUT_SETTINGS_FIELD, CMAF_INGEST_OUTPUT_SETTINGS_FIELD, SRT_OUTPUT_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ArchiveOutputSettings archiveOutputSettings;

    private final FrameCaptureOutputSettings frameCaptureOutputSettings;

    private final HlsOutputSettings hlsOutputSettings;

    private final MediaPackageOutputSettings mediaPackageOutputSettings;

    private final MsSmoothOutputSettings msSmoothOutputSettings;

    private final MultiplexOutputSettings multiplexOutputSettings;

    private final RtmpOutputSettings rtmpOutputSettings;

    private final UdpOutputSettings udpOutputSettings;

    private final CmafIngestOutputSettings cmafIngestOutputSettings;

    private final SrtOutputSettings srtOutputSettings;

    private OutputSettings(BuilderImpl builder) {
        this.archiveOutputSettings = builder.archiveOutputSettings;
        this.frameCaptureOutputSettings = builder.frameCaptureOutputSettings;
        this.hlsOutputSettings = builder.hlsOutputSettings;
        this.mediaPackageOutputSettings = builder.mediaPackageOutputSettings;
        this.msSmoothOutputSettings = builder.msSmoothOutputSettings;
        this.multiplexOutputSettings = builder.multiplexOutputSettings;
        this.rtmpOutputSettings = builder.rtmpOutputSettings;
        this.udpOutputSettings = builder.udpOutputSettings;
        this.cmafIngestOutputSettings = builder.cmafIngestOutputSettings;
        this.srtOutputSettings = builder.srtOutputSettings;
    }

    /**
     * Returns the value of the ArchiveOutputSettings property for this object.
     * 
     * @return The value of the ArchiveOutputSettings property for this object.
     */
    public final ArchiveOutputSettings archiveOutputSettings() {
        return archiveOutputSettings;
    }

    /**
     * Returns the value of the FrameCaptureOutputSettings property for this object.
     * 
     * @return The value of the FrameCaptureOutputSettings property for this object.
     */
    public final FrameCaptureOutputSettings frameCaptureOutputSettings() {
        return frameCaptureOutputSettings;
    }

    /**
     * Returns the value of the HlsOutputSettings property for this object.
     * 
     * @return The value of the HlsOutputSettings property for this object.
     */
    public final HlsOutputSettings hlsOutputSettings() {
        return hlsOutputSettings;
    }

    /**
     * Returns the value of the MediaPackageOutputSettings property for this object.
     * 
     * @return The value of the MediaPackageOutputSettings property for this object.
     */
    public final MediaPackageOutputSettings mediaPackageOutputSettings() {
        return mediaPackageOutputSettings;
    }

    /**
     * Returns the value of the MsSmoothOutputSettings property for this object.
     * 
     * @return The value of the MsSmoothOutputSettings property for this object.
     */
    public final MsSmoothOutputSettings msSmoothOutputSettings() {
        return msSmoothOutputSettings;
    }

    /**
     * Returns the value of the MultiplexOutputSettings property for this object.
     * 
     * @return The value of the MultiplexOutputSettings property for this object.
     */
    public final MultiplexOutputSettings multiplexOutputSettings() {
        return multiplexOutputSettings;
    }

    /**
     * Returns the value of the RtmpOutputSettings property for this object.
     * 
     * @return The value of the RtmpOutputSettings property for this object.
     */
    public final RtmpOutputSettings rtmpOutputSettings() {
        return rtmpOutputSettings;
    }

    /**
     * Returns the value of the UdpOutputSettings property for this object.
     * 
     * @return The value of the UdpOutputSettings property for this object.
     */
    public final UdpOutputSettings udpOutputSettings() {
        return udpOutputSettings;
    }

    /**
     * Returns the value of the CmafIngestOutputSettings property for this object.
     * 
     * @return The value of the CmafIngestOutputSettings property for this object.
     */
    public final CmafIngestOutputSettings cmafIngestOutputSettings() {
        return cmafIngestOutputSettings;
    }

    /**
     * Returns the value of the SrtOutputSettings property for this object.
     * 
     * @return The value of the SrtOutputSettings property for this object.
     */
    public final SrtOutputSettings srtOutputSettings() {
        return srtOutputSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(archiveOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(frameCaptureOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hlsOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(mediaPackageOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(msSmoothOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(multiplexOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(rtmpOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(udpOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(cmafIngestOutputSettings());
        hashCode = 31 * hashCode + Objects.hashCode(srtOutputSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSettings)) {
            return false;
        }
        OutputSettings other = (OutputSettings) obj;
        return Objects.equals(archiveOutputSettings(), other.archiveOutputSettings())
                && Objects.equals(frameCaptureOutputSettings(), other.frameCaptureOutputSettings())
                && Objects.equals(hlsOutputSettings(), other.hlsOutputSettings())
                && Objects.equals(mediaPackageOutputSettings(), other.mediaPackageOutputSettings())
                && Objects.equals(msSmoothOutputSettings(), other.msSmoothOutputSettings())
                && Objects.equals(multiplexOutputSettings(), other.multiplexOutputSettings())
                && Objects.equals(rtmpOutputSettings(), other.rtmpOutputSettings())
                && Objects.equals(udpOutputSettings(), other.udpOutputSettings())
                && Objects.equals(cmafIngestOutputSettings(), other.cmafIngestOutputSettings())
                && Objects.equals(srtOutputSettings(), other.srtOutputSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OutputSettings").add("ArchiveOutputSettings", archiveOutputSettings())
                .add("FrameCaptureOutputSettings", frameCaptureOutputSettings()).add("HlsOutputSettings", hlsOutputSettings())
                .add("MediaPackageOutputSettings", mediaPackageOutputSettings())
                .add("MsSmoothOutputSettings", msSmoothOutputSettings())
                .add("MultiplexOutputSettings", multiplexOutputSettings()).add("RtmpOutputSettings", rtmpOutputSettings())
                .add("UdpOutputSettings", udpOutputSettings()).add("CmafIngestOutputSettings", cmafIngestOutputSettings())
                .add("SrtOutputSettings", srtOutputSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveOutputSettings":
            return Optional.ofNullable(clazz.cast(archiveOutputSettings()));
        case "FrameCaptureOutputSettings":
            return Optional.ofNullable(clazz.cast(frameCaptureOutputSettings()));
        case "HlsOutputSettings":
            return Optional.ofNullable(clazz.cast(hlsOutputSettings()));
        case "MediaPackageOutputSettings":
            return Optional.ofNullable(clazz.cast(mediaPackageOutputSettings()));
        case "MsSmoothOutputSettings":
            return Optional.ofNullable(clazz.cast(msSmoothOutputSettings()));
        case "MultiplexOutputSettings":
            return Optional.ofNullable(clazz.cast(multiplexOutputSettings()));
        case "RtmpOutputSettings":
            return Optional.ofNullable(clazz.cast(rtmpOutputSettings()));
        case "UdpOutputSettings":
            return Optional.ofNullable(clazz.cast(udpOutputSettings()));
        case "CmafIngestOutputSettings":
            return Optional.ofNullable(clazz.cast(cmafIngestOutputSettings()));
        case "SrtOutputSettings":
            return Optional.ofNullable(clazz.cast(srtOutputSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("archiveOutputSettings", ARCHIVE_OUTPUT_SETTINGS_FIELD);
        map.put("frameCaptureOutputSettings", FRAME_CAPTURE_OUTPUT_SETTINGS_FIELD);
        map.put("hlsOutputSettings", HLS_OUTPUT_SETTINGS_FIELD);
        map.put("mediaPackageOutputSettings", MEDIA_PACKAGE_OUTPUT_SETTINGS_FIELD);
        map.put("msSmoothOutputSettings", MS_SMOOTH_OUTPUT_SETTINGS_FIELD);
        map.put("multiplexOutputSettings", MULTIPLEX_OUTPUT_SETTINGS_FIELD);
        map.put("rtmpOutputSettings", RTMP_OUTPUT_SETTINGS_FIELD);
        map.put("udpOutputSettings", UDP_OUTPUT_SETTINGS_FIELD);
        map.put("cmafIngestOutputSettings", CMAF_INGEST_OUTPUT_SETTINGS_FIELD);
        map.put("srtOutputSettings", SRT_OUTPUT_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputSettings, T> g) {
        return obj -> g.apply((OutputSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OutputSettings> {
        /**
         * Sets the value of the ArchiveOutputSettings property for this object.
         *
         * @param archiveOutputSettings
         *        The new value for the ArchiveOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveOutputSettings(ArchiveOutputSettings archiveOutputSettings);

        /**
         * Sets the value of the ArchiveOutputSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ArchiveOutputSettings.Builder} avoiding
         * the need to create one manually via {@link ArchiveOutputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchiveOutputSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #archiveOutputSettings(ArchiveOutputSettings)}.
         * 
         * @param archiveOutputSettings
         *        a consumer that will call methods on {@link ArchiveOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archiveOutputSettings(ArchiveOutputSettings)
         */
        default Builder archiveOutputSettings(Consumer<ArchiveOutputSettings.Builder> archiveOutputSettings) {
            return archiveOutputSettings(ArchiveOutputSettings.builder().applyMutation(archiveOutputSettings).build());
        }

        /**
         * Sets the value of the FrameCaptureOutputSettings property for this object.
         *
         * @param frameCaptureOutputSettings
         *        The new value for the FrameCaptureOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameCaptureOutputSettings(FrameCaptureOutputSettings frameCaptureOutputSettings);

        /**
         * Sets the value of the FrameCaptureOutputSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link FrameCaptureOutputSettings.Builder}
         * avoiding the need to create one manually via {@link FrameCaptureOutputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FrameCaptureOutputSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #frameCaptureOutputSettings(FrameCaptureOutputSettings)}.
         * 
         * @param frameCaptureOutputSettings
         *        a consumer that will call methods on {@link FrameCaptureOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameCaptureOutputSettings(FrameCaptureOutputSettings)
         */
        default Builder frameCaptureOutputSettings(Consumer<FrameCaptureOutputSettings.Builder> frameCaptureOutputSettings) {
            return frameCaptureOutputSettings(FrameCaptureOutputSettings.builder().applyMutation(frameCaptureOutputSettings)
                    .build());
        }

        /**
         * Sets the value of the HlsOutputSettings property for this object.
         *
         * @param hlsOutputSettings
         *        The new value for the HlsOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsOutputSettings(HlsOutputSettings hlsOutputSettings);

        /**
         * Sets the value of the HlsOutputSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link HlsOutputSettings.Builder} avoiding the
         * need to create one manually via {@link HlsOutputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HlsOutputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #hlsOutputSettings(HlsOutputSettings)}.
         * 
         * @param hlsOutputSettings
         *        a consumer that will call methods on {@link HlsOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsOutputSettings(HlsOutputSettings)
         */
        default Builder hlsOutputSettings(Consumer<HlsOutputSettings.Builder> hlsOutputSettings) {
            return hlsOutputSettings(HlsOutputSettings.builder().applyMutation(hlsOutputSettings).build());
        }

        /**
         * Sets the value of the MediaPackageOutputSettings property for this object.
         *
         * @param mediaPackageOutputSettings
         *        The new value for the MediaPackageOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaPackageOutputSettings(MediaPackageOutputSettings mediaPackageOutputSettings);

        /**
         * Sets the value of the MediaPackageOutputSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MediaPackageOutputSettings.Builder}
         * avoiding the need to create one manually via {@link MediaPackageOutputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaPackageOutputSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaPackageOutputSettings(MediaPackageOutputSettings)}.
         * 
         * @param mediaPackageOutputSettings
         *        a consumer that will call methods on {@link MediaPackageOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaPackageOutputSettings(MediaPackageOutputSettings)
         */
        default Builder mediaPackageOutputSettings(Consumer<MediaPackageOutputSettings.Builder> mediaPackageOutputSettings) {
            return mediaPackageOutputSettings(MediaPackageOutputSettings.builder().applyMutation(mediaPackageOutputSettings)
                    .build());
        }

        /**
         * Sets the value of the MsSmoothOutputSettings property for this object.
         *
         * @param msSmoothOutputSettings
         *        The new value for the MsSmoothOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder msSmoothOutputSettings(MsSmoothOutputSettings msSmoothOutputSettings);

        /**
         * Sets the value of the MsSmoothOutputSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MsSmoothOutputSettings.Builder} avoiding
         * the need to create one manually via {@link MsSmoothOutputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MsSmoothOutputSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #msSmoothOutputSettings(MsSmoothOutputSettings)}.
         * 
         * @param msSmoothOutputSettings
         *        a consumer that will call methods on {@link MsSmoothOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #msSmoothOutputSettings(MsSmoothOutputSettings)
         */
        default Builder msSmoothOutputSettings(Consumer<MsSmoothOutputSettings.Builder> msSmoothOutputSettings) {
            return msSmoothOutputSettings(MsSmoothOutputSettings.builder().applyMutation(msSmoothOutputSettings).build());
        }

        /**
         * Sets the value of the MultiplexOutputSettings property for this object.
         *
         * @param multiplexOutputSettings
         *        The new value for the MultiplexOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiplexOutputSettings(MultiplexOutputSettings multiplexOutputSettings);

        /**
         * Sets the value of the MultiplexOutputSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MultiplexOutputSettings.Builder} avoiding
         * the need to create one manually via {@link MultiplexOutputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MultiplexOutputSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #multiplexOutputSettings(MultiplexOutputSettings)}.
         * 
         * @param multiplexOutputSettings
         *        a consumer that will call methods on {@link MultiplexOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiplexOutputSettings(MultiplexOutputSettings)
         */
        default Builder multiplexOutputSettings(Consumer<MultiplexOutputSettings.Builder> multiplexOutputSettings) {
            return multiplexOutputSettings(MultiplexOutputSettings.builder().applyMutation(multiplexOutputSettings).build());
        }

        /**
         * Sets the value of the RtmpOutputSettings property for this object.
         *
         * @param rtmpOutputSettings
         *        The new value for the RtmpOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rtmpOutputSettings(RtmpOutputSettings rtmpOutputSettings);

        /**
         * Sets the value of the RtmpOutputSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RtmpOutputSettings.Builder} avoiding the
         * need to create one manually via {@link RtmpOutputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RtmpOutputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #rtmpOutputSettings(RtmpOutputSettings)}.
         * 
         * @param rtmpOutputSettings
         *        a consumer that will call methods on {@link RtmpOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rtmpOutputSettings(RtmpOutputSettings)
         */
        default Builder rtmpOutputSettings(Consumer<RtmpOutputSettings.Builder> rtmpOutputSettings) {
            return rtmpOutputSettings(RtmpOutputSettings.builder().applyMutation(rtmpOutputSettings).build());
        }

        /**
         * Sets the value of the UdpOutputSettings property for this object.
         *
         * @param udpOutputSettings
         *        The new value for the UdpOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder udpOutputSettings(UdpOutputSettings udpOutputSettings);

        /**
         * Sets the value of the UdpOutputSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UdpOutputSettings.Builder} avoiding the
         * need to create one manually via {@link UdpOutputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UdpOutputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #udpOutputSettings(UdpOutputSettings)}.
         * 
         * @param udpOutputSettings
         *        a consumer that will call methods on {@link UdpOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #udpOutputSettings(UdpOutputSettings)
         */
        default Builder udpOutputSettings(Consumer<UdpOutputSettings.Builder> udpOutputSettings) {
            return udpOutputSettings(UdpOutputSettings.builder().applyMutation(udpOutputSettings).build());
        }

        /**
         * Sets the value of the CmafIngestOutputSettings property for this object.
         *
         * @param cmafIngestOutputSettings
         *        The new value for the CmafIngestOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cmafIngestOutputSettings(CmafIngestOutputSettings cmafIngestOutputSettings);

        /**
         * Sets the value of the CmafIngestOutputSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CmafIngestOutputSettings.Builder}
         * avoiding the need to create one manually via {@link CmafIngestOutputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CmafIngestOutputSettings.Builder#build()} is called immediately
         * and its result is passed to {@link #cmafIngestOutputSettings(CmafIngestOutputSettings)}.
         * 
         * @param cmafIngestOutputSettings
         *        a consumer that will call methods on {@link CmafIngestOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cmafIngestOutputSettings(CmafIngestOutputSettings)
         */
        default Builder cmafIngestOutputSettings(Consumer<CmafIngestOutputSettings.Builder> cmafIngestOutputSettings) {
            return cmafIngestOutputSettings(CmafIngestOutputSettings.builder().applyMutation(cmafIngestOutputSettings).build());
        }

        /**
         * Sets the value of the SrtOutputSettings property for this object.
         *
         * @param srtOutputSettings
         *        The new value for the SrtOutputSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder srtOutputSettings(SrtOutputSettings srtOutputSettings);

        /**
         * Sets the value of the SrtOutputSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SrtOutputSettings.Builder} avoiding the
         * need to create one manually via {@link SrtOutputSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SrtOutputSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #srtOutputSettings(SrtOutputSettings)}.
         * 
         * @param srtOutputSettings
         *        a consumer that will call methods on {@link SrtOutputSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #srtOutputSettings(SrtOutputSettings)
         */
        default Builder srtOutputSettings(Consumer<SrtOutputSettings.Builder> srtOutputSettings) {
            return srtOutputSettings(SrtOutputSettings.builder().applyMutation(srtOutputSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ArchiveOutputSettings archiveOutputSettings;

        private FrameCaptureOutputSettings frameCaptureOutputSettings;

        private HlsOutputSettings hlsOutputSettings;

        private MediaPackageOutputSettings mediaPackageOutputSettings;

        private MsSmoothOutputSettings msSmoothOutputSettings;

        private MultiplexOutputSettings multiplexOutputSettings;

        private RtmpOutputSettings rtmpOutputSettings;

        private UdpOutputSettings udpOutputSettings;

        private CmafIngestOutputSettings cmafIngestOutputSettings;

        private SrtOutputSettings srtOutputSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputSettings model) {
            archiveOutputSettings(model.archiveOutputSettings);
            frameCaptureOutputSettings(model.frameCaptureOutputSettings);
            hlsOutputSettings(model.hlsOutputSettings);
            mediaPackageOutputSettings(model.mediaPackageOutputSettings);
            msSmoothOutputSettings(model.msSmoothOutputSettings);
            multiplexOutputSettings(model.multiplexOutputSettings);
            rtmpOutputSettings(model.rtmpOutputSettings);
            udpOutputSettings(model.udpOutputSettings);
            cmafIngestOutputSettings(model.cmafIngestOutputSettings);
            srtOutputSettings(model.srtOutputSettings);
        }

        public final ArchiveOutputSettings.Builder getArchiveOutputSettings() {
            return archiveOutputSettings != null ? archiveOutputSettings.toBuilder() : null;
        }

        public final void setArchiveOutputSettings(ArchiveOutputSettings.BuilderImpl archiveOutputSettings) {
            this.archiveOutputSettings = archiveOutputSettings != null ? archiveOutputSettings.build() : null;
        }

        @Override
        public final Builder archiveOutputSettings(ArchiveOutputSettings archiveOutputSettings) {
            this.archiveOutputSettings = archiveOutputSettings;
            return this;
        }

        public final FrameCaptureOutputSettings.Builder getFrameCaptureOutputSettings() {
            return frameCaptureOutputSettings != null ? frameCaptureOutputSettings.toBuilder() : null;
        }

        public final void setFrameCaptureOutputSettings(FrameCaptureOutputSettings.BuilderImpl frameCaptureOutputSettings) {
            this.frameCaptureOutputSettings = frameCaptureOutputSettings != null ? frameCaptureOutputSettings.build() : null;
        }

        @Override
        public final Builder frameCaptureOutputSettings(FrameCaptureOutputSettings frameCaptureOutputSettings) {
            this.frameCaptureOutputSettings = frameCaptureOutputSettings;
            return this;
        }

        public final HlsOutputSettings.Builder getHlsOutputSettings() {
            return hlsOutputSettings != null ? hlsOutputSettings.toBuilder() : null;
        }

        public final void setHlsOutputSettings(HlsOutputSettings.BuilderImpl hlsOutputSettings) {
            this.hlsOutputSettings = hlsOutputSettings != null ? hlsOutputSettings.build() : null;
        }

        @Override
        public final Builder hlsOutputSettings(HlsOutputSettings hlsOutputSettings) {
            this.hlsOutputSettings = hlsOutputSettings;
            return this;
        }

        public final MediaPackageOutputSettings.Builder getMediaPackageOutputSettings() {
            return mediaPackageOutputSettings != null ? mediaPackageOutputSettings.toBuilder() : null;
        }

        public final void setMediaPackageOutputSettings(MediaPackageOutputSettings.BuilderImpl mediaPackageOutputSettings) {
            this.mediaPackageOutputSettings = mediaPackageOutputSettings != null ? mediaPackageOutputSettings.build() : null;
        }

        @Override
        public final Builder mediaPackageOutputSettings(MediaPackageOutputSettings mediaPackageOutputSettings) {
            this.mediaPackageOutputSettings = mediaPackageOutputSettings;
            return this;
        }

        public final MsSmoothOutputSettings.Builder getMsSmoothOutputSettings() {
            return msSmoothOutputSettings != null ? msSmoothOutputSettings.toBuilder() : null;
        }

        public final void setMsSmoothOutputSettings(MsSmoothOutputSettings.BuilderImpl msSmoothOutputSettings) {
            this.msSmoothOutputSettings = msSmoothOutputSettings != null ? msSmoothOutputSettings.build() : null;
        }

        @Override
        public final Builder msSmoothOutputSettings(MsSmoothOutputSettings msSmoothOutputSettings) {
            this.msSmoothOutputSettings = msSmoothOutputSettings;
            return this;
        }

        public final MultiplexOutputSettings.Builder getMultiplexOutputSettings() {
            return multiplexOutputSettings != null ? multiplexOutputSettings.toBuilder() : null;
        }

        public final void setMultiplexOutputSettings(MultiplexOutputSettings.BuilderImpl multiplexOutputSettings) {
            this.multiplexOutputSettings = multiplexOutputSettings != null ? multiplexOutputSettings.build() : null;
        }

        @Override
        public final Builder multiplexOutputSettings(MultiplexOutputSettings multiplexOutputSettings) {
            this.multiplexOutputSettings = multiplexOutputSettings;
            return this;
        }

        public final RtmpOutputSettings.Builder getRtmpOutputSettings() {
            return rtmpOutputSettings != null ? rtmpOutputSettings.toBuilder() : null;
        }

        public final void setRtmpOutputSettings(RtmpOutputSettings.BuilderImpl rtmpOutputSettings) {
            this.rtmpOutputSettings = rtmpOutputSettings != null ? rtmpOutputSettings.build() : null;
        }

        @Override
        public final Builder rtmpOutputSettings(RtmpOutputSettings rtmpOutputSettings) {
            this.rtmpOutputSettings = rtmpOutputSettings;
            return this;
        }

        public final UdpOutputSettings.Builder getUdpOutputSettings() {
            return udpOutputSettings != null ? udpOutputSettings.toBuilder() : null;
        }

        public final void setUdpOutputSettings(UdpOutputSettings.BuilderImpl udpOutputSettings) {
            this.udpOutputSettings = udpOutputSettings != null ? udpOutputSettings.build() : null;
        }

        @Override
        public final Builder udpOutputSettings(UdpOutputSettings udpOutputSettings) {
            this.udpOutputSettings = udpOutputSettings;
            return this;
        }

        public final CmafIngestOutputSettings.Builder getCmafIngestOutputSettings() {
            return cmafIngestOutputSettings != null ? cmafIngestOutputSettings.toBuilder() : null;
        }

        public final void setCmafIngestOutputSettings(CmafIngestOutputSettings.BuilderImpl cmafIngestOutputSettings) {
            this.cmafIngestOutputSettings = cmafIngestOutputSettings != null ? cmafIngestOutputSettings.build() : null;
        }

        @Override
        public final Builder cmafIngestOutputSettings(CmafIngestOutputSettings cmafIngestOutputSettings) {
            this.cmafIngestOutputSettings = cmafIngestOutputSettings;
            return this;
        }

        public final SrtOutputSettings.Builder getSrtOutputSettings() {
            return srtOutputSettings != null ? srtOutputSettings.toBuilder() : null;
        }

        public final void setSrtOutputSettings(SrtOutputSettings.BuilderImpl srtOutputSettings) {
            this.srtOutputSettings = srtOutputSettings != null ? srtOutputSettings.build() : null;
        }

        @Override
        public final Builder srtOutputSettings(SrtOutputSettings srtOutputSettings) {
            this.srtOutputSettings = srtOutputSettings;
            return this;
        }

        @Override
        public OutputSettings build() {
            return new OutputSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
