/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for the action to deactivate the image in a specific layer.
 */
@Generated("software.amazon.awssdk:codegen")
public final class StaticImageDeactivateScheduleActionSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<StaticImageDeactivateScheduleActionSettings.Builder, StaticImageDeactivateScheduleActionSettings> {
    private static final SdkField<Integer> FADE_OUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FadeOut").getter(getter(StaticImageDeactivateScheduleActionSettings::fadeOut))
            .setter(setter(Builder::fadeOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fadeOut").build()).build();

    private static final SdkField<Integer> LAYER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Layer")
            .getter(getter(StaticImageDeactivateScheduleActionSettings::layer)).setter(setter(Builder::layer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FADE_OUT_FIELD, LAYER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer fadeOut;

    private final Integer layer;

    private StaticImageDeactivateScheduleActionSettings(BuilderImpl builder) {
        this.fadeOut = builder.fadeOut;
        this.layer = builder.layer;
    }

    /**
     * The time in milliseconds for the image to fade out. Default is 0 (no fade-out).
     * 
     * @return The time in milliseconds for the image to fade out. Default is 0 (no fade-out).
     */
    public final Integer fadeOut() {
        return fadeOut;
    }

    /**
     * The image overlay layer to deactivate, 0 to 7. Default is 0.
     * 
     * @return The image overlay layer to deactivate, 0 to 7. Default is 0.
     */
    public final Integer layer() {
        return layer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fadeOut());
        hashCode = 31 * hashCode + Objects.hashCode(layer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticImageDeactivateScheduleActionSettings)) {
            return false;
        }
        StaticImageDeactivateScheduleActionSettings other = (StaticImageDeactivateScheduleActionSettings) obj;
        return Objects.equals(fadeOut(), other.fadeOut()) && Objects.equals(layer(), other.layer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StaticImageDeactivateScheduleActionSettings").add("FadeOut", fadeOut()).add("Layer", layer())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FadeOut":
            return Optional.ofNullable(clazz.cast(fadeOut()));
        case "Layer":
            return Optional.ofNullable(clazz.cast(layer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fadeOut", FADE_OUT_FIELD);
        map.put("layer", LAYER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StaticImageDeactivateScheduleActionSettings, T> g) {
        return obj -> g.apply((StaticImageDeactivateScheduleActionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StaticImageDeactivateScheduleActionSettings> {
        /**
         * The time in milliseconds for the image to fade out. Default is 0 (no fade-out).
         * 
         * @param fadeOut
         *        The time in milliseconds for the image to fade out. Default is 0 (no fade-out).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fadeOut(Integer fadeOut);

        /**
         * The image overlay layer to deactivate, 0 to 7. Default is 0.
         * 
         * @param layer
         *        The image overlay layer to deactivate, 0 to 7. Default is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layer(Integer layer);
    }

    static final class BuilderImpl implements Builder {
        private Integer fadeOut;

        private Integer layer;

        private BuilderImpl() {
        }

        private BuilderImpl(StaticImageDeactivateScheduleActionSettings model) {
            fadeOut(model.fadeOut);
            layer(model.layer);
        }

        public final Integer getFadeOut() {
            return fadeOut;
        }

        public final void setFadeOut(Integer fadeOut) {
            this.fadeOut = fadeOut;
        }

        @Override
        public final Builder fadeOut(Integer fadeOut) {
            this.fadeOut = fadeOut;
            return this;
        }

        public final Integer getLayer() {
            return layer;
        }

        public final void setLayer(Integer layer) {
            this.layer = layer;
        }

        @Override
        public final Builder layer(Integer layer) {
            this.layer = layer;
            return this;
        }

        @Override
        public StaticImageDeactivateScheduleActionSettings build() {
            return new StaticImageDeactivateScheduleActionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
