/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings for the action to deactivate the image in a specific layer.
 */
@Generated("software.amazon.awssdk:codegen")
public final class StaticImageOutputDeactivateScheduleActionSettings
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<StaticImageOutputDeactivateScheduleActionSettings.Builder, StaticImageOutputDeactivateScheduleActionSettings> {
    private static final SdkField<Integer> FADE_OUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FadeOut").getter(getter(StaticImageOutputDeactivateScheduleActionSettings::fadeOut))
            .setter(setter(Builder::fadeOut))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fadeOut").build()).build();

    private static final SdkField<Integer> LAYER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Layer")
            .getter(getter(StaticImageOutputDeactivateScheduleActionSettings::layer)).setter(setter(Builder::layer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layer").build()).build();

    private static final SdkField<List<String>> OUTPUT_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OutputNames")
            .getter(getter(StaticImageOutputDeactivateScheduleActionSettings::outputNames))
            .setter(setter(Builder::outputNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FADE_OUT_FIELD, LAYER_FIELD,
            OUTPUT_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer fadeOut;

    private final Integer layer;

    private final List<String> outputNames;

    private StaticImageOutputDeactivateScheduleActionSettings(BuilderImpl builder) {
        this.fadeOut = builder.fadeOut;
        this.layer = builder.layer;
        this.outputNames = builder.outputNames;
    }

    /**
     * The time in milliseconds for the image to fade out. Default is 0 (no fade-out).
     * 
     * @return The time in milliseconds for the image to fade out. Default is 0 (no fade-out).
     */
    public final Integer fadeOut() {
        return fadeOut;
    }

    /**
     * The image overlay layer to deactivate, 0 to 7. Default is 0.
     * 
     * @return The image overlay layer to deactivate, 0 to 7. Default is 0.
     */
    public final Integer layer() {
        return layer;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputNames() {
        return outputNames != null && !(outputNames instanceof SdkAutoConstructList);
    }

    /**
     * The name(s) of the output(s) the deactivation should apply to.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputNames} method.
     * </p>
     * 
     * @return The name(s) of the output(s) the deactivation should apply to.
     */
    public final List<String> outputNames() {
        return outputNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fadeOut());
        hashCode = 31 * hashCode + Objects.hashCode(layer());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputNames() ? outputNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StaticImageOutputDeactivateScheduleActionSettings)) {
            return false;
        }
        StaticImageOutputDeactivateScheduleActionSettings other = (StaticImageOutputDeactivateScheduleActionSettings) obj;
        return Objects.equals(fadeOut(), other.fadeOut()) && Objects.equals(layer(), other.layer())
                && hasOutputNames() == other.hasOutputNames() && Objects.equals(outputNames(), other.outputNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StaticImageOutputDeactivateScheduleActionSettings").add("FadeOut", fadeOut())
                .add("Layer", layer()).add("OutputNames", hasOutputNames() ? outputNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FadeOut":
            return Optional.ofNullable(clazz.cast(fadeOut()));
        case "Layer":
            return Optional.ofNullable(clazz.cast(layer()));
        case "OutputNames":
            return Optional.ofNullable(clazz.cast(outputNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fadeOut", FADE_OUT_FIELD);
        map.put("layer", LAYER_FIELD);
        map.put("outputNames", OUTPUT_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StaticImageOutputDeactivateScheduleActionSettings, T> g) {
        return obj -> g.apply((StaticImageOutputDeactivateScheduleActionSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StaticImageOutputDeactivateScheduleActionSettings> {
        /**
         * The time in milliseconds for the image to fade out. Default is 0 (no fade-out).
         * 
         * @param fadeOut
         *        The time in milliseconds for the image to fade out. Default is 0 (no fade-out).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fadeOut(Integer fadeOut);

        /**
         * The image overlay layer to deactivate, 0 to 7. Default is 0.
         * 
         * @param layer
         *        The image overlay layer to deactivate, 0 to 7. Default is 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layer(Integer layer);

        /**
         * The name(s) of the output(s) the deactivation should apply to.
         * 
         * @param outputNames
         *        The name(s) of the output(s) the deactivation should apply to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputNames(Collection<String> outputNames);

        /**
         * The name(s) of the output(s) the deactivation should apply to.
         * 
         * @param outputNames
         *        The name(s) of the output(s) the deactivation should apply to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputNames(String... outputNames);
    }

    static final class BuilderImpl implements Builder {
        private Integer fadeOut;

        private Integer layer;

        private List<String> outputNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StaticImageOutputDeactivateScheduleActionSettings model) {
            fadeOut(model.fadeOut);
            layer(model.layer);
            outputNames(model.outputNames);
        }

        public final Integer getFadeOut() {
            return fadeOut;
        }

        public final void setFadeOut(Integer fadeOut) {
            this.fadeOut = fadeOut;
        }

        @Override
        public final Builder fadeOut(Integer fadeOut) {
            this.fadeOut = fadeOut;
            return this;
        }

        public final Integer getLayer() {
            return layer;
        }

        public final void setLayer(Integer layer) {
            this.layer = layer;
        }

        @Override
        public final Builder layer(Integer layer) {
            this.layer = layer;
            return this;
        }

        public final Collection<String> getOutputNames() {
            if (outputNames instanceof SdkAutoConstructList) {
                return null;
            }
            return outputNames;
        }

        public final void setOutputNames(Collection<String> outputNames) {
            this.outputNames = ___listOf__stringCopier.copy(outputNames);
        }

        @Override
        public final Builder outputNames(Collection<String> outputNames) {
            this.outputNames = ___listOf__stringCopier.copy(outputNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputNames(String... outputNames) {
            outputNames(Arrays.asList(outputNames));
            return this;
        }

        @Override
        public StaticImageOutputDeactivateScheduleActionSettings build() {
            return new StaticImageOutputDeactivateScheduleActionSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
