/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Temporal Filter Settings
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemporalFilterSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TemporalFilterSettings.Builder, TemporalFilterSettings> {
    private static final SdkField<String> POST_FILTER_SHARPENING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostFilterSharpening").getter(getter(TemporalFilterSettings::postFilterSharpeningAsString))
            .setter(setter(Builder::postFilterSharpening))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postFilterSharpening").build())
            .build();

    private static final SdkField<String> STRENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Strength").getter(getter(TemporalFilterSettings::strengthAsString)).setter(setter(Builder::strength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POST_FILTER_SHARPENING_FIELD,
            STRENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String postFilterSharpening;

    private final String strength;

    private TemporalFilterSettings(BuilderImpl builder) {
        this.postFilterSharpening = builder.postFilterSharpening;
        this.strength = builder.strength;
    }

    /**
     * If you enable this filter, the results are the following: - If the source content is noisy (it contains excessive
     * digital artifacts), the filter cleans up the source. - If the source content is already clean, the filter tends
     * to decrease the bitrate, especially when the rate control mode is QVBR.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #postFilterSharpening} will return {@link TemporalFilterPostFilterSharpening#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #postFilterSharpeningAsString}.
     * </p>
     * 
     * @return If you enable this filter, the results are the following: - If the source content is noisy (it contains
     *         excessive digital artifacts), the filter cleans up the source. - If the source content is already clean,
     *         the filter tends to decrease the bitrate, especially when the rate control mode is QVBR.
     * @see TemporalFilterPostFilterSharpening
     */
    public final TemporalFilterPostFilterSharpening postFilterSharpening() {
        return TemporalFilterPostFilterSharpening.fromValue(postFilterSharpening);
    }

    /**
     * If you enable this filter, the results are the following: - If the source content is noisy (it contains excessive
     * digital artifacts), the filter cleans up the source. - If the source content is already clean, the filter tends
     * to decrease the bitrate, especially when the rate control mode is QVBR.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #postFilterSharpening} will return {@link TemporalFilterPostFilterSharpening#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #postFilterSharpeningAsString}.
     * </p>
     * 
     * @return If you enable this filter, the results are the following: - If the source content is noisy (it contains
     *         excessive digital artifacts), the filter cleans up the source. - If the source content is already clean,
     *         the filter tends to decrease the bitrate, especially when the rate control mode is QVBR.
     * @see TemporalFilterPostFilterSharpening
     */
    public final String postFilterSharpeningAsString() {
        return postFilterSharpening;
    }

    /**
     * Choose a filter strength. We recommend a strength of 1 or 2. A higher strength might take out good information,
     * resulting in an image that is overly soft.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strength} will
     * return {@link TemporalFilterStrength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #strengthAsString}.
     * </p>
     * 
     * @return Choose a filter strength. We recommend a strength of 1 or 2. A higher strength might take out good
     *         information, resulting in an image that is overly soft.
     * @see TemporalFilterStrength
     */
    public final TemporalFilterStrength strength() {
        return TemporalFilterStrength.fromValue(strength);
    }

    /**
     * Choose a filter strength. We recommend a strength of 1 or 2. A higher strength might take out good information,
     * resulting in an image that is overly soft.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #strength} will
     * return {@link TemporalFilterStrength#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #strengthAsString}.
     * </p>
     * 
     * @return Choose a filter strength. We recommend a strength of 1 or 2. A higher strength might take out good
     *         information, resulting in an image that is overly soft.
     * @see TemporalFilterStrength
     */
    public final String strengthAsString() {
        return strength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(postFilterSharpeningAsString());
        hashCode = 31 * hashCode + Objects.hashCode(strengthAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemporalFilterSettings)) {
            return false;
        }
        TemporalFilterSettings other = (TemporalFilterSettings) obj;
        return Objects.equals(postFilterSharpeningAsString(), other.postFilterSharpeningAsString())
                && Objects.equals(strengthAsString(), other.strengthAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemporalFilterSettings").add("PostFilterSharpening", postFilterSharpeningAsString())
                .add("Strength", strengthAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PostFilterSharpening":
            return Optional.ofNullable(clazz.cast(postFilterSharpeningAsString()));
        case "Strength":
            return Optional.ofNullable(clazz.cast(strengthAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("postFilterSharpening", POST_FILTER_SHARPENING_FIELD);
        map.put("strength", STRENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TemporalFilterSettings, T> g) {
        return obj -> g.apply((TemporalFilterSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemporalFilterSettings> {
        /**
         * If you enable this filter, the results are the following: - If the source content is noisy (it contains
         * excessive digital artifacts), the filter cleans up the source. - If the source content is already clean, the
         * filter tends to decrease the bitrate, especially when the rate control mode is QVBR.
         * 
         * @param postFilterSharpening
         *        If you enable this filter, the results are the following: - If the source content is noisy (it
         *        contains excessive digital artifacts), the filter cleans up the source. - If the source content is
         *        already clean, the filter tends to decrease the bitrate, especially when the rate control mode is
         *        QVBR.
         * @see TemporalFilterPostFilterSharpening
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemporalFilterPostFilterSharpening
         */
        Builder postFilterSharpening(String postFilterSharpening);

        /**
         * If you enable this filter, the results are the following: - If the source content is noisy (it contains
         * excessive digital artifacts), the filter cleans up the source. - If the source content is already clean, the
         * filter tends to decrease the bitrate, especially when the rate control mode is QVBR.
         * 
         * @param postFilterSharpening
         *        If you enable this filter, the results are the following: - If the source content is noisy (it
         *        contains excessive digital artifacts), the filter cleans up the source. - If the source content is
         *        already clean, the filter tends to decrease the bitrate, especially when the rate control mode is
         *        QVBR.
         * @see TemporalFilterPostFilterSharpening
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemporalFilterPostFilterSharpening
         */
        Builder postFilterSharpening(TemporalFilterPostFilterSharpening postFilterSharpening);

        /**
         * Choose a filter strength. We recommend a strength of 1 or 2. A higher strength might take out good
         * information, resulting in an image that is overly soft.
         * 
         * @param strength
         *        Choose a filter strength. We recommend a strength of 1 or 2. A higher strength might take out good
         *        information, resulting in an image that is overly soft.
         * @see TemporalFilterStrength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemporalFilterStrength
         */
        Builder strength(String strength);

        /**
         * Choose a filter strength. We recommend a strength of 1 or 2. A higher strength might take out good
         * information, resulting in an image that is overly soft.
         * 
         * @param strength
         *        Choose a filter strength. We recommend a strength of 1 or 2. A higher strength might take out good
         *        information, resulting in an image that is overly soft.
         * @see TemporalFilterStrength
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TemporalFilterStrength
         */
        Builder strength(TemporalFilterStrength strength);
    }

    static final class BuilderImpl implements Builder {
        private String postFilterSharpening;

        private String strength;

        private BuilderImpl() {
        }

        private BuilderImpl(TemporalFilterSettings model) {
            postFilterSharpening(model.postFilterSharpening);
            strength(model.strength);
        }

        public final String getPostFilterSharpening() {
            return postFilterSharpening;
        }

        public final void setPostFilterSharpening(String postFilterSharpening) {
            this.postFilterSharpening = postFilterSharpening;
        }

        @Override
        public final Builder postFilterSharpening(String postFilterSharpening) {
            this.postFilterSharpening = postFilterSharpening;
            return this;
        }

        @Override
        public final Builder postFilterSharpening(TemporalFilterPostFilterSharpening postFilterSharpening) {
            this.postFilterSharpening(postFilterSharpening == null ? null : postFilterSharpening.toString());
            return this;
        }

        public final String getStrength() {
            return strength;
        }

        public final void setStrength(String strength) {
            this.strength = strength;
        }

        @Override
        public final Builder strength(String strength) {
            this.strength = strength;
            return this;
        }

        @Override
        public final Builder strength(TemporalFilterStrength strength) {
            this.strength(strength == null ? null : strength.toString());
            return this;
        }

        @Override
        public TemporalFilterSettings build() {
            return new TemporalFilterSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
