/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Timecode Config
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimecodeConfig implements SdkPojo, Serializable, ToCopyableBuilder<TimecodeConfig.Builder, TimecodeConfig> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(TimecodeConfig::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<Integer> SYNC_THRESHOLD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SyncThreshold").getter(getter(TimecodeConfig::syncThreshold)).setter(setter(Builder::syncThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncThreshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            SYNC_THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String source;

    private final Integer syncThreshold;

    private TimecodeConfig(BuilderImpl builder) {
        this.source = builder.source;
        this.syncThreshold = builder.syncThreshold;
    }

    /**
     * Identifies the source for the timecode that will be associated with the events outputs. -Embedded (embedded):
     * Initialize the output timecode with timecode from the the source. If no embedded timecode is detected in the
     * source, the system falls back to using "Start at 0" (zerobased). -System Clock (systemclock): Use the UTC time.
     * -Start at 0 (zerobased): The time of the first frame of the event will be 00:00:00:00.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link TimecodeConfigSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceAsString}.
     * </p>
     * 
     * @return Identifies the source for the timecode that will be associated with the events outputs. -Embedded
     *         (embedded): Initialize the output timecode with timecode from the the source. If no embedded timecode is
     *         detected in the source, the system falls back to using "Start at 0" (zerobased). -System Clock
     *         (systemclock): Use the UTC time. -Start at 0 (zerobased): The time of the first frame of the event will
     *         be 00:00:00:00.
     * @see TimecodeConfigSource
     */
    public final TimecodeConfigSource source() {
        return TimecodeConfigSource.fromValue(source);
    }

    /**
     * Identifies the source for the timecode that will be associated with the events outputs. -Embedded (embedded):
     * Initialize the output timecode with timecode from the the source. If no embedded timecode is detected in the
     * source, the system falls back to using "Start at 0" (zerobased). -System Clock (systemclock): Use the UTC time.
     * -Start at 0 (zerobased): The time of the first frame of the event will be 00:00:00:00.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link TimecodeConfigSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceAsString}.
     * </p>
     * 
     * @return Identifies the source for the timecode that will be associated with the events outputs. -Embedded
     *         (embedded): Initialize the output timecode with timecode from the the source. If no embedded timecode is
     *         detected in the source, the system falls back to using "Start at 0" (zerobased). -System Clock
     *         (systemclock): Use the UTC time. -Start at 0 (zerobased): The time of the first frame of the event will
     *         be 00:00:00:00.
     * @see TimecodeConfigSource
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * Threshold in frames beyond which output timecode is resynchronized to the input timecode. Discrepancies below
     * this threshold are permitted to avoid unnecessary discontinuities in the output timecode. No timecode sync when
     * this is not specified.
     * 
     * @return Threshold in frames beyond which output timecode is resynchronized to the input timecode. Discrepancies
     *         below this threshold are permitted to avoid unnecessary discontinuities in the output timecode. No
     *         timecode sync when this is not specified.
     */
    public final Integer syncThreshold() {
        return syncThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(syncThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimecodeConfig)) {
            return false;
        }
        TimecodeConfig other = (TimecodeConfig) obj;
        return Objects.equals(sourceAsString(), other.sourceAsString()) && Objects.equals(syncThreshold(), other.syncThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimecodeConfig").add("Source", sourceAsString()).add("SyncThreshold", syncThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "SyncThreshold":
            return Optional.ofNullable(clazz.cast(syncThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source", SOURCE_FIELD);
        map.put("syncThreshold", SYNC_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimecodeConfig, T> g) {
        return obj -> g.apply((TimecodeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimecodeConfig> {
        /**
         * Identifies the source for the timecode that will be associated with the events outputs. -Embedded (embedded):
         * Initialize the output timecode with timecode from the the source. If no embedded timecode is detected in the
         * source, the system falls back to using "Start at 0" (zerobased). -System Clock (systemclock): Use the UTC
         * time. -Start at 0 (zerobased): The time of the first frame of the event will be 00:00:00:00.
         * 
         * @param source
         *        Identifies the source for the timecode that will be associated with the events outputs. -Embedded
         *        (embedded): Initialize the output timecode with timecode from the the source. If no embedded timecode
         *        is detected in the source, the system falls back to using "Start at 0" (zerobased). -System Clock
         *        (systemclock): Use the UTC time. -Start at 0 (zerobased): The time of the first frame of the event
         *        will be 00:00:00:00.
         * @see TimecodeConfigSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimecodeConfigSource
         */
        Builder source(String source);

        /**
         * Identifies the source for the timecode that will be associated with the events outputs. -Embedded (embedded):
         * Initialize the output timecode with timecode from the the source. If no embedded timecode is detected in the
         * source, the system falls back to using "Start at 0" (zerobased). -System Clock (systemclock): Use the UTC
         * time. -Start at 0 (zerobased): The time of the first frame of the event will be 00:00:00:00.
         * 
         * @param source
         *        Identifies the source for the timecode that will be associated with the events outputs. -Embedded
         *        (embedded): Initialize the output timecode with timecode from the the source. If no embedded timecode
         *        is detected in the source, the system falls back to using "Start at 0" (zerobased). -System Clock
         *        (systemclock): Use the UTC time. -Start at 0 (zerobased): The time of the first frame of the event
         *        will be 00:00:00:00.
         * @see TimecodeConfigSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimecodeConfigSource
         */
        Builder source(TimecodeConfigSource source);

        /**
         * Threshold in frames beyond which output timecode is resynchronized to the input timecode. Discrepancies below
         * this threshold are permitted to avoid unnecessary discontinuities in the output timecode. No timecode sync
         * when this is not specified.
         * 
         * @param syncThreshold
         *        Threshold in frames beyond which output timecode is resynchronized to the input timecode.
         *        Discrepancies below this threshold are permitted to avoid unnecessary discontinuities in the output
         *        timecode. No timecode sync when this is not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncThreshold(Integer syncThreshold);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private Integer syncThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(TimecodeConfig model) {
            source(model.source);
            syncThreshold(model.syncThreshold);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(TimecodeConfigSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final Integer getSyncThreshold() {
            return syncThreshold;
        }

        public final void setSyncThreshold(Integer syncThreshold) {
            this.syncThreshold = syncThreshold;
        }

        @Override
        public final Builder syncThreshold(Integer syncThreshold) {
            this.syncThreshold = syncThreshold;
            return this;
        }

        @Override
        public TimecodeConfig build() {
            return new TimecodeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
