/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update the cluster.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateClusterRequest.Builder, UpdateClusterRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterId").getter(getter(UpdateClusterRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clusterId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateClusterRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ClusterNetworkSettingsUpdateRequest> NETWORK_SETTINGS_FIELD = SdkField
            .<ClusterNetworkSettingsUpdateRequest> builder(MarshallingType.SDK_POJO).memberName("NetworkSettings")
            .getter(getter(UpdateClusterRequest::networkSettings)).setter(setter(Builder::networkSettings))
            .constructor(ClusterNetworkSettingsUpdateRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, NAME_FIELD,
            NETWORK_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterId;

    private final String name;

    private final ClusterNetworkSettingsUpdateRequest networkSettings;

    private UpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.name = builder.name;
        this.networkSettings = builder.networkSettings;
    }

    /**
     * The ID of the cluster
     * 
     * @return The ID of the cluster
     */
    public final String clusterId() {
        return clusterId;
    }

    /**
     * Include this parameter only if you want to change the current name of the Cluster. Specify a name that is unique
     * in the AWS account. You can't change the name. Names are case-sensitive.
     * 
     * @return Include this parameter only if you want to change the current name of the Cluster. Specify a name that is
     *         unique in the AWS account. You can't change the name. Names are case-sensitive.
     */
    public final String name() {
        return name;
    }

    /**
     * Include this property only if you want to change the current connections between the Nodes in the Cluster and the
     * Networks the Cluster is associated with.
     * 
     * @return Include this property only if you want to change the current connections between the Nodes in the Cluster
     *         and the Networks the Cluster is associated with.
     */
    public final ClusterNetworkSettingsUpdateRequest networkSettings() {
        return networkSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(name(), other.name())
                && Objects.equals(networkSettings(), other.networkSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterRequest").add("ClusterId", clusterId()).add("Name", name())
                .add("NetworkSettings", networkSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkSettings":
            return Optional.ofNullable(clazz.cast(networkSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clusterId", CLUSTER_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("networkSettings", NETWORK_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterRequest, T> g) {
        return obj -> g.apply((UpdateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterRequest> {
        /**
         * The ID of the cluster
         * 
         * @param clusterId
         *        The ID of the cluster
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * Include this parameter only if you want to change the current name of the Cluster. Specify a name that is
         * unique in the AWS account. You can't change the name. Names are case-sensitive.
         * 
         * @param name
         *        Include this parameter only if you want to change the current name of the Cluster. Specify a name that
         *        is unique in the AWS account. You can't change the name. Names are case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Include this property only if you want to change the current connections between the Nodes in the Cluster and
         * the Networks the Cluster is associated with.
         * 
         * @param networkSettings
         *        Include this property only if you want to change the current connections between the Nodes in the
         *        Cluster and the Networks the Cluster is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettings(ClusterNetworkSettingsUpdateRequest networkSettings);

        /**
         * Include this property only if you want to change the current connections between the Nodes in the Cluster and
         * the Networks the Cluster is associated with. This is a convenience method that creates an instance of the
         * {@link ClusterNetworkSettingsUpdateRequest.Builder} avoiding the need to create one manually via
         * {@link ClusterNetworkSettingsUpdateRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterNetworkSettingsUpdateRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #networkSettings(ClusterNetworkSettingsUpdateRequest)}.
         * 
         * @param networkSettings
         *        a consumer that will call methods on {@link ClusterNetworkSettingsUpdateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSettings(ClusterNetworkSettingsUpdateRequest)
         */
        default Builder networkSettings(Consumer<ClusterNetworkSettingsUpdateRequest.Builder> networkSettings) {
            return networkSettings(ClusterNetworkSettingsUpdateRequest.builder().applyMutation(networkSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private String clusterId;

        private String name;

        private ClusterNetworkSettingsUpdateRequest networkSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterRequest model) {
            super(model);
            clusterId(model.clusterId);
            name(model.name);
            networkSettings(model.networkSettings);
        }

        public final String getClusterId() {
            return clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ClusterNetworkSettingsUpdateRequest.Builder getNetworkSettings() {
            return networkSettings != null ? networkSettings.toBuilder() : null;
        }

        public final void setNetworkSettings(ClusterNetworkSettingsUpdateRequest.BuilderImpl networkSettings) {
            this.networkSettings = networkSettings != null ? networkSettings.build() : null;
        }

        @Override
        public final Builder networkSettings(ClusterNetworkSettingsUpdateRequest networkSettings) {
            this.networkSettings = networkSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterRequest build() {
            return new UpdateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
