/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A request to update an input.
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInputRequest extends MediaLiveRequest implements
        ToCopyableBuilder<UpdateInputRequest.Builder, UpdateInputRequest> {
    private static final SdkField<List<InputDestinationRequest>> DESTINATIONS_FIELD = SdkField
            .<List<InputDestinationRequest>> builder(MarshallingType.LIST)
            .memberName("Destinations")
            .getter(getter(UpdateInputRequest::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputDestinationRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputDestinationRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InputDeviceRequest>> INPUT_DEVICES_FIELD = SdkField
            .<List<InputDeviceRequest>> builder(MarshallingType.LIST)
            .memberName("InputDevices")
            .getter(getter(UpdateInputRequest::inputDevices))
            .setter(setter(Builder::inputDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputDeviceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputDeviceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INPUT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputId").getter(getter(UpdateInputRequest::inputId)).setter(setter(Builder::inputId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("inputId").build()).build();

    private static final SdkField<List<String>> INPUT_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InputSecurityGroups")
            .getter(getter(UpdateInputRequest::inputSecurityGroups))
            .setter(setter(Builder::inputSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<MediaConnectFlowRequest>> MEDIA_CONNECT_FLOWS_FIELD = SdkField
            .<List<MediaConnectFlowRequest>> builder(MarshallingType.LIST)
            .memberName("MediaConnectFlows")
            .getter(getter(UpdateInputRequest::mediaConnectFlows))
            .setter(setter(Builder::mediaConnectFlows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaConnectFlows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MediaConnectFlowRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(MediaConnectFlowRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateInputRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(UpdateInputRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<List<InputSourceRequest>> SOURCES_FIELD = SdkField
            .<List<InputSourceRequest>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(UpdateInputRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputSourceRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputSourceRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SrtSettingsRequest> SRT_SETTINGS_FIELD = SdkField
            .<SrtSettingsRequest> builder(MarshallingType.SDK_POJO).memberName("SrtSettings")
            .getter(getter(UpdateInputRequest::srtSettings)).setter(setter(Builder::srtSettings))
            .constructor(SrtSettingsRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("srtSettings").build()).build();

    private static final SdkField<MulticastSettingsUpdateRequest> MULTICAST_SETTINGS_FIELD = SdkField
            .<MulticastSettingsUpdateRequest> builder(MarshallingType.SDK_POJO).memberName("MulticastSettings")
            .getter(getter(UpdateInputRequest::multicastSettings)).setter(setter(Builder::multicastSettings))
            .constructor(MulticastSettingsUpdateRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multicastSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATIONS_FIELD,
            INPUT_DEVICES_FIELD, INPUT_ID_FIELD, INPUT_SECURITY_GROUPS_FIELD, MEDIA_CONNECT_FLOWS_FIELD, NAME_FIELD,
            ROLE_ARN_FIELD, SOURCES_FIELD, SRT_SETTINGS_FIELD, MULTICAST_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InputDestinationRequest> destinations;

    private final List<InputDeviceRequest> inputDevices;

    private final String inputId;

    private final List<String> inputSecurityGroups;

    private final List<MediaConnectFlowRequest> mediaConnectFlows;

    private final String name;

    private final String roleArn;

    private final List<InputSourceRequest> sources;

    private final SrtSettingsRequest srtSettings;

    private final MulticastSettingsUpdateRequest multicastSettings;

    private UpdateInputRequest(BuilderImpl builder) {
        super(builder);
        this.destinations = builder.destinations;
        this.inputDevices = builder.inputDevices;
        this.inputId = builder.inputId;
        this.inputSecurityGroups = builder.inputSecurityGroups;
        this.mediaConnectFlows = builder.mediaConnectFlows;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.sources = builder.sources;
        this.srtSettings = builder.srtSettings;
        this.multicastSettings = builder.multicastSettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * Destination settings for PUSH type inputs.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return Destination settings for PUSH type inputs.
     */
    public final List<InputDestinationRequest> destinations() {
        return destinations;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputDevices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputDevices() {
        return inputDevices != null && !(inputDevices instanceof SdkAutoConstructList);
    }

    /**
     * Settings for the devices.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputDevices} method.
     * </p>
     * 
     * @return Settings for the devices.
     */
    public final List<InputDeviceRequest> inputDevices() {
        return inputDevices;
    }

    /**
     * Unique ID of the input.
     * 
     * @return Unique ID of the input.
     */
    public final String inputId() {
        return inputId;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputSecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputSecurityGroups() {
        return inputSecurityGroups != null && !(inputSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * A list of security groups referenced by IDs to attach to the input.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputSecurityGroups} method.
     * </p>
     * 
     * @return A list of security groups referenced by IDs to attach to the input.
     */
    public final List<String> inputSecurityGroups() {
        return inputSecurityGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the MediaConnectFlows property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMediaConnectFlows() {
        return mediaConnectFlows != null && !(mediaConnectFlows instanceof SdkAutoConstructList);
    }

    /**
     * A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few as
     * one Flow and presently, as many as two. The only requirement is when you have more than one is that each Flow is
     * in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMediaConnectFlows} method.
     * </p>
     * 
     * @return A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as
     *         few as one Flow and presently, as many as two. The only requirement is when you have more than one is
     *         that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ
     *         issues.
     */
    public final List<MediaConnectFlowRequest> mediaConnectFlows() {
        return mediaConnectFlows;
    }

    /**
     * Name of the input.
     * 
     * @return Name of the input.
     */
    public final String name() {
        return name;
    }

    /**
     * The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
     * 
     * @return The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy. Only
     * specify sources for PULL type Inputs. Leave Destinations empty.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for
     *         redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
     */
    public final List<InputSourceRequest> sources() {
        return sources;
    }

    /**
     * The settings associated with an SRT input.
     * 
     * @return The settings associated with an SRT input.
     */
    public final SrtSettingsRequest srtSettings() {
        return srtSettings;
    }

    /**
     * Multicast Input settings.
     * 
     * @return Multicast Input settings.
     */
    public final MulticastSettingsUpdateRequest multicastSettings() {
        return multicastSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputDevices() ? inputDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inputId());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputSecurityGroups() ? inputSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMediaConnectFlows() ? mediaConnectFlows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(srtSettings());
        hashCode = 31 * hashCode + Objects.hashCode(multicastSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInputRequest)) {
            return false;
        }
        UpdateInputRequest other = (UpdateInputRequest) obj;
        return hasDestinations() == other.hasDestinations() && Objects.equals(destinations(), other.destinations())
                && hasInputDevices() == other.hasInputDevices() && Objects.equals(inputDevices(), other.inputDevices())
                && Objects.equals(inputId(), other.inputId()) && hasInputSecurityGroups() == other.hasInputSecurityGroups()
                && Objects.equals(inputSecurityGroups(), other.inputSecurityGroups())
                && hasMediaConnectFlows() == other.hasMediaConnectFlows()
                && Objects.equals(mediaConnectFlows(), other.mediaConnectFlows()) && Objects.equals(name(), other.name())
                && Objects.equals(roleArn(), other.roleArn()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && Objects.equals(srtSettings(), other.srtSettings())
                && Objects.equals(multicastSettings(), other.multicastSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInputRequest").add("Destinations", hasDestinations() ? destinations() : null)
                .add("InputDevices", hasInputDevices() ? inputDevices() : null).add("InputId", inputId())
                .add("InputSecurityGroups", hasInputSecurityGroups() ? inputSecurityGroups() : null)
                .add("MediaConnectFlows", hasMediaConnectFlows() ? mediaConnectFlows() : null).add("Name", name())
                .add("RoleArn", roleArn()).add("Sources", hasSources() ? sources() : null).add("SrtSettings", srtSettings())
                .add("MulticastSettings", multicastSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "InputDevices":
            return Optional.ofNullable(clazz.cast(inputDevices()));
        case "InputId":
            return Optional.ofNullable(clazz.cast(inputId()));
        case "InputSecurityGroups":
            return Optional.ofNullable(clazz.cast(inputSecurityGroups()));
        case "MediaConnectFlows":
            return Optional.ofNullable(clazz.cast(mediaConnectFlows()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "SrtSettings":
            return Optional.ofNullable(clazz.cast(srtSettings()));
        case "MulticastSettings":
            return Optional.ofNullable(clazz.cast(multicastSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("inputDevices", INPUT_DEVICES_FIELD);
        map.put("inputId", INPUT_ID_FIELD);
        map.put("inputSecurityGroups", INPUT_SECURITY_GROUPS_FIELD);
        map.put("mediaConnectFlows", MEDIA_CONNECT_FLOWS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("srtSettings", SRT_SETTINGS_FIELD);
        map.put("multicastSettings", MULTICAST_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInputRequest, T> g) {
        return obj -> g.apply((UpdateInputRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaLiveRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateInputRequest> {
        /**
         * Destination settings for PUSH type inputs.
         * 
         * @param destinations
         *        Destination settings for PUSH type inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<InputDestinationRequest> destinations);

        /**
         * Destination settings for PUSH type inputs.
         * 
         * @param destinations
         *        Destination settings for PUSH type inputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(InputDestinationRequest... destinations);

        /**
         * Destination settings for PUSH type inputs. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.InputDestinationRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.InputDestinationRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.InputDestinationRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #destinations(List<InputDestinationRequest>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.InputDestinationRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<InputDestinationRequest>)
         */
        Builder destinations(Consumer<InputDestinationRequest.Builder>... destinations);

        /**
         * Settings for the devices.
         * 
         * @param inputDevices
         *        Settings for the devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDevices(Collection<InputDeviceRequest> inputDevices);

        /**
         * Settings for the devices.
         * 
         * @param inputDevices
         *        Settings for the devices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDevices(InputDeviceRequest... inputDevices);

        /**
         * Settings for the devices. This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.InputDeviceRequest.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.medialive.model.InputDeviceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.InputDeviceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #inputDevices(List<InputDeviceRequest>)}.
         * 
         * @param inputDevices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.InputDeviceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDevices(java.util.Collection<InputDeviceRequest>)
         */
        Builder inputDevices(Consumer<InputDeviceRequest.Builder>... inputDevices);

        /**
         * Unique ID of the input.
         * 
         * @param inputId
         *        Unique ID of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputId(String inputId);

        /**
         * A list of security groups referenced by IDs to attach to the input.
         * 
         * @param inputSecurityGroups
         *        A list of security groups referenced by IDs to attach to the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSecurityGroups(Collection<String> inputSecurityGroups);

        /**
         * A list of security groups referenced by IDs to attach to the input.
         * 
         * @param inputSecurityGroups
         *        A list of security groups referenced by IDs to attach to the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputSecurityGroups(String... inputSecurityGroups);

        /**
         * A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few
         * as one Flow and presently, as many as two. The only requirement is when you have more than one is that each
         * Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
         * 
         * @param mediaConnectFlows
         *        A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify
         *        as few as one Flow and presently, as many as two. The only requirement is when you have more than one
         *        is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ
         *        issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConnectFlows(Collection<MediaConnectFlowRequest> mediaConnectFlows);

        /**
         * A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few
         * as one Flow and presently, as many as two. The only requirement is when you have more than one is that each
         * Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues.
         * 
         * @param mediaConnectFlows
         *        A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify
         *        as few as one Flow and presently, as many as two. The only requirement is when you have more than one
         *        is that each Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ
         *        issues.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaConnectFlows(MediaConnectFlowRequest... mediaConnectFlows);

        /**
         * A list of the MediaConnect Flow ARNs that you want to use as the source of the input. You can specify as few
         * as one Flow and presently, as many as two. The only requirement is when you have more than one is that each
         * Flow is in a separate Availability Zone as this ensures your EML input is redundant to AZ issues. This is a
         * convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.medialive.model.MediaConnectFlowRequest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.MediaConnectFlowRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.MediaConnectFlowRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #mediaConnectFlows(List<MediaConnectFlowRequest>)}.
         * 
         * @param mediaConnectFlows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.MediaConnectFlowRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaConnectFlows(java.util.Collection<MediaConnectFlowRequest>)
         */
        Builder mediaConnectFlows(Consumer<MediaConnectFlowRequest.Builder>... mediaConnectFlows);

        /**
         * Name of the input.
         * 
         * @param name
         *        Name of the input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role this input assumes during and after creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy.
         * Only specify sources for PULL type Inputs. Leave Destinations empty.
         * 
         * @param sources
         *        The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for
         *        redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<InputSourceRequest> sources);

        /**
         * The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy.
         * Only specify sources for PULL type Inputs. Leave Destinations empty.
         * 
         * @param sources
         *        The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for
         *        redundancy. Only specify sources for PULL type Inputs. Leave Destinations empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(InputSourceRequest... sources);

        /**
         * The source URLs for a PULL-type input. Every PULL type input needs exactly two source URLs for redundancy.
         * Only specify sources for PULL type Inputs. Leave Destinations empty. This is a convenience method that
         * creates an instance of the {@link software.amazon.awssdk.services.medialive.model.InputSourceRequest.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.medialive.model.InputSourceRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.medialive.model.InputSourceRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<InputSourceRequest>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.medialive.model.InputSourceRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<InputSourceRequest>)
         */
        Builder sources(Consumer<InputSourceRequest.Builder>... sources);

        /**
         * The settings associated with an SRT input.
         * 
         * @param srtSettings
         *        The settings associated with an SRT input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder srtSettings(SrtSettingsRequest srtSettings);

        /**
         * The settings associated with an SRT input. This is a convenience method that creates an instance of the
         * {@link SrtSettingsRequest.Builder} avoiding the need to create one manually via
         * {@link SrtSettingsRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SrtSettingsRequest.Builder#build()} is called immediately and its
         * result is passed to {@link #srtSettings(SrtSettingsRequest)}.
         * 
         * @param srtSettings
         *        a consumer that will call methods on {@link SrtSettingsRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #srtSettings(SrtSettingsRequest)
         */
        default Builder srtSettings(Consumer<SrtSettingsRequest.Builder> srtSettings) {
            return srtSettings(SrtSettingsRequest.builder().applyMutation(srtSettings).build());
        }

        /**
         * Multicast Input settings.
         * 
         * @param multicastSettings
         *        Multicast Input settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastSettings(MulticastSettingsUpdateRequest multicastSettings);

        /**
         * Multicast Input settings. This is a convenience method that creates an instance of the
         * {@link MulticastSettingsUpdateRequest.Builder} avoiding the need to create one manually via
         * {@link MulticastSettingsUpdateRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MulticastSettingsUpdateRequest.Builder#build()} is called
         * immediately and its result is passed to {@link #multicastSettings(MulticastSettingsUpdateRequest)}.
         * 
         * @param multicastSettings
         *        a consumer that will call methods on {@link MulticastSettingsUpdateRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multicastSettings(MulticastSettingsUpdateRequest)
         */
        default Builder multicastSettings(Consumer<MulticastSettingsUpdateRequest.Builder> multicastSettings) {
            return multicastSettings(MulticastSettingsUpdateRequest.builder().applyMutation(multicastSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaLiveRequest.BuilderImpl implements Builder {
        private List<InputDestinationRequest> destinations = DefaultSdkAutoConstructList.getInstance();

        private List<InputDeviceRequest> inputDevices = DefaultSdkAutoConstructList.getInstance();

        private String inputId;

        private List<String> inputSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<MediaConnectFlowRequest> mediaConnectFlows = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String roleArn;

        private List<InputSourceRequest> sources = DefaultSdkAutoConstructList.getInstance();

        private SrtSettingsRequest srtSettings;

        private MulticastSettingsUpdateRequest multicastSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInputRequest model) {
            super(model);
            destinations(model.destinations);
            inputDevices(model.inputDevices);
            inputId(model.inputId);
            inputSecurityGroups(model.inputSecurityGroups);
            mediaConnectFlows(model.mediaConnectFlows);
            name(model.name);
            roleArn(model.roleArn);
            sources(model.sources);
            srtSettings(model.srtSettings);
            multicastSettings(model.multicastSettings);
        }

        public final List<InputDestinationRequest.Builder> getDestinations() {
            List<InputDestinationRequest.Builder> result = ___listOfInputDestinationRequestCopier
                    .copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<InputDestinationRequest.BuilderImpl> destinations) {
            this.destinations = ___listOfInputDestinationRequestCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<InputDestinationRequest> destinations) {
            this.destinations = ___listOfInputDestinationRequestCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(InputDestinationRequest... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<InputDestinationRequest.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> InputDestinationRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<InputDeviceRequest.Builder> getInputDevices() {
            List<InputDeviceRequest.Builder> result = ___listOfInputDeviceRequestCopier.copyToBuilder(this.inputDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDevices(Collection<InputDeviceRequest.BuilderImpl> inputDevices) {
            this.inputDevices = ___listOfInputDeviceRequestCopier.copyFromBuilder(inputDevices);
        }

        @Override
        public final Builder inputDevices(Collection<InputDeviceRequest> inputDevices) {
            this.inputDevices = ___listOfInputDeviceRequestCopier.copy(inputDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(InputDeviceRequest... inputDevices) {
            inputDevices(Arrays.asList(inputDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDevices(Consumer<InputDeviceRequest.Builder>... inputDevices) {
            inputDevices(Stream.of(inputDevices).map(c -> InputDeviceRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getInputId() {
            return inputId;
        }

        public final void setInputId(String inputId) {
            this.inputId = inputId;
        }

        @Override
        public final Builder inputId(String inputId) {
            this.inputId = inputId;
            return this;
        }

        public final Collection<String> getInputSecurityGroups() {
            if (inputSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return inputSecurityGroups;
        }

        public final void setInputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOf__stringCopier.copy(inputSecurityGroups);
        }

        @Override
        public final Builder inputSecurityGroups(Collection<String> inputSecurityGroups) {
            this.inputSecurityGroups = ___listOf__stringCopier.copy(inputSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSecurityGroups(String... inputSecurityGroups) {
            inputSecurityGroups(Arrays.asList(inputSecurityGroups));
            return this;
        }

        public final List<MediaConnectFlowRequest.Builder> getMediaConnectFlows() {
            List<MediaConnectFlowRequest.Builder> result = ___listOfMediaConnectFlowRequestCopier
                    .copyToBuilder(this.mediaConnectFlows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaConnectFlows(Collection<MediaConnectFlowRequest.BuilderImpl> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowRequestCopier.copyFromBuilder(mediaConnectFlows);
        }

        @Override
        public final Builder mediaConnectFlows(Collection<MediaConnectFlowRequest> mediaConnectFlows) {
            this.mediaConnectFlows = ___listOfMediaConnectFlowRequestCopier.copy(mediaConnectFlows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(MediaConnectFlowRequest... mediaConnectFlows) {
            mediaConnectFlows(Arrays.asList(mediaConnectFlows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaConnectFlows(Consumer<MediaConnectFlowRequest.Builder>... mediaConnectFlows) {
            mediaConnectFlows(Stream.of(mediaConnectFlows).map(c -> MediaConnectFlowRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<InputSourceRequest.Builder> getSources() {
            List<InputSourceRequest.Builder> result = ___listOfInputSourceRequestCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<InputSourceRequest.BuilderImpl> sources) {
            this.sources = ___listOfInputSourceRequestCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<InputSourceRequest> sources) {
            this.sources = ___listOfInputSourceRequestCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(InputSourceRequest... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<InputSourceRequest.Builder>... sources) {
            sources(Stream.of(sources).map(c -> InputSourceRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final SrtSettingsRequest.Builder getSrtSettings() {
            return srtSettings != null ? srtSettings.toBuilder() : null;
        }

        public final void setSrtSettings(SrtSettingsRequest.BuilderImpl srtSettings) {
            this.srtSettings = srtSettings != null ? srtSettings.build() : null;
        }

        @Override
        public final Builder srtSettings(SrtSettingsRequest srtSettings) {
            this.srtSettings = srtSettings;
            return this;
        }

        public final MulticastSettingsUpdateRequest.Builder getMulticastSettings() {
            return multicastSettings != null ? multicastSettings.toBuilder() : null;
        }

        public final void setMulticastSettings(MulticastSettingsUpdateRequest.BuilderImpl multicastSettings) {
            this.multicastSettings = multicastSettings != null ? multicastSettings.build() : null;
        }

        @Override
        public final Builder multicastSettings(MulticastSettingsUpdateRequest multicastSettings) {
            this.multicastSettings = multicastSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInputRequest build() {
            return new UpdateInputRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
