/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Video Selector Program Id
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoSelectorProgramId implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoSelectorProgramId.Builder, VideoSelectorProgramId> {
    private static final SdkField<Integer> PROGRAM_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramId").getter(getter(VideoSelectorProgramId::programId)).setter(setter(Builder::programId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRAM_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer programId;

    private VideoSelectorProgramId(BuilderImpl builder) {
        this.programId = builder.programId;
    }

    /**
     * Selects a specific program from within a multi-program transport stream. If the program doesn't exist, the first
     * program within the transport stream will be selected by default.
     * 
     * @return Selects a specific program from within a multi-program transport stream. If the program doesn't exist,
     *         the first program within the transport stream will be selected by default.
     */
    public final Integer programId() {
        return programId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(programId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoSelectorProgramId)) {
            return false;
        }
        VideoSelectorProgramId other = (VideoSelectorProgramId) obj;
        return Objects.equals(programId(), other.programId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoSelectorProgramId").add("ProgramId", programId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgramId":
            return Optional.ofNullable(clazz.cast(programId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("programId", PROGRAM_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoSelectorProgramId, T> g) {
        return obj -> g.apply((VideoSelectorProgramId) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoSelectorProgramId> {
        /**
         * Selects a specific program from within a multi-program transport stream. If the program doesn't exist, the
         * first program within the transport stream will be selected by default.
         * 
         * @param programId
         *        Selects a specific program from within a multi-program transport stream. If the program doesn't exist,
         *        the first program within the transport stream will be selected by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programId(Integer programId);
    }

    static final class BuilderImpl implements Builder {
        private Integer programId;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoSelectorProgramId model) {
            programId(model.programId);
        }

        public final Integer getProgramId() {
            return programId;
        }

        public final void setProgramId(Integer programId) {
            this.programId = programId;
        }

        @Override
        public final Builder programId(Integer programId) {
            this.programId = programId;
            return this;
        }

        @Override
        public VideoSelectorProgramId build() {
            return new VideoSelectorProgramId(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
