/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.medialive.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfFailoverConditionCopier {
    static List<FailoverCondition> copy(Collection<? extends FailoverCondition> __listOfFailoverConditionParam) {
        List<FailoverCondition> list;
        if (__listOfFailoverConditionParam == null || __listOfFailoverConditionParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FailoverCondition> modifiableList = new ArrayList<>(__listOfFailoverConditionParam.size());
            __listOfFailoverConditionParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FailoverCondition> copyFromBuilder(Collection<? extends FailoverCondition.Builder> __listOfFailoverConditionParam) {
        List<FailoverCondition> list;
        if (__listOfFailoverConditionParam == null || __listOfFailoverConditionParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FailoverCondition> modifiableList = new ArrayList<>(__listOfFailoverConditionParam.size());
            __listOfFailoverConditionParam.forEach(entry -> {
                FailoverCondition member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<FailoverCondition.Builder> copyToBuilder(Collection<? extends FailoverCondition> __listOfFailoverConditionParam) {
        List<FailoverCondition.Builder> list;
        if (__listOfFailoverConditionParam == null || __listOfFailoverConditionParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<FailoverCondition.Builder> modifiableList = new ArrayList<>(__listOfFailoverConditionParam.size());
            __listOfFailoverConditionParam.forEach(entry -> {
                FailoverCondition.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
