/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateSummary;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse;

public class ListEventBridgeRuleTemplatesIterable
implements SdkIterable<ListEventBridgeRuleTemplatesResponse> {
    private final MediaLiveClient client;
    private final ListEventBridgeRuleTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventBridgeRuleTemplatesIterable(MediaLiveClient client, ListEventBridgeRuleTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventBridgeRuleTemplatesResponseFetcher();
    }

    public Iterator<ListEventBridgeRuleTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventBridgeRuleTemplateSummary> eventBridgeRuleTemplates() {
        Function<ListEventBridgeRuleTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventBridgeRuleTemplates() != null) {
                return response.eventBridgeRuleTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventBridgeRuleTemplatesResponseFetcher
    implements SyncPageFetcher<ListEventBridgeRuleTemplatesResponse> {
        private ListEventBridgeRuleTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListEventBridgeRuleTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventBridgeRuleTemplatesResponse nextPage(ListEventBridgeRuleTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListEventBridgeRuleTemplatesIterable.this.client.listEventBridgeRuleTemplates(ListEventBridgeRuleTemplatesIterable.this.firstRequest);
            }
            return ListEventBridgeRuleTemplatesIterable.this.client.listEventBridgeRuleTemplates((ListEventBridgeRuleTemplatesRequest)((Object)ListEventBridgeRuleTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

