/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSignalMapsRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, ListSignalMapsRequest> {
    private static final SdkField<String> CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchAlarmTemplateGroupIdentifier").getter(ListSignalMapsRequest.getter(ListSignalMapsRequest::cloudWatchAlarmTemplateGroupIdentifier)).setter(ListSignalMapsRequest.setter(Builder::cloudWatchAlarmTemplateGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("cloudWatchAlarmTemplateGroupIdentifier").build()}).build();
    private static final SdkField<String> EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventBridgeRuleTemplateGroupIdentifier").getter(ListSignalMapsRequest.getter(ListSignalMapsRequest::eventBridgeRuleTemplateGroupIdentifier)).setter(ListSignalMapsRequest.setter(Builder::eventBridgeRuleTemplateGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("eventBridgeRuleTemplateGroupIdentifier").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListSignalMapsRequest.getter(ListSignalMapsRequest::maxResults)).setter(ListSignalMapsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSignalMapsRequest.getter(ListSignalMapsRequest::nextToken)).setter(ListSignalMapsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDENTIFIER_FIELD, EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSignalMapsRequest.memberNameToFieldInitializer();
    private final String cloudWatchAlarmTemplateGroupIdentifier;
    private final String eventBridgeRuleTemplateGroupIdentifier;
    private final Integer maxResults;
    private final String nextToken;

    private ListSignalMapsRequest(BuilderImpl builder) {
        super(builder);
        this.cloudWatchAlarmTemplateGroupIdentifier = builder.cloudWatchAlarmTemplateGroupIdentifier;
        this.eventBridgeRuleTemplateGroupIdentifier = builder.eventBridgeRuleTemplateGroupIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String cloudWatchAlarmTemplateGroupIdentifier() {
        return this.cloudWatchAlarmTemplateGroupIdentifier;
    }

    public final String eventBridgeRuleTemplateGroupIdentifier() {
        return this.eventBridgeRuleTemplateGroupIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchAlarmTemplateGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridgeRuleTemplateGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSignalMapsRequest)) {
            return false;
        }
        ListSignalMapsRequest other = (ListSignalMapsRequest)((Object)obj);
        return Objects.equals(this.cloudWatchAlarmTemplateGroupIdentifier(), other.cloudWatchAlarmTemplateGroupIdentifier()) && Objects.equals(this.eventBridgeRuleTemplateGroupIdentifier(), other.eventBridgeRuleTemplateGroupIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSignalMapsRequest").add("CloudWatchAlarmTemplateGroupIdentifier", (Object)this.cloudWatchAlarmTemplateGroupIdentifier()).add("EventBridgeRuleTemplateGroupIdentifier", (Object)this.eventBridgeRuleTemplateGroupIdentifier()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchAlarmTemplateGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchAlarmTemplateGroupIdentifier()));
            }
            case "EventBridgeRuleTemplateGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeRuleTemplateGroupIdentifier()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudWatchAlarmTemplateGroupIdentifier", CLOUD_WATCH_ALARM_TEMPLATE_GROUP_IDENTIFIER_FIELD);
        map.put("eventBridgeRuleTemplateGroupIdentifier", EVENT_BRIDGE_RULE_TEMPLATE_GROUP_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSignalMapsRequest, T> g) {
        return obj -> g.apply((ListSignalMapsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String cloudWatchAlarmTemplateGroupIdentifier;
        private String eventBridgeRuleTemplateGroupIdentifier;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSignalMapsRequest model) {
            super(model);
            this.cloudWatchAlarmTemplateGroupIdentifier(model.cloudWatchAlarmTemplateGroupIdentifier);
            this.eventBridgeRuleTemplateGroupIdentifier(model.eventBridgeRuleTemplateGroupIdentifier);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getCloudWatchAlarmTemplateGroupIdentifier() {
            return this.cloudWatchAlarmTemplateGroupIdentifier;
        }

        public final void setCloudWatchAlarmTemplateGroupIdentifier(String cloudWatchAlarmTemplateGroupIdentifier) {
            this.cloudWatchAlarmTemplateGroupIdentifier = cloudWatchAlarmTemplateGroupIdentifier;
        }

        @Override
        public final Builder cloudWatchAlarmTemplateGroupIdentifier(String cloudWatchAlarmTemplateGroupIdentifier) {
            this.cloudWatchAlarmTemplateGroupIdentifier = cloudWatchAlarmTemplateGroupIdentifier;
            return this;
        }

        public final String getEventBridgeRuleTemplateGroupIdentifier() {
            return this.eventBridgeRuleTemplateGroupIdentifier;
        }

        public final void setEventBridgeRuleTemplateGroupIdentifier(String eventBridgeRuleTemplateGroupIdentifier) {
            this.eventBridgeRuleTemplateGroupIdentifier = eventBridgeRuleTemplateGroupIdentifier;
        }

        @Override
        public final Builder eventBridgeRuleTemplateGroupIdentifier(String eventBridgeRuleTemplateGroupIdentifier) {
            this.eventBridgeRuleTemplateGroupIdentifier = eventBridgeRuleTemplateGroupIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSignalMapsRequest build() {
            return new ListSignalMapsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSignalMapsRequest> {
        public Builder cloudWatchAlarmTemplateGroupIdentifier(String var1);

        public Builder eventBridgeRuleTemplateGroupIdentifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

