/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InputDeviceCodec;
import software.amazon.awssdk.services.medialive.model.InputDeviceConfigurableAudioChannelPairConfig;
import software.amazon.awssdk.services.medialive.model.InputDeviceConfiguredInput;
import software.amazon.awssdk.services.medialive.model.InputDeviceMediaConnectConfigurableSettings;
import software.amazon.awssdk.services.medialive.model.___listOfInputDeviceConfigurableAudioChannelPairConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDeviceConfigurableSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDeviceConfigurableSettings> {
    private static final SdkField<String> CONFIGURED_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfiguredInput").getter(InputDeviceConfigurableSettings.getter(InputDeviceConfigurableSettings::configuredInputAsString)).setter(InputDeviceConfigurableSettings.setter(Builder::configuredInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredInput").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(InputDeviceConfigurableSettings.getter(InputDeviceConfigurableSettings::maxBitrate)).setter(InputDeviceConfigurableSettings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> LATENCY_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LatencyMs").getter(InputDeviceConfigurableSettings.getter(InputDeviceConfigurableSettings::latencyMs)).setter(InputDeviceConfigurableSettings.setter(Builder::latencyMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latencyMs").build()}).build();
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Codec").getter(InputDeviceConfigurableSettings.getter(InputDeviceConfigurableSettings::codecAsString)).setter(InputDeviceConfigurableSettings.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()}).build();
    private static final SdkField<InputDeviceMediaConnectConfigurableSettings> MEDIACONNECT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaconnectSettings").getter(InputDeviceConfigurableSettings.getter(InputDeviceConfigurableSettings::mediaconnectSettings)).setter(InputDeviceConfigurableSettings.setter(Builder::mediaconnectSettings)).constructor(InputDeviceMediaConnectConfigurableSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaconnectSettings").build()}).build();
    private static final SdkField<List<InputDeviceConfigurableAudioChannelPairConfig>> AUDIO_CHANNEL_PAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AudioChannelPairs").getter(InputDeviceConfigurableSettings.getter(InputDeviceConfigurableSettings::audioChannelPairs)).setter(InputDeviceConfigurableSettings.setter(Builder::audioChannelPairs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioChannelPairs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDeviceConfigurableAudioChannelPairConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputResolution").getter(InputDeviceConfigurableSettings.getter(InputDeviceConfigurableSettings::inputResolution)).setter(InputDeviceConfigurableSettings.setter(Builder::inputResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputResolution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_INPUT_FIELD, MAX_BITRATE_FIELD, LATENCY_MS_FIELD, CODEC_FIELD, MEDIACONNECT_SETTINGS_FIELD, AUDIO_CHANNEL_PAIRS_FIELD, INPUT_RESOLUTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputDeviceConfigurableSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String configuredInput;
    private final Integer maxBitrate;
    private final Integer latencyMs;
    private final String codec;
    private final InputDeviceMediaConnectConfigurableSettings mediaconnectSettings;
    private final List<InputDeviceConfigurableAudioChannelPairConfig> audioChannelPairs;
    private final String inputResolution;

    private InputDeviceConfigurableSettings(BuilderImpl builder) {
        this.configuredInput = builder.configuredInput;
        this.maxBitrate = builder.maxBitrate;
        this.latencyMs = builder.latencyMs;
        this.codec = builder.codec;
        this.mediaconnectSettings = builder.mediaconnectSettings;
        this.audioChannelPairs = builder.audioChannelPairs;
        this.inputResolution = builder.inputResolution;
    }

    public final InputDeviceConfiguredInput configuredInput() {
        return InputDeviceConfiguredInput.fromValue(this.configuredInput);
    }

    public final String configuredInputAsString() {
        return this.configuredInput;
    }

    public final Integer maxBitrate() {
        return this.maxBitrate;
    }

    public final Integer latencyMs() {
        return this.latencyMs;
    }

    public final InputDeviceCodec codec() {
        return InputDeviceCodec.fromValue(this.codec);
    }

    public final String codecAsString() {
        return this.codec;
    }

    public final InputDeviceMediaConnectConfigurableSettings mediaconnectSettings() {
        return this.mediaconnectSettings;
    }

    public final boolean hasAudioChannelPairs() {
        return this.audioChannelPairs != null && !(this.audioChannelPairs instanceof SdkAutoConstructList);
    }

    public final List<InputDeviceConfigurableAudioChannelPairConfig> audioChannelPairs() {
        return this.audioChannelPairs;
    }

    public final String inputResolution() {
        return this.inputResolution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredInputAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.latencyMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaconnectSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudioChannelPairs() ? this.audioChannelPairs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputResolution());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDeviceConfigurableSettings)) {
            return false;
        }
        InputDeviceConfigurableSettings other = (InputDeviceConfigurableSettings)obj;
        return Objects.equals(this.configuredInputAsString(), other.configuredInputAsString()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.latencyMs(), other.latencyMs()) && Objects.equals(this.codecAsString(), other.codecAsString()) && Objects.equals(this.mediaconnectSettings(), other.mediaconnectSettings()) && this.hasAudioChannelPairs() == other.hasAudioChannelPairs() && Objects.equals(this.audioChannelPairs(), other.audioChannelPairs()) && Objects.equals(this.inputResolution(), other.inputResolution());
    }

    public final String toString() {
        return ToString.builder((String)"InputDeviceConfigurableSettings").add("ConfiguredInput", (Object)this.configuredInputAsString()).add("MaxBitrate", (Object)this.maxBitrate()).add("LatencyMs", (Object)this.latencyMs()).add("Codec", (Object)this.codecAsString()).add("MediaconnectSettings", (Object)this.mediaconnectSettings()).add("AudioChannelPairs", this.hasAudioChannelPairs() ? this.audioChannelPairs() : null).add("InputResolution", (Object)this.inputResolution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfiguredInput": {
                return Optional.ofNullable(clazz.cast(this.configuredInputAsString()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "LatencyMs": {
                return Optional.ofNullable(clazz.cast(this.latencyMs()));
            }
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codecAsString()));
            }
            case "MediaconnectSettings": {
                return Optional.ofNullable(clazz.cast(this.mediaconnectSettings()));
            }
            case "AudioChannelPairs": {
                return Optional.ofNullable(clazz.cast(this.audioChannelPairs()));
            }
            case "InputResolution": {
                return Optional.ofNullable(clazz.cast(this.inputResolution()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configuredInput", CONFIGURED_INPUT_FIELD);
        map.put("maxBitrate", MAX_BITRATE_FIELD);
        map.put("latencyMs", LATENCY_MS_FIELD);
        map.put("codec", CODEC_FIELD);
        map.put("mediaconnectSettings", MEDIACONNECT_SETTINGS_FIELD);
        map.put("audioChannelPairs", AUDIO_CHANNEL_PAIRS_FIELD);
        map.put("inputResolution", INPUT_RESOLUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputDeviceConfigurableSettings, T> g) {
        return obj -> g.apply((InputDeviceConfigurableSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configuredInput;
        private Integer maxBitrate;
        private Integer latencyMs;
        private String codec;
        private InputDeviceMediaConnectConfigurableSettings mediaconnectSettings;
        private List<InputDeviceConfigurableAudioChannelPairConfig> audioChannelPairs = DefaultSdkAutoConstructList.getInstance();
        private String inputResolution;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDeviceConfigurableSettings model) {
            this.configuredInput(model.configuredInput);
            this.maxBitrate(model.maxBitrate);
            this.latencyMs(model.latencyMs);
            this.codec(model.codec);
            this.mediaconnectSettings(model.mediaconnectSettings);
            this.audioChannelPairs(model.audioChannelPairs);
            this.inputResolution(model.inputResolution);
        }

        public final String getConfiguredInput() {
            return this.configuredInput;
        }

        public final void setConfiguredInput(String configuredInput) {
            this.configuredInput = configuredInput;
        }

        @Override
        public final Builder configuredInput(String configuredInput) {
            this.configuredInput = configuredInput;
            return this;
        }

        @Override
        public final Builder configuredInput(InputDeviceConfiguredInput configuredInput) {
            this.configuredInput(configuredInput == null ? null : configuredInput.toString());
            return this;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getLatencyMs() {
            return this.latencyMs;
        }

        public final void setLatencyMs(Integer latencyMs) {
            this.latencyMs = latencyMs;
        }

        @Override
        public final Builder latencyMs(Integer latencyMs) {
            this.latencyMs = latencyMs;
            return this;
        }

        public final String getCodec() {
            return this.codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(InputDeviceCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final InputDeviceMediaConnectConfigurableSettings.Builder getMediaconnectSettings() {
            return this.mediaconnectSettings != null ? this.mediaconnectSettings.toBuilder() : null;
        }

        public final void setMediaconnectSettings(InputDeviceMediaConnectConfigurableSettings.BuilderImpl mediaconnectSettings) {
            this.mediaconnectSettings = mediaconnectSettings != null ? mediaconnectSettings.build() : null;
        }

        @Override
        public final Builder mediaconnectSettings(InputDeviceMediaConnectConfigurableSettings mediaconnectSettings) {
            this.mediaconnectSettings = mediaconnectSettings;
            return this;
        }

        public final List<InputDeviceConfigurableAudioChannelPairConfig.Builder> getAudioChannelPairs() {
            List<InputDeviceConfigurableAudioChannelPairConfig.Builder> result = ___listOfInputDeviceConfigurableAudioChannelPairConfigCopier.copyToBuilder(this.audioChannelPairs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudioChannelPairs(Collection<InputDeviceConfigurableAudioChannelPairConfig.BuilderImpl> audioChannelPairs) {
            this.audioChannelPairs = ___listOfInputDeviceConfigurableAudioChannelPairConfigCopier.copyFromBuilder(audioChannelPairs);
        }

        @Override
        public final Builder audioChannelPairs(Collection<InputDeviceConfigurableAudioChannelPairConfig> audioChannelPairs) {
            this.audioChannelPairs = ___listOfInputDeviceConfigurableAudioChannelPairConfigCopier.copy(audioChannelPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioChannelPairs(InputDeviceConfigurableAudioChannelPairConfig ... audioChannelPairs) {
            this.audioChannelPairs(Arrays.asList(audioChannelPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audioChannelPairs(Consumer<InputDeviceConfigurableAudioChannelPairConfig.Builder> ... audioChannelPairs) {
            this.audioChannelPairs(Stream.of(audioChannelPairs).map(c -> (InputDeviceConfigurableAudioChannelPairConfig)((InputDeviceConfigurableAudioChannelPairConfig.Builder)InputDeviceConfigurableAudioChannelPairConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInputResolution() {
            return this.inputResolution;
        }

        public final void setInputResolution(String inputResolution) {
            this.inputResolution = inputResolution;
        }

        @Override
        public final Builder inputResolution(String inputResolution) {
            this.inputResolution = inputResolution;
            return this;
        }

        public InputDeviceConfigurableSettings build() {
            return new InputDeviceConfigurableSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDeviceConfigurableSettings> {
        public Builder configuredInput(String var1);

        public Builder configuredInput(InputDeviceConfiguredInput var1);

        public Builder maxBitrate(Integer var1);

        public Builder latencyMs(Integer var1);

        public Builder codec(String var1);

        public Builder codec(InputDeviceCodec var1);

        public Builder mediaconnectSettings(InputDeviceMediaConnectConfigurableSettings var1);

        default public Builder mediaconnectSettings(Consumer<InputDeviceMediaConnectConfigurableSettings.Builder> mediaconnectSettings) {
            return this.mediaconnectSettings((InputDeviceMediaConnectConfigurableSettings)((InputDeviceMediaConnectConfigurableSettings.Builder)InputDeviceMediaConnectConfigurableSettings.builder().applyMutation(mediaconnectSettings)).build());
        }

        public Builder audioChannelPairs(Collection<InputDeviceConfigurableAudioChannelPairConfig> var1);

        public Builder audioChannelPairs(InputDeviceConfigurableAudioChannelPairConfig ... var1);

        public Builder audioChannelPairs(Consumer<InputDeviceConfigurableAudioChannelPairConfig.Builder> ... var1);

        public Builder inputResolution(String var1);
    }
}

