/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.AudioChannelMapping;
import software.amazon.awssdk.services.medialive.model.___listOfAudioChannelMappingCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemixSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RemixSettings> {
    private static final SdkField<List<AudioChannelMapping>> CHANNEL_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChannelMappings").getter(RemixSettings.getter(RemixSettings::channelMappings)).setter(RemixSettings.setter(Builder::channelMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioChannelMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> CHANNELS_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ChannelsIn").getter(RemixSettings.getter(RemixSettings::channelsIn)).setter(RemixSettings.setter(Builder::channelsIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelsIn").build()}).build();
    private static final SdkField<Integer> CHANNELS_OUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ChannelsOut").getter(RemixSettings.getter(RemixSettings::channelsOut)).setter(RemixSettings.setter(Builder::channelsOut)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelsOut").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_MAPPINGS_FIELD, CHANNELS_IN_FIELD, CHANNELS_OUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemixSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AudioChannelMapping> channelMappings;
    private final Integer channelsIn;
    private final Integer channelsOut;

    private RemixSettings(BuilderImpl builder) {
        this.channelMappings = builder.channelMappings;
        this.channelsIn = builder.channelsIn;
        this.channelsOut = builder.channelsOut;
    }

    public final boolean hasChannelMappings() {
        return this.channelMappings != null && !(this.channelMappings instanceof SdkAutoConstructList);
    }

    public final List<AudioChannelMapping> channelMappings() {
        return this.channelMappings;
    }

    public final Integer channelsIn() {
        return this.channelsIn;
    }

    public final Integer channelsOut() {
        return this.channelsOut;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChannelMappings() ? this.channelMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.channelsIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelsOut());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemixSettings)) {
            return false;
        }
        RemixSettings other = (RemixSettings)obj;
        return this.hasChannelMappings() == other.hasChannelMappings() && Objects.equals(this.channelMappings(), other.channelMappings()) && Objects.equals(this.channelsIn(), other.channelsIn()) && Objects.equals(this.channelsOut(), other.channelsOut());
    }

    public final String toString() {
        return ToString.builder((String)"RemixSettings").add("ChannelMappings", this.hasChannelMappings() ? this.channelMappings() : null).add("ChannelsIn", (Object)this.channelsIn()).add("ChannelsOut", (Object)this.channelsOut()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelMappings": {
                return Optional.ofNullable(clazz.cast(this.channelMappings()));
            }
            case "ChannelsIn": {
                return Optional.ofNullable(clazz.cast(this.channelsIn()));
            }
            case "ChannelsOut": {
                return Optional.ofNullable(clazz.cast(this.channelsOut()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelMappings", CHANNEL_MAPPINGS_FIELD);
        map.put("channelsIn", CHANNELS_IN_FIELD);
        map.put("channelsOut", CHANNELS_OUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemixSettings, T> g) {
        return obj -> g.apply((RemixSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AudioChannelMapping> channelMappings = DefaultSdkAutoConstructList.getInstance();
        private Integer channelsIn;
        private Integer channelsOut;

        private BuilderImpl() {
        }

        private BuilderImpl(RemixSettings model) {
            this.channelMappings(model.channelMappings);
            this.channelsIn(model.channelsIn);
            this.channelsOut(model.channelsOut);
        }

        public final List<AudioChannelMapping.Builder> getChannelMappings() {
            List<AudioChannelMapping.Builder> result = ___listOfAudioChannelMappingCopier.copyToBuilder(this.channelMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelMappings(Collection<AudioChannelMapping.BuilderImpl> channelMappings) {
            this.channelMappings = ___listOfAudioChannelMappingCopier.copyFromBuilder(channelMappings);
        }

        @Override
        public final Builder channelMappings(Collection<AudioChannelMapping> channelMappings) {
            this.channelMappings = ___listOfAudioChannelMappingCopier.copy(channelMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMappings(AudioChannelMapping ... channelMappings) {
            this.channelMappings(Arrays.asList(channelMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelMappings(Consumer<AudioChannelMapping.Builder> ... channelMappings) {
            this.channelMappings(Stream.of(channelMappings).map(c -> (AudioChannelMapping)((AudioChannelMapping.Builder)AudioChannelMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getChannelsIn() {
            return this.channelsIn;
        }

        public final void setChannelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
        }

        @Override
        public final Builder channelsIn(Integer channelsIn) {
            this.channelsIn = channelsIn;
            return this;
        }

        public final Integer getChannelsOut() {
            return this.channelsOut;
        }

        public final void setChannelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
        }

        @Override
        public final Builder channelsOut(Integer channelsOut) {
            this.channelsOut = channelsOut;
            return this;
        }

        public RemixSettings build() {
            return new RemixSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RemixSettings> {
        public Builder channelMappings(Collection<AudioChannelMapping> var1);

        public Builder channelMappings(AudioChannelMapping ... var1);

        public Builder channelMappings(Consumer<AudioChannelMapping.Builder> ... var1);

        public Builder channelsIn(Integer var1);

        public Builder channelsOut(Integer var1);
    }
}

