/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InterfaceMappingUpdateRequest;
import software.amazon.awssdk.services.medialive.model.___listOfInterfaceMappingUpdateRequestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterNetworkSettingsUpdateRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterNetworkSettingsUpdateRequest> {
    private static final SdkField<String> DEFAULT_ROUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultRoute").getter(ClusterNetworkSettingsUpdateRequest.getter(ClusterNetworkSettingsUpdateRequest::defaultRoute)).setter(ClusterNetworkSettingsUpdateRequest.setter(Builder::defaultRoute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultRoute").build()}).build();
    private static final SdkField<List<InterfaceMappingUpdateRequest>> INTERFACE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InterfaceMappings").getter(ClusterNetworkSettingsUpdateRequest.getter(ClusterNetworkSettingsUpdateRequest::interfaceMappings)).setter(ClusterNetworkSettingsUpdateRequest.setter(Builder::interfaceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InterfaceMappingUpdateRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_ROUTE_FIELD, INTERFACE_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterNetworkSettingsUpdateRequest.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String defaultRoute;
    private final List<InterfaceMappingUpdateRequest> interfaceMappings;

    private ClusterNetworkSettingsUpdateRequest(BuilderImpl builder) {
        this.defaultRoute = builder.defaultRoute;
        this.interfaceMappings = builder.interfaceMappings;
    }

    public final String defaultRoute() {
        return this.defaultRoute;
    }

    public final boolean hasInterfaceMappings() {
        return this.interfaceMappings != null && !(this.interfaceMappings instanceof SdkAutoConstructList);
    }

    public final List<InterfaceMappingUpdateRequest> interfaceMappings() {
        return this.interfaceMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultRoute());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInterfaceMappings() ? this.interfaceMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNetworkSettingsUpdateRequest)) {
            return false;
        }
        ClusterNetworkSettingsUpdateRequest other = (ClusterNetworkSettingsUpdateRequest)obj;
        return Objects.equals(this.defaultRoute(), other.defaultRoute()) && this.hasInterfaceMappings() == other.hasInterfaceMappings() && Objects.equals(this.interfaceMappings(), other.interfaceMappings());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterNetworkSettingsUpdateRequest").add("DefaultRoute", (Object)this.defaultRoute()).add("InterfaceMappings", this.hasInterfaceMappings() ? this.interfaceMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultRoute": {
                return Optional.ofNullable(clazz.cast(this.defaultRoute()));
            }
            case "InterfaceMappings": {
                return Optional.ofNullable(clazz.cast(this.interfaceMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultRoute", DEFAULT_ROUTE_FIELD);
        map.put("interfaceMappings", INTERFACE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterNetworkSettingsUpdateRequest, T> g) {
        return obj -> g.apply((ClusterNetworkSettingsUpdateRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultRoute;
        private List<InterfaceMappingUpdateRequest> interfaceMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNetworkSettingsUpdateRequest model) {
            this.defaultRoute(model.defaultRoute);
            this.interfaceMappings(model.interfaceMappings);
        }

        public final String getDefaultRoute() {
            return this.defaultRoute;
        }

        public final void setDefaultRoute(String defaultRoute) {
            this.defaultRoute = defaultRoute;
        }

        @Override
        public final Builder defaultRoute(String defaultRoute) {
            this.defaultRoute = defaultRoute;
            return this;
        }

        public final List<InterfaceMappingUpdateRequest.Builder> getInterfaceMappings() {
            List<InterfaceMappingUpdateRequest.Builder> result = ___listOfInterfaceMappingUpdateRequestCopier.copyToBuilder(this.interfaceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInterfaceMappings(Collection<InterfaceMappingUpdateRequest.BuilderImpl> interfaceMappings) {
            this.interfaceMappings = ___listOfInterfaceMappingUpdateRequestCopier.copyFromBuilder(interfaceMappings);
        }

        @Override
        public final Builder interfaceMappings(Collection<InterfaceMappingUpdateRequest> interfaceMappings) {
            this.interfaceMappings = ___listOfInterfaceMappingUpdateRequestCopier.copy(interfaceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interfaceMappings(InterfaceMappingUpdateRequest ... interfaceMappings) {
            this.interfaceMappings(Arrays.asList(interfaceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder interfaceMappings(Consumer<InterfaceMappingUpdateRequest.Builder> ... interfaceMappings) {
            this.interfaceMappings(Stream.of(interfaceMappings).map(c -> (InterfaceMappingUpdateRequest)((InterfaceMappingUpdateRequest.Builder)InterfaceMappingUpdateRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ClusterNetworkSettingsUpdateRequest build() {
            return new ClusterNetworkSettingsUpdateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterNetworkSettingsUpdateRequest> {
        public Builder defaultRoute(String var1);

        public Builder interfaceMappings(Collection<InterfaceMappingUpdateRequest> var1);

        public Builder interfaceMappings(InterfaceMappingUpdateRequest ... var1);

        public Builder interfaceMappings(Consumer<InterfaceMappingUpdateRequest.Builder> ... var1);
    }
}

