/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaPackageOutputDestinationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaPackageOutputDestinationSettings> {
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(MediaPackageOutputDestinationSettings.getter(MediaPackageOutputDestinationSettings::channelId)).setter(MediaPackageOutputDestinationSettings.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelId").build()}).build();
    private static final SdkField<String> CHANNEL_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelGroup").getter(MediaPackageOutputDestinationSettings.getter(MediaPackageOutputDestinationSettings::channelGroup)).setter(MediaPackageOutputDestinationSettings.setter(Builder::channelGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelGroup").build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(MediaPackageOutputDestinationSettings.getter(MediaPackageOutputDestinationSettings::channelName)).setter(MediaPackageOutputDestinationSettings.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ID_FIELD, CHANNEL_GROUP_FIELD, CHANNEL_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaPackageOutputDestinationSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String channelId;
    private final String channelGroup;
    private final String channelName;

    private MediaPackageOutputDestinationSettings(BuilderImpl builder) {
        this.channelId = builder.channelId;
        this.channelGroup = builder.channelGroup;
        this.channelName = builder.channelName;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final String channelGroup() {
        return this.channelGroup;
    }

    public final String channelName() {
        return this.channelName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaPackageOutputDestinationSettings)) {
            return false;
        }
        MediaPackageOutputDestinationSettings other = (MediaPackageOutputDestinationSettings)obj;
        return Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.channelGroup(), other.channelGroup()) && Objects.equals(this.channelName(), other.channelName());
    }

    public final String toString() {
        return ToString.builder((String)"MediaPackageOutputDestinationSettings").add("ChannelId", (Object)this.channelId()).add("ChannelGroup", (Object)this.channelGroup()).add("ChannelName", (Object)this.channelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "ChannelGroup": {
                return Optional.ofNullable(clazz.cast(this.channelGroup()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("channelId", CHANNEL_ID_FIELD);
        map.put("channelGroup", CHANNEL_GROUP_FIELD);
        map.put("channelName", CHANNEL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaPackageOutputDestinationSettings, T> g) {
        return obj -> g.apply((MediaPackageOutputDestinationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelId;
        private String channelGroup;
        private String channelName;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaPackageOutputDestinationSettings model) {
            this.channelId(model.channelId);
            this.channelGroup(model.channelGroup);
            this.channelName(model.channelName);
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getChannelGroup() {
            return this.channelGroup;
        }

        public final void setChannelGroup(String channelGroup) {
            this.channelGroup = channelGroup;
        }

        @Override
        public final Builder channelGroup(String channelGroup) {
            this.channelGroup = channelGroup;
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public MediaPackageOutputDestinationSettings build() {
            return new MediaPackageOutputDestinationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaPackageOutputDestinationSettings> {
        public Builder channelId(String var1);

        public Builder channelGroup(String var1);

        public Builder channelName(String var1);
    }
}

