/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.Thumbnail;
import software.amazon.awssdk.services.medialive.model.___listOfThumbnailCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThumbnailDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThumbnailDetail> {
    private static final SdkField<String> PIPELINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PipelineId").getter(ThumbnailDetail.getter(ThumbnailDetail::pipelineId)).setter(ThumbnailDetail.setter(Builder::pipelineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineId").build()}).build();
    private static final SdkField<List<Thumbnail>> THUMBNAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Thumbnails").getter(ThumbnailDetail.getter(ThumbnailDetail::thumbnails)).setter(ThumbnailDetail.setter(Builder::thumbnails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Thumbnail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_ID_FIELD, THUMBNAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ThumbnailDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String pipelineId;
    private final List<Thumbnail> thumbnails;

    private ThumbnailDetail(BuilderImpl builder) {
        this.pipelineId = builder.pipelineId;
        this.thumbnails = builder.thumbnails;
    }

    public final String pipelineId() {
        return this.pipelineId;
    }

    public final boolean hasThumbnails() {
        return this.thumbnails != null && !(this.thumbnails instanceof SdkAutoConstructList);
    }

    public final List<Thumbnail> thumbnails() {
        return this.thumbnails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThumbnails() ? this.thumbnails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThumbnailDetail)) {
            return false;
        }
        ThumbnailDetail other = (ThumbnailDetail)obj;
        return Objects.equals(this.pipelineId(), other.pipelineId()) && this.hasThumbnails() == other.hasThumbnails() && Objects.equals(this.thumbnails(), other.thumbnails());
    }

    public final String toString() {
        return ToString.builder((String)"ThumbnailDetail").add("PipelineId", (Object)this.pipelineId()).add("Thumbnails", this.hasThumbnails() ? this.thumbnails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineId": {
                return Optional.ofNullable(clazz.cast(this.pipelineId()));
            }
            case "Thumbnails": {
                return Optional.ofNullable(clazz.cast(this.thumbnails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pipelineId", PIPELINE_ID_FIELD);
        map.put("thumbnails", THUMBNAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThumbnailDetail, T> g) {
        return obj -> g.apply((ThumbnailDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String pipelineId;
        private List<Thumbnail> thumbnails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ThumbnailDetail model) {
            this.pipelineId(model.pipelineId);
            this.thumbnails(model.thumbnails);
        }

        public final String getPipelineId() {
            return this.pipelineId;
        }

        public final void setPipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
        }

        @Override
        public final Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        public final List<Thumbnail.Builder> getThumbnails() {
            List<Thumbnail.Builder> result = ___listOfThumbnailCopier.copyToBuilder(this.thumbnails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThumbnails(Collection<Thumbnail.BuilderImpl> thumbnails) {
            this.thumbnails = ___listOfThumbnailCopier.copyFromBuilder(thumbnails);
        }

        @Override
        public final Builder thumbnails(Collection<Thumbnail> thumbnails) {
            this.thumbnails = ___listOfThumbnailCopier.copy(thumbnails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnails(Thumbnail ... thumbnails) {
            this.thumbnails(Arrays.asList(thumbnails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnails(Consumer<Thumbnail.Builder> ... thumbnails) {
            this.thumbnails(Stream.of(thumbnails).map(c -> (Thumbnail)((Thumbnail.Builder)Thumbnail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ThumbnailDetail build() {
            return new ThumbnailDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThumbnailDetail> {
        public Builder pipelineId(String var1);

        public Builder thumbnails(Collection<Thumbnail> var1);

        public Builder thumbnails(Thumbnail ... var1);

        public Builder thumbnails(Consumer<Thumbnail.Builder> ... var1);
    }
}

