/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.medialive.auth.scheme.MediaLiveAuthSchemeParams;
import software.amazon.awssdk.services.medialive.auth.scheme.internal.DefaultMediaLiveAuthSchemeProvider;
import software.amazon.awssdk.services.medialive.auth.scheme.internal.PreferredMediaLiveAuthSchemeProvider;

@SdkPublicApi
public interface MediaLiveAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(MediaLiveAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<MediaLiveAuthSchemeParams.Builder> consumer) {
        MediaLiveAuthSchemeParams.Builder builder = MediaLiveAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static MediaLiveAuthSchemeProvider defaultProvider() {
        return DefaultMediaLiveAuthSchemeProvider.create();
    }

    public static MediaLiveAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredMediaLiveAuthSchemeProvider(MediaLiveAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

