/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.EventBridgeRuleTemplateGroupSummary;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse;

public class ListEventBridgeRuleTemplateGroupsPublisher
implements SdkPublisher<ListEventBridgeRuleTemplateGroupsResponse> {
    private final MediaLiveAsyncClient client;
    private final ListEventBridgeRuleTemplateGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventBridgeRuleTemplateGroupsPublisher(MediaLiveAsyncClient client, ListEventBridgeRuleTemplateGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventBridgeRuleTemplateGroupsPublisher(MediaLiveAsyncClient client, ListEventBridgeRuleTemplateGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventBridgeRuleTemplateGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventBridgeRuleTemplateGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventBridgeRuleTemplateGroupSummary> eventBridgeRuleTemplateGroups() {
        Function<ListEventBridgeRuleTemplateGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventBridgeRuleTemplateGroups() != null) {
                return response.eventBridgeRuleTemplateGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventBridgeRuleTemplateGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventBridgeRuleTemplateGroupsResponseFetcher
    implements AsyncPageFetcher<ListEventBridgeRuleTemplateGroupsResponse> {
        private ListEventBridgeRuleTemplateGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventBridgeRuleTemplateGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventBridgeRuleTemplateGroupsResponse> nextPage(ListEventBridgeRuleTemplateGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListEventBridgeRuleTemplateGroupsPublisher.this.client.listEventBridgeRuleTemplateGroups(ListEventBridgeRuleTemplateGroupsPublisher.this.firstRequest);
            }
            return ListEventBridgeRuleTemplateGroupsPublisher.this.client.listEventBridgeRuleTemplateGroups((ListEventBridgeRuleTemplateGroupsRequest)((Object)ListEventBridgeRuleTemplateGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

