/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.ContentType;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInputDeviceThumbnailResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, DescribeInputDeviceThumbnailResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(DescribeInputDeviceThumbnailResponse.getter(DescribeInputDeviceThumbnailResponse::contentTypeAsString)).setter(DescribeInputDeviceThumbnailResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ContentLength").getter(DescribeInputDeviceThumbnailResponse.getter(DescribeInputDeviceThumbnailResponse::contentLength)).setter(DescribeInputDeviceThumbnailResponse.setter(Builder::contentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Length").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(DescribeInputDeviceThumbnailResponse.getter(DescribeInputDeviceThumbnailResponse::eTag)).setter(DescribeInputDeviceThumbnailResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(DescribeInputDeviceThumbnailResponse.getter(DescribeInputDeviceThumbnailResponse::lastModified)).setter(DescribeInputDeviceThumbnailResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Last-Modified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, CONTENT_LENGTH_FIELD, E_TAG_FIELD, LAST_MODIFIED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeInputDeviceThumbnailResponse.memberNameToFieldInitializer();
    private final String contentType;
    private final Long contentLength;
    private final String eTag;
    private final Instant lastModified;

    private DescribeInputDeviceThumbnailResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.contentLength = builder.contentLength;
        this.eTag = builder.eTag;
        this.lastModified = builder.lastModified;
    }

    public final ContentType contentType() {
        return ContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public final Long contentLength() {
        return this.contentLength;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInputDeviceThumbnailResponse)) {
            return false;
        }
        DescribeInputDeviceThumbnailResponse other = (DescribeInputDeviceThumbnailResponse)((Object)obj);
        return Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.contentLength(), other.contentLength()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.lastModified(), other.lastModified());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInputDeviceThumbnailResponse").add("ContentType", (Object)this.contentTypeAsString()).add("ContentLength", (Object)this.contentLength()).add("ETag", (Object)this.eTag()).add("LastModified", (Object)this.lastModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "ContentLength": {
                return Optional.ofNullable(clazz.cast(this.contentLength()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("Content-Length", CONTENT_LENGTH_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("Last-Modified", LAST_MODIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInputDeviceThumbnailResponse, T> g) {
        return obj -> g.apply((DescribeInputDeviceThumbnailResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private String contentType;
        private Long contentLength;
        private String eTag;
        private Instant lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInputDeviceThumbnailResponse model) {
            super(model);
            this.contentType(model.contentType);
            this.contentLength(model.contentLength);
            this.eTag(model.eTag);
            this.lastModified(model.lastModified);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(ContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final Long getContentLength() {
            return this.contentLength;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public DescribeInputDeviceThumbnailResponse build() {
            return new DescribeInputDeviceThumbnailResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInputDeviceThumbnailResponse> {
        public Builder contentType(String var1);

        public Builder contentType(ContentType var1);

        public Builder contentLength(Long var1);

        public Builder eTag(String var1);

        public Builder lastModified(Instant var1);
    }
}

