/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.InputDestinationRoute;
import software.amazon.awssdk.services.medialive.model.InputDestinationVpc;
import software.amazon.awssdk.services.medialive.model.___listOfInputDestinationRouteCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputDestination> {
    private static final SdkField<String> IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ip").getter(InputDestination.getter(InputDestination::ip)).setter(InputDestination.setter(Builder::ip)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ip").build()}).build();
    private static final SdkField<String> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Port").getter(InputDestination.getter(InputDestination::port)).setter(InputDestination.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Url").getter(InputDestination.getter(InputDestination::url)).setter(InputDestination.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("url").build()}).build();
    private static final SdkField<InputDestinationVpc> VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Vpc").getter(InputDestination.getter(InputDestination::vpc)).setter(InputDestination.setter(Builder::vpc)).constructor(InputDestinationVpc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()}).build();
    private static final SdkField<String> NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Network").getter(InputDestination.getter(InputDestination::network)).setter(InputDestination.setter(Builder::network)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()}).build();
    private static final SdkField<List<InputDestinationRoute>> NETWORK_ROUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkRoutes").getter(InputDestination.getter(InputDestination::networkRoutes)).setter(InputDestination.setter(Builder::networkRoutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkRoutes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputDestinationRoute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_FIELD, PORT_FIELD, URL_FIELD, VPC_FIELD, NETWORK_FIELD, NETWORK_ROUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputDestination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ip;
    private final String port;
    private final String url;
    private final InputDestinationVpc vpc;
    private final String network;
    private final List<InputDestinationRoute> networkRoutes;

    private InputDestination(BuilderImpl builder) {
        this.ip = builder.ip;
        this.port = builder.port;
        this.url = builder.url;
        this.vpc = builder.vpc;
        this.network = builder.network;
        this.networkRoutes = builder.networkRoutes;
    }

    public final String ip() {
        return this.ip;
    }

    public final String port() {
        return this.port;
    }

    public final String url() {
        return this.url;
    }

    public final InputDestinationVpc vpc() {
        return this.vpc;
    }

    public final String network() {
        return this.network;
    }

    public final boolean hasNetworkRoutes() {
        return this.networkRoutes != null && !(this.networkRoutes instanceof SdkAutoConstructList);
    }

    public final List<InputDestinationRoute> networkRoutes() {
        return this.networkRoutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.network());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkRoutes() ? this.networkRoutes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDestination)) {
            return false;
        }
        InputDestination other = (InputDestination)obj;
        return Objects.equals(this.ip(), other.ip()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.url(), other.url()) && Objects.equals(this.vpc(), other.vpc()) && Objects.equals(this.network(), other.network()) && this.hasNetworkRoutes() == other.hasNetworkRoutes() && Objects.equals(this.networkRoutes(), other.networkRoutes());
    }

    public final String toString() {
        return ToString.builder((String)"InputDestination").add("Ip", (Object)this.ip()).add("Port", (Object)this.port()).add("Url", (Object)this.url()).add("Vpc", (Object)this.vpc()).add("Network", (Object)this.network()).add("NetworkRoutes", this.hasNetworkRoutes() ? this.networkRoutes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ip": {
                return Optional.ofNullable(clazz.cast(this.ip()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
            case "Network": {
                return Optional.ofNullable(clazz.cast(this.network()));
            }
            case "NetworkRoutes": {
                return Optional.ofNullable(clazz.cast(this.networkRoutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ip", IP_FIELD);
        map.put("port", PORT_FIELD);
        map.put("url", URL_FIELD);
        map.put("vpc", VPC_FIELD);
        map.put("network", NETWORK_FIELD);
        map.put("networkRoutes", NETWORK_ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputDestination, T> g) {
        return obj -> g.apply((InputDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ip;
        private String port;
        private String url;
        private InputDestinationVpc vpc;
        private String network;
        private List<InputDestinationRoute> networkRoutes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InputDestination model) {
            this.ip(model.ip);
            this.port(model.port);
            this.url(model.url);
            this.vpc(model.vpc);
            this.network(model.network);
            this.networkRoutes(model.networkRoutes);
        }

        public final String getIp() {
            return this.ip;
        }

        public final void setIp(String ip) {
            this.ip = ip;
        }

        @Override
        public final Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public final String getPort() {
            return this.port;
        }

        public final void setPort(String port) {
            this.port = port;
        }

        @Override
        public final Builder port(String port) {
            this.port = port;
            return this;
        }

        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final InputDestinationVpc.Builder getVpc() {
            return this.vpc != null ? this.vpc.toBuilder() : null;
        }

        public final void setVpc(InputDestinationVpc.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(InputDestinationVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public final String getNetwork() {
            return this.network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        public final List<InputDestinationRoute.Builder> getNetworkRoutes() {
            List<InputDestinationRoute.Builder> result = ___listOfInputDestinationRouteCopier.copyToBuilder(this.networkRoutes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkRoutes(Collection<InputDestinationRoute.BuilderImpl> networkRoutes) {
            this.networkRoutes = ___listOfInputDestinationRouteCopier.copyFromBuilder(networkRoutes);
        }

        @Override
        public final Builder networkRoutes(Collection<InputDestinationRoute> networkRoutes) {
            this.networkRoutes = ___listOfInputDestinationRouteCopier.copy(networkRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkRoutes(InputDestinationRoute ... networkRoutes) {
            this.networkRoutes(Arrays.asList(networkRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkRoutes(Consumer<InputDestinationRoute.Builder> ... networkRoutes) {
            this.networkRoutes(Stream.of(networkRoutes).map(c -> (InputDestinationRoute)((InputDestinationRoute.Builder)InputDestinationRoute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InputDestination build() {
            return new InputDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputDestination> {
        public Builder ip(String var1);

        public Builder port(String var1);

        public Builder url(String var1);

        public Builder vpc(InputDestinationVpc var1);

        default public Builder vpc(Consumer<InputDestinationVpc.Builder> vpc) {
            return this.vpc((InputDestinationVpc)((InputDestinationVpc.Builder)InputDestinationVpc.builder().applyMutation(vpc)).build());
        }

        public Builder network(String var1);

        public Builder networkRoutes(Collection<InputDestinationRoute> var1);

        public Builder networkRoutes(InputDestinationRoute ... var1);

        public Builder networkRoutes(Consumer<InputDestinationRoute.Builder> ... var1);
    }
}

