/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.ClusterAlert;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.___listOfClusterAlertCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListClusterAlertsResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListClusterAlertsResponse> {
    private static final SdkField<List<ClusterAlert>> ALERTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Alerts").getter(ListClusterAlertsResponse.getter(ListClusterAlertsResponse::alerts)).setter(ListClusterAlertsResponse.setter(Builder::alerts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alerts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterAlert::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListClusterAlertsResponse.getter(ListClusterAlertsResponse::nextToken)).setter(ListClusterAlertsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListClusterAlertsResponse.memberNameToFieldInitializer();
    private final List<ClusterAlert> alerts;
    private final String nextToken;

    private ListClusterAlertsResponse(BuilderImpl builder) {
        super(builder);
        this.alerts = builder.alerts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAlerts() {
        return this.alerts != null && !(this.alerts instanceof SdkAutoConstructList);
    }

    public final List<ClusterAlert> alerts() {
        return this.alerts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlerts() ? this.alerts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterAlertsResponse)) {
            return false;
        }
        ListClusterAlertsResponse other = (ListClusterAlertsResponse)((Object)obj);
        return this.hasAlerts() == other.hasAlerts() && Objects.equals(this.alerts(), other.alerts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListClusterAlertsResponse").add("Alerts", this.hasAlerts() ? this.alerts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alerts": {
                return Optional.ofNullable(clazz.cast(this.alerts()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("alerts", ALERTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClusterAlertsResponse, T> g) {
        return obj -> g.apply((ListClusterAlertsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private List<ClusterAlert> alerts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterAlertsResponse model) {
            super(model);
            this.alerts(model.alerts);
            this.nextToken(model.nextToken);
        }

        public final List<ClusterAlert.Builder> getAlerts() {
            List<ClusterAlert.Builder> result = ___listOfClusterAlertCopier.copyToBuilder(this.alerts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlerts(Collection<ClusterAlert.BuilderImpl> alerts) {
            this.alerts = ___listOfClusterAlertCopier.copyFromBuilder(alerts);
        }

        @Override
        public final Builder alerts(Collection<ClusterAlert> alerts) {
            this.alerts = ___listOfClusterAlertCopier.copy(alerts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alerts(ClusterAlert ... alerts) {
            this.alerts(Arrays.asList(alerts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alerts(Consumer<ClusterAlert.Builder> ... alerts) {
            this.alerts(Stream.of(alerts).map(c -> (ClusterAlert)((ClusterAlert.Builder)ClusterAlert.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListClusterAlertsResponse build() {
            return new ListClusterAlertsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListClusterAlertsResponse> {
        public Builder alerts(Collection<ClusterAlert> var1);

        public Builder alerts(ClusterAlert ... var1);

        public Builder alerts(Consumer<ClusterAlert.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

