/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.services.medialive.model.TransferringInputDeviceSummary;
import software.amazon.awssdk.services.medialive.model.___listOfTransferringInputDeviceSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInputDeviceTransfersResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListInputDeviceTransfersResponse> {
    private static final SdkField<List<TransferringInputDeviceSummary>> INPUT_DEVICE_TRANSFERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputDeviceTransfers").getter(ListInputDeviceTransfersResponse.getter(ListInputDeviceTransfersResponse::inputDeviceTransfers)).setter(ListInputDeviceTransfersResponse.setter(Builder::inputDeviceTransfers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputDeviceTransfers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TransferringInputDeviceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInputDeviceTransfersResponse.getter(ListInputDeviceTransfersResponse::nextToken)).setter(ListInputDeviceTransfersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_DEVICE_TRANSFERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInputDeviceTransfersResponse.memberNameToFieldInitializer();
    private final List<TransferringInputDeviceSummary> inputDeviceTransfers;
    private final String nextToken;

    private ListInputDeviceTransfersResponse(BuilderImpl builder) {
        super(builder);
        this.inputDeviceTransfers = builder.inputDeviceTransfers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInputDeviceTransfers() {
        return this.inputDeviceTransfers != null && !(this.inputDeviceTransfers instanceof SdkAutoConstructList);
    }

    public final List<TransferringInputDeviceSummary> inputDeviceTransfers() {
        return this.inputDeviceTransfers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputDeviceTransfers() ? this.inputDeviceTransfers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInputDeviceTransfersResponse)) {
            return false;
        }
        ListInputDeviceTransfersResponse other = (ListInputDeviceTransfersResponse)((Object)obj);
        return this.hasInputDeviceTransfers() == other.hasInputDeviceTransfers() && Objects.equals(this.inputDeviceTransfers(), other.inputDeviceTransfers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInputDeviceTransfersResponse").add("InputDeviceTransfers", this.hasInputDeviceTransfers() ? this.inputDeviceTransfers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputDeviceTransfers": {
                return Optional.ofNullable(clazz.cast(this.inputDeviceTransfers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputDeviceTransfers", INPUT_DEVICE_TRANSFERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInputDeviceTransfersResponse, T> g) {
        return obj -> g.apply((ListInputDeviceTransfersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private List<TransferringInputDeviceSummary> inputDeviceTransfers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInputDeviceTransfersResponse model) {
            super(model);
            this.inputDeviceTransfers(model.inputDeviceTransfers);
            this.nextToken(model.nextToken);
        }

        public final List<TransferringInputDeviceSummary.Builder> getInputDeviceTransfers() {
            List<TransferringInputDeviceSummary.Builder> result = ___listOfTransferringInputDeviceSummaryCopier.copyToBuilder(this.inputDeviceTransfers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDeviceTransfers(Collection<TransferringInputDeviceSummary.BuilderImpl> inputDeviceTransfers) {
            this.inputDeviceTransfers = ___listOfTransferringInputDeviceSummaryCopier.copyFromBuilder(inputDeviceTransfers);
        }

        @Override
        public final Builder inputDeviceTransfers(Collection<TransferringInputDeviceSummary> inputDeviceTransfers) {
            this.inputDeviceTransfers = ___listOfTransferringInputDeviceSummaryCopier.copy(inputDeviceTransfers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDeviceTransfers(TransferringInputDeviceSummary ... inputDeviceTransfers) {
            this.inputDeviceTransfers(Arrays.asList(inputDeviceTransfers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDeviceTransfers(Consumer<TransferringInputDeviceSummary.Builder> ... inputDeviceTransfers) {
            this.inputDeviceTransfers(Stream.of(inputDeviceTransfers).map(c -> (TransferringInputDeviceSummary)((TransferringInputDeviceSummary.Builder)TransferringInputDeviceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInputDeviceTransfersResponse build() {
            return new ListInputDeviceTransfersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaLiveResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInputDeviceTransfersResponse> {
        public Builder inputDeviceTransfers(Collection<TransferringInputDeviceSummary> var1);

        public Builder inputDeviceTransfers(TransferringInputDeviceSummary ... var1);

        public Builder inputDeviceTransfers(Consumer<TransferringInputDeviceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

