/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.EpochLockingSettings;
import software.amazon.awssdk.services.medialive.model.PipelineLockingSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputLockingSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputLockingSettings> {
    private static final SdkField<EpochLockingSettings> EPOCH_LOCKING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EpochLockingSettings").getter(OutputLockingSettings.getter(OutputLockingSettings::epochLockingSettings)).setter(OutputLockingSettings.setter(Builder::epochLockingSettings)).constructor(EpochLockingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epochLockingSettings").build()}).build();
    private static final SdkField<PipelineLockingSettings> PIPELINE_LOCKING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PipelineLockingSettings").getter(OutputLockingSettings.getter(OutputLockingSettings::pipelineLockingSettings)).setter(OutputLockingSettings.setter(Builder::pipelineLockingSettings)).constructor(PipelineLockingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineLockingSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EPOCH_LOCKING_SETTINGS_FIELD, PIPELINE_LOCKING_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OutputLockingSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EpochLockingSettings epochLockingSettings;
    private final PipelineLockingSettings pipelineLockingSettings;

    private OutputLockingSettings(BuilderImpl builder) {
        this.epochLockingSettings = builder.epochLockingSettings;
        this.pipelineLockingSettings = builder.pipelineLockingSettings;
    }

    public final EpochLockingSettings epochLockingSettings() {
        return this.epochLockingSettings;
    }

    public final PipelineLockingSettings pipelineLockingSettings() {
        return this.pipelineLockingSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.epochLockingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.pipelineLockingSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputLockingSettings)) {
            return false;
        }
        OutputLockingSettings other = (OutputLockingSettings)obj;
        return Objects.equals(this.epochLockingSettings(), other.epochLockingSettings()) && Objects.equals(this.pipelineLockingSettings(), other.pipelineLockingSettings());
    }

    public final String toString() {
        return ToString.builder((String)"OutputLockingSettings").add("EpochLockingSettings", (Object)this.epochLockingSettings()).add("PipelineLockingSettings", (Object)this.pipelineLockingSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EpochLockingSettings": {
                return Optional.ofNullable(clazz.cast(this.epochLockingSettings()));
            }
            case "PipelineLockingSettings": {
                return Optional.ofNullable(clazz.cast(this.pipelineLockingSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("epochLockingSettings", EPOCH_LOCKING_SETTINGS_FIELD);
        map.put("pipelineLockingSettings", PIPELINE_LOCKING_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OutputLockingSettings, T> g) {
        return obj -> g.apply((OutputLockingSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EpochLockingSettings epochLockingSettings;
        private PipelineLockingSettings pipelineLockingSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputLockingSettings model) {
            this.epochLockingSettings(model.epochLockingSettings);
            this.pipelineLockingSettings(model.pipelineLockingSettings);
        }

        public final EpochLockingSettings.Builder getEpochLockingSettings() {
            return this.epochLockingSettings != null ? this.epochLockingSettings.toBuilder() : null;
        }

        public final void setEpochLockingSettings(EpochLockingSettings.BuilderImpl epochLockingSettings) {
            this.epochLockingSettings = epochLockingSettings != null ? epochLockingSettings.build() : null;
        }

        @Override
        public final Builder epochLockingSettings(EpochLockingSettings epochLockingSettings) {
            this.epochLockingSettings = epochLockingSettings;
            return this;
        }

        public final PipelineLockingSettings.Builder getPipelineLockingSettings() {
            return this.pipelineLockingSettings != null ? this.pipelineLockingSettings.toBuilder() : null;
        }

        public final void setPipelineLockingSettings(PipelineLockingSettings.BuilderImpl pipelineLockingSettings) {
            this.pipelineLockingSettings = pipelineLockingSettings != null ? pipelineLockingSettings.build() : null;
        }

        @Override
        public final Builder pipelineLockingSettings(PipelineLockingSettings pipelineLockingSettings) {
            this.pipelineLockingSettings = pipelineLockingSettings;
            return this;
        }

        public OutputLockingSettings build() {
            return new OutputLockingSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputLockingSettings> {
        public Builder epochLockingSettings(EpochLockingSettings var1);

        default public Builder epochLockingSettings(Consumer<EpochLockingSettings.Builder> epochLockingSettings) {
            return this.epochLockingSettings((EpochLockingSettings)((EpochLockingSettings.Builder)EpochLockingSettings.builder().applyMutation(epochLockingSettings)).build());
        }

        public Builder pipelineLockingSettings(PipelineLockingSettings var1);

        default public Builder pipelineLockingSettings(Consumer<PipelineLockingSettings.Builder> pipelineLockingSettings) {
            return this.pipelineLockingSettings((PipelineLockingSettings)((PipelineLockingSettings.Builder)PipelineLockingSettings.builder().applyMutation(pipelineLockingSettings)).build());
        }
    }
}

