/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ChannelAlert;
import software.amazon.awssdk.services.medialive.model.ListAlertsRequest;
import software.amazon.awssdk.services.medialive.model.ListAlertsResponse;

public class ListAlertsIterable
implements SdkIterable<ListAlertsResponse> {
    private final MediaLiveClient client;
    private final ListAlertsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAlertsIterable(MediaLiveClient client, ListAlertsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAlertsResponseFetcher();
    }

    public Iterator<ListAlertsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ChannelAlert> alerts() {
        Function<ListAlertsResponse, Iterator> getIterator = response -> {
            if (response != null && response.alerts() != null) {
                return response.alerts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAlertsResponseFetcher
    implements SyncPageFetcher<ListAlertsResponse> {
        private ListAlertsResponseFetcher() {
        }

        public boolean hasNextPage(ListAlertsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAlertsResponse nextPage(ListAlertsResponse previousPage) {
            if (previousPage == null) {
                return ListAlertsIterable.this.client.listAlerts(ListAlertsIterable.this.firstRequest);
            }
            return ListAlertsIterable.this.client.listAlerts((ListAlertsRequest)((Object)ListAlertsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

