/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.MediaLiveServiceClientConfiguration;
import software.amazon.awssdk.services.medialive.internal.MediaLiveServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.AcceptInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.BadGatewayException;
import software.amazon.awssdk.services.medialive.model.BadRequestException;
import software.amazon.awssdk.services.medialive.model.BatchDeleteRequest;
import software.amazon.awssdk.services.medialive.model.BatchDeleteResponse;
import software.amazon.awssdk.services.medialive.model.BatchStartRequest;
import software.amazon.awssdk.services.medialive.model.BatchStartResponse;
import software.amazon.awssdk.services.medialive.model.BatchStopRequest;
import software.amazon.awssdk.services.medialive.model.BatchStopResponse;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleRequest;
import software.amazon.awssdk.services.medialive.model.BatchUpdateScheduleResponse;
import software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.CancelInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.ClaimDeviceRequest;
import software.amazon.awssdk.services.medialive.model.ClaimDeviceResponse;
import software.amazon.awssdk.services.medialive.model.ConflictException;
import software.amazon.awssdk.services.medialive.model.CreateChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateChannelRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelResponse;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.CreateCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.CreateClusterRequest;
import software.amazon.awssdk.services.medialive.model.CreateClusterResponse;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.CreateEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.CreateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.CreateNetworkRequest;
import software.amazon.awssdk.services.medialive.model.CreateNetworkResponse;
import software.amazon.awssdk.services.medialive.model.CreateNodeRegistrationScriptRequest;
import software.amazon.awssdk.services.medialive.model.CreateNodeRegistrationScriptResponse;
import software.amazon.awssdk.services.medialive.model.CreateNodeRequest;
import software.amazon.awssdk.services.medialive.model.CreateNodeResponse;
import software.amazon.awssdk.services.medialive.model.CreatePartnerInputRequest;
import software.amazon.awssdk.services.medialive.model.CreatePartnerInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateSdiSourceRequest;
import software.amazon.awssdk.services.medialive.model.CreateSdiSourceResponse;
import software.amazon.awssdk.services.medialive.model.CreateSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.CreateSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.CreateTagsRequest;
import software.amazon.awssdk.services.medialive.model.CreateTagsResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelResponse;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.DeleteCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.DeleteClusterRequest;
import software.amazon.awssdk.services.medialive.model.DeleteClusterResponse;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.DeleteEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DeleteMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DeleteNetworkRequest;
import software.amazon.awssdk.services.medialive.model.DeleteNetworkResponse;
import software.amazon.awssdk.services.medialive.model.DeleteNodeRequest;
import software.amazon.awssdk.services.medialive.model.DeleteNodeResponse;
import software.amazon.awssdk.services.medialive.model.DeleteReservationRequest;
import software.amazon.awssdk.services.medialive.model.DeleteReservationResponse;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DeleteScheduleResponse;
import software.amazon.awssdk.services.medialive.model.DeleteSdiSourceRequest;
import software.amazon.awssdk.services.medialive.model.DeleteSdiSourceResponse;
import software.amazon.awssdk.services.medialive.model.DeleteSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.DeleteSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.DeleteTagsRequest;
import software.amazon.awssdk.services.medialive.model.DeleteTagsResponse;
import software.amazon.awssdk.services.medialive.model.DescribeAccountConfigurationRequest;
import software.amazon.awssdk.services.medialive.model.DescribeAccountConfigurationResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelResponse;
import software.amazon.awssdk.services.medialive.model.DescribeClusterRequest;
import software.amazon.awssdk.services.medialive.model.DescribeClusterResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputDeviceThumbnailResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DescribeNetworkRequest;
import software.amazon.awssdk.services.medialive.model.DescribeNetworkResponse;
import software.amazon.awssdk.services.medialive.model.DescribeNodeRequest;
import software.amazon.awssdk.services.medialive.model.DescribeNodeResponse;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.medialive.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.medialive.model.DescribeReservationRequest;
import software.amazon.awssdk.services.medialive.model.DescribeReservationResponse;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleRequest;
import software.amazon.awssdk.services.medialive.model.DescribeScheduleResponse;
import software.amazon.awssdk.services.medialive.model.DescribeSdiSourceRequest;
import software.amazon.awssdk.services.medialive.model.DescribeSdiSourceResponse;
import software.amazon.awssdk.services.medialive.model.DescribeThumbnailsRequest;
import software.amazon.awssdk.services.medialive.model.DescribeThumbnailsResponse;
import software.amazon.awssdk.services.medialive.model.ForbiddenException;
import software.amazon.awssdk.services.medialive.model.GatewayTimeoutException;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.GetCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.GetEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.GetSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.GetSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.InternalServerErrorException;
import software.amazon.awssdk.services.medialive.model.ListAlertsRequest;
import software.amazon.awssdk.services.medialive.model.ListAlertsResponse;
import software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListChannelsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelsResponse;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplatesResponse;
import software.amazon.awssdk.services.medialive.model.ListClusterAlertsRequest;
import software.amazon.awssdk.services.medialive.model.ListClusterAlertsResponse;
import software.amazon.awssdk.services.medialive.model.ListClustersRequest;
import software.amazon.awssdk.services.medialive.model.ListClustersResponse;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplateGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesRequest;
import software.amazon.awssdk.services.medialive.model.ListEventBridgeRuleTemplatesResponse;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDeviceTransfersResponse;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesRequest;
import software.amazon.awssdk.services.medialive.model.ListInputDevicesResponse;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexAlertsRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexAlertsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexesResponse;
import software.amazon.awssdk.services.medialive.model.ListNetworksRequest;
import software.amazon.awssdk.services.medialive.model.ListNetworksResponse;
import software.amazon.awssdk.services.medialive.model.ListNodesRequest;
import software.amazon.awssdk.services.medialive.model.ListNodesResponse;
import software.amazon.awssdk.services.medialive.model.ListOfferingsRequest;
import software.amazon.awssdk.services.medialive.model.ListOfferingsResponse;
import software.amazon.awssdk.services.medialive.model.ListReservationsRequest;
import software.amazon.awssdk.services.medialive.model.ListReservationsResponse;
import software.amazon.awssdk.services.medialive.model.ListSdiSourcesRequest;
import software.amazon.awssdk.services.medialive.model.ListSdiSourcesResponse;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsRequest;
import software.amazon.awssdk.services.medialive.model.ListSignalMapsResponse;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.medialive.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.medialive.model.ListVersionsRequest;
import software.amazon.awssdk.services.medialive.model.ListVersionsResponse;
import software.amazon.awssdk.services.medialive.model.MediaLiveException;
import software.amazon.awssdk.services.medialive.model.NotFoundException;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.medialive.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.medialive.model.RebootInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.RebootInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferRequest;
import software.amazon.awssdk.services.medialive.model.RejectInputDeviceTransferResponse;
import software.amazon.awssdk.services.medialive.model.RestartChannelPipelinesRequest;
import software.amazon.awssdk.services.medialive.model.RestartChannelPipelinesResponse;
import software.amazon.awssdk.services.medialive.model.StartChannelRequest;
import software.amazon.awssdk.services.medialive.model.StartChannelResponse;
import software.amazon.awssdk.services.medialive.model.StartDeleteMonitorDeploymentRequest;
import software.amazon.awssdk.services.medialive.model.StartDeleteMonitorDeploymentResponse;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceMaintenanceWindowRequest;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceMaintenanceWindowResponse;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.StartInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.StartMonitorDeploymentRequest;
import software.amazon.awssdk.services.medialive.model.StartMonitorDeploymentResponse;
import software.amazon.awssdk.services.medialive.model.StartMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StartMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.StartUpdateSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.StartUpdateSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.StopChannelRequest;
import software.amazon.awssdk.services.medialive.model.StopChannelResponse;
import software.amazon.awssdk.services.medialive.model.StopInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.StopInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.StopMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.StopMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.TooManyRequestsException;
import software.amazon.awssdk.services.medialive.model.TransferInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.TransferInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.UnprocessableEntityException;
import software.amazon.awssdk.services.medialive.model.UpdateAccountConfigurationRequest;
import software.amazon.awssdk.services.medialive.model.UpdateAccountConfigurationResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelClassResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateChannelRequest;
import software.amazon.awssdk.services.medialive.model.UpdateChannelResponse;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateCloudWatchAlarmTemplateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateClusterRequest;
import software.amazon.awssdk.services.medialive.model.UpdateClusterResponse;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateEventBridgeRuleTemplateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputDeviceResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputResponse;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.UpdateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexProgramResponse;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.UpdateMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.UpdateNetworkRequest;
import software.amazon.awssdk.services.medialive.model.UpdateNetworkResponse;
import software.amazon.awssdk.services.medialive.model.UpdateNodeRequest;
import software.amazon.awssdk.services.medialive.model.UpdateNodeResponse;
import software.amazon.awssdk.services.medialive.model.UpdateNodeStateRequest;
import software.amazon.awssdk.services.medialive.model.UpdateNodeStateResponse;
import software.amazon.awssdk.services.medialive.model.UpdateReservationRequest;
import software.amazon.awssdk.services.medialive.model.UpdateReservationResponse;
import software.amazon.awssdk.services.medialive.model.UpdateSdiSourceRequest;
import software.amazon.awssdk.services.medialive.model.UpdateSdiSourceResponse;
import software.amazon.awssdk.services.medialive.transform.AcceptInputDeviceTransferRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.BatchDeleteRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.BatchStartRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.BatchStopRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.BatchUpdateScheduleRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CancelInputDeviceTransferRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ClaimDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateChannelPlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateCloudWatchAlarmTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateCloudWatchAlarmTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateEventBridgeRuleTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateEventBridgeRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateMultiplexProgramRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateNetworkRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateNodeRegistrationScriptRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateNodeRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreatePartnerInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateSdiSourceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateSignalMapRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteChannelPlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteCloudWatchAlarmTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteCloudWatchAlarmTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteEventBridgeRuleTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteEventBridgeRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteMultiplexProgramRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteNetworkRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteNodeRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteReservationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteScheduleRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteSdiSourceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteSignalMapRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeAccountConfigurationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeChannelPlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeClusterRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputDeviceThumbnailRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeMultiplexProgramRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeNetworkRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeNodeRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeOfferingRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeReservationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeScheduleRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeSdiSourceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.DescribeThumbnailsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetCloudWatchAlarmTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetCloudWatchAlarmTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetEventBridgeRuleTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetEventBridgeRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.GetSignalMapRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListAlertsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListChannelPlacementGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListChannelsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListCloudWatchAlarmTemplateGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListCloudWatchAlarmTemplatesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListClusterAlertsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListEventBridgeRuleTemplateGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListEventBridgeRuleTemplatesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputDeviceTransfersRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputDevicesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListInputsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListMultiplexAlertsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListMultiplexProgramsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListMultiplexesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListNetworksRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListNodesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListOfferingsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListReservationsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListSdiSourcesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListSignalMapsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.ListVersionsRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.PurchaseOfferingRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.RebootInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.RejectInputDeviceTransferRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.RestartChannelPipelinesRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartDeleteMonitorDeploymentRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartInputDeviceMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartMonitorDeploymentRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StartUpdateSignalMapRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StopChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StopInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.StopMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.TransferInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateAccountConfigurationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateChannelClassRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateChannelPlacementGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateChannelRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateCloudWatchAlarmTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateCloudWatchAlarmTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateEventBridgeRuleTemplateGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateEventBridgeRuleTemplateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateInputDeviceRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateInputRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateInputSecurityGroupRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateMultiplexProgramRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateMultiplexRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateNetworkRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateNodeRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateNodeStateRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateReservationRequestMarshaller;
import software.amazon.awssdk.services.medialive.transform.UpdateSdiSourceRequestMarshaller;
import software.amazon.awssdk.services.medialive.waiters.MediaLiveWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultMediaLiveClient
implements MediaLiveClient {
    private static final Logger log = Logger.loggerFor(DefaultMediaLiveClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMediaLiveClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"MediaLive#2.39.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptInputDeviceTransferResponse acceptInputDeviceTransfer(AcceptInputDeviceTransferRequest acceptInputDeviceTransferRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptInputDeviceTransferResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptInputDeviceTransferRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, acceptInputDeviceTransferRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptInputDeviceTransfer");
            AcceptInputDeviceTransferResponse acceptInputDeviceTransferResponse = (AcceptInputDeviceTransferResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptInputDeviceTransfer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acceptInputDeviceTransferRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptInputDeviceTransferRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptInputDeviceTransferResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$acceptInputDeviceTransfer$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteResponse batchDelete(BatchDeleteRequest batchDeleteRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchDeleteRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, batchDeleteRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDelete");
            BatchDeleteResponse batchDeleteResponse = (BatchDeleteResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDelete").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchDeleteRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$batchDelete$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchStartResponse batchStart(BatchStartRequest batchStartRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchStartResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchStartRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, batchStartRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchStart");
            BatchStartResponse batchStartResponse = (BatchStartResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchStart").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchStartRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchStartRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchStartResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$batchStart$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchStopResponse batchStop(BatchStopRequest batchStopRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchStopResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchStopRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, batchStopRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchStop");
            BatchStopResponse batchStopResponse = (BatchStopResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchStop").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchStopRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchStopRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchStopResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$batchStop$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchUpdateScheduleResponse batchUpdateSchedule(BatchUpdateScheduleRequest batchUpdateScheduleRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdateScheduleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchUpdateScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, batchUpdateScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdateSchedule");
            BatchUpdateScheduleResponse batchUpdateScheduleResponse = (BatchUpdateScheduleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdateSchedule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchUpdateScheduleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchUpdateScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchUpdateScheduleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$batchUpdateSchedule$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelInputDeviceTransferResponse cancelInputDeviceTransfer(CancelInputDeviceTransferRequest cancelInputDeviceTransferRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelInputDeviceTransferResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelInputDeviceTransferRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, cancelInputDeviceTransferRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelInputDeviceTransfer");
            CancelInputDeviceTransferResponse cancelInputDeviceTransferResponse = (CancelInputDeviceTransferResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelInputDeviceTransfer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelInputDeviceTransferRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelInputDeviceTransferRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelInputDeviceTransferResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$cancelInputDeviceTransfer$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClaimDeviceResponse claimDevice(ClaimDeviceRequest claimDeviceRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ClaimDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)claimDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, claimDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ClaimDevice");
            ClaimDeviceResponse claimDeviceResponse = (ClaimDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ClaimDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)claimDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ClaimDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return claimDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$claimDevice$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateChannel");
            CreateChannelResponse createChannelResponse = (CreateChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createChannel$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateChannelPlacementGroupResponse createChannelPlacementGroup(CreateChannelPlacementGroupRequest createChannelPlacementGroupRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateChannelPlacementGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createChannelPlacementGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createChannelPlacementGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateChannelPlacementGroup");
            CreateChannelPlacementGroupResponse createChannelPlacementGroupResponse = (CreateChannelPlacementGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateChannelPlacementGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createChannelPlacementGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateChannelPlacementGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createChannelPlacementGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createChannelPlacementGroup$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCloudWatchAlarmTemplateResponse createCloudWatchAlarmTemplate(CreateCloudWatchAlarmTemplateRequest createCloudWatchAlarmTemplateRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCloudWatchAlarmTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCloudWatchAlarmTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createCloudWatchAlarmTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCloudWatchAlarmTemplate");
            CreateCloudWatchAlarmTemplateResponse createCloudWatchAlarmTemplateResponse = (CreateCloudWatchAlarmTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCloudWatchAlarmTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCloudWatchAlarmTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCloudWatchAlarmTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCloudWatchAlarmTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createCloudWatchAlarmTemplate$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCloudWatchAlarmTemplateGroupResponse createCloudWatchAlarmTemplateGroup(CreateCloudWatchAlarmTemplateGroupRequest createCloudWatchAlarmTemplateGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCloudWatchAlarmTemplateGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCloudWatchAlarmTemplateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createCloudWatchAlarmTemplateGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCloudWatchAlarmTemplateGroup");
            CreateCloudWatchAlarmTemplateGroupResponse createCloudWatchAlarmTemplateGroupResponse = (CreateCloudWatchAlarmTemplateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCloudWatchAlarmTemplateGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createCloudWatchAlarmTemplateGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCloudWatchAlarmTemplateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCloudWatchAlarmTemplateGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createCloudWatchAlarmTemplateGroup$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            CreateClusterResponse createClusterResponse = (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createCluster$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEventBridgeRuleTemplateResponse createEventBridgeRuleTemplate(CreateEventBridgeRuleTemplateRequest createEventBridgeRuleTemplateRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventBridgeRuleTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEventBridgeRuleTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createEventBridgeRuleTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventBridgeRuleTemplate");
            CreateEventBridgeRuleTemplateResponse createEventBridgeRuleTemplateResponse = (CreateEventBridgeRuleTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventBridgeRuleTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEventBridgeRuleTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEventBridgeRuleTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEventBridgeRuleTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createEventBridgeRuleTemplate$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEventBridgeRuleTemplateGroupResponse createEventBridgeRuleTemplateGroup(CreateEventBridgeRuleTemplateGroupRequest createEventBridgeRuleTemplateGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventBridgeRuleTemplateGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEventBridgeRuleTemplateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createEventBridgeRuleTemplateGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventBridgeRuleTemplateGroup");
            CreateEventBridgeRuleTemplateGroupResponse createEventBridgeRuleTemplateGroupResponse = (CreateEventBridgeRuleTemplateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventBridgeRuleTemplateGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEventBridgeRuleTemplateGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEventBridgeRuleTemplateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEventBridgeRuleTemplateGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createEventBridgeRuleTemplateGroup$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInputResponse createInput(CreateInputRequest createInputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInput");
            CreateInputResponse createInputResponse = (CreateInputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createInputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createInputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createInput$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInputSecurityGroupResponse createInputSecurityGroup(CreateInputSecurityGroupRequest createInputSecurityGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInputSecurityGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInputSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createInputSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInputSecurityGroup");
            CreateInputSecurityGroupResponse createInputSecurityGroupResponse = (CreateInputSecurityGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInputSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createInputSecurityGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateInputSecurityGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createInputSecurityGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createInputSecurityGroup$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMultiplexResponse createMultiplex(CreateMultiplexRequest createMultiplexRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMultiplexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMultiplexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createMultiplexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMultiplex");
            CreateMultiplexResponse createMultiplexResponse = (CreateMultiplexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMultiplex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMultiplexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMultiplexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMultiplexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createMultiplex$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMultiplexProgramResponse createMultiplexProgram(CreateMultiplexProgramRequest createMultiplexProgramRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMultiplexProgramResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createMultiplexProgramRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createMultiplexProgramRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMultiplexProgram");
            CreateMultiplexProgramResponse createMultiplexProgramResponse = (CreateMultiplexProgramResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMultiplexProgram").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createMultiplexProgramRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMultiplexProgramRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMultiplexProgramResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createMultiplexProgram$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNetworkResponse createNetwork(CreateNetworkRequest createNetworkRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNetworkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNetwork");
            CreateNetworkResponse createNetworkResponse = (CreateNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNetwork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createNetworkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createNetworkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createNetwork$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNodeResponse createNode(CreateNodeRequest createNodeRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNode");
            CreateNodeResponse createNodeResponse = (CreateNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createNode$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateNodeRegistrationScriptResponse createNodeRegistrationScript(CreateNodeRegistrationScriptRequest createNodeRegistrationScriptRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNodeRegistrationScriptResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createNodeRegistrationScriptRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createNodeRegistrationScriptRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNodeRegistrationScript");
            CreateNodeRegistrationScriptResponse createNodeRegistrationScriptResponse = (CreateNodeRegistrationScriptResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNodeRegistrationScript").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createNodeRegistrationScriptRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateNodeRegistrationScriptRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createNodeRegistrationScriptResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createNodeRegistrationScript$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePartnerInputResponse createPartnerInput(CreatePartnerInputRequest createPartnerInputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePartnerInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createPartnerInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createPartnerInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreatePartnerInput");
            CreatePartnerInputResponse createPartnerInputResponse = (CreatePartnerInputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePartnerInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createPartnerInputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreatePartnerInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createPartnerInputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createPartnerInput$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSdiSourceResponse createSdiSource(CreateSdiSourceRequest createSdiSourceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSdiSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSdiSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createSdiSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSdiSource");
            CreateSdiSourceResponse createSdiSourceResponse = (CreateSdiSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSdiSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSdiSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSdiSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSdiSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createSdiSource$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSignalMapResponse createSignalMap(CreateSignalMapRequest createSignalMapRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSignalMapResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSignalMapRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createSignalMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSignalMap");
            CreateSignalMapResponse createSignalMapResponse = (CreateSignalMapResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSignalMap").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createSignalMapRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSignalMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSignalMapResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createSignalMap$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, createTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTags");
            CreateTagsResponse createTagsResponse = (CreateTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$createTags$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteChannel");
            DeleteChannelResponse deleteChannelResponse = (DeleteChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteChannel$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteChannelPlacementGroupResponse deleteChannelPlacementGroup(DeleteChannelPlacementGroupRequest deleteChannelPlacementGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteChannelPlacementGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteChannelPlacementGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteChannelPlacementGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteChannelPlacementGroup");
            DeleteChannelPlacementGroupResponse deleteChannelPlacementGroupResponse = (DeleteChannelPlacementGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteChannelPlacementGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteChannelPlacementGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteChannelPlacementGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteChannelPlacementGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteChannelPlacementGroup$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCloudWatchAlarmTemplateResponse deleteCloudWatchAlarmTemplate(DeleteCloudWatchAlarmTemplateRequest deleteCloudWatchAlarmTemplateRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCloudWatchAlarmTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCloudWatchAlarmTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteCloudWatchAlarmTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCloudWatchAlarmTemplate");
            DeleteCloudWatchAlarmTemplateResponse deleteCloudWatchAlarmTemplateResponse = (DeleteCloudWatchAlarmTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCloudWatchAlarmTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCloudWatchAlarmTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCloudWatchAlarmTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCloudWatchAlarmTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteCloudWatchAlarmTemplate$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCloudWatchAlarmTemplateGroupResponse deleteCloudWatchAlarmTemplateGroup(DeleteCloudWatchAlarmTemplateGroupRequest deleteCloudWatchAlarmTemplateGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCloudWatchAlarmTemplateGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCloudWatchAlarmTemplateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteCloudWatchAlarmTemplateGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCloudWatchAlarmTemplateGroup");
            DeleteCloudWatchAlarmTemplateGroupResponse deleteCloudWatchAlarmTemplateGroupResponse = (DeleteCloudWatchAlarmTemplateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCloudWatchAlarmTemplateGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteCloudWatchAlarmTemplateGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCloudWatchAlarmTemplateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCloudWatchAlarmTemplateGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteCloudWatchAlarmTemplateGroup$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            DeleteClusterResponse deleteClusterResponse = (DeleteClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteCluster$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventBridgeRuleTemplateResponse deleteEventBridgeRuleTemplate(DeleteEventBridgeRuleTemplateRequest deleteEventBridgeRuleTemplateRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventBridgeRuleTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEventBridgeRuleTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteEventBridgeRuleTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventBridgeRuleTemplate");
            DeleteEventBridgeRuleTemplateResponse deleteEventBridgeRuleTemplateResponse = (DeleteEventBridgeRuleTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventBridgeRuleTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEventBridgeRuleTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEventBridgeRuleTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEventBridgeRuleTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteEventBridgeRuleTemplate$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventBridgeRuleTemplateGroupResponse deleteEventBridgeRuleTemplateGroup(DeleteEventBridgeRuleTemplateGroupRequest deleteEventBridgeRuleTemplateGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventBridgeRuleTemplateGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEventBridgeRuleTemplateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteEventBridgeRuleTemplateGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventBridgeRuleTemplateGroup");
            DeleteEventBridgeRuleTemplateGroupResponse deleteEventBridgeRuleTemplateGroupResponse = (DeleteEventBridgeRuleTemplateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventBridgeRuleTemplateGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEventBridgeRuleTemplateGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEventBridgeRuleTemplateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEventBridgeRuleTemplateGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteEventBridgeRuleTemplateGroup$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInputResponse deleteInput(DeleteInputRequest deleteInputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInput");
            DeleteInputResponse deleteInputResponse = (DeleteInputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteInputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteInput$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInputSecurityGroupResponse deleteInputSecurityGroup(DeleteInputSecurityGroupRequest deleteInputSecurityGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInputSecurityGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInputSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteInputSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInputSecurityGroup");
            DeleteInputSecurityGroupResponse deleteInputSecurityGroupResponse = (DeleteInputSecurityGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInputSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteInputSecurityGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteInputSecurityGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteInputSecurityGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteInputSecurityGroup$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMultiplexResponse deleteMultiplex(DeleteMultiplexRequest deleteMultiplexRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMultiplexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMultiplexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteMultiplexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMultiplex");
            DeleteMultiplexResponse deleteMultiplexResponse = (DeleteMultiplexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMultiplex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteMultiplexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMultiplexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMultiplexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteMultiplex$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteMultiplexProgramResponse deleteMultiplexProgram(DeleteMultiplexProgramRequest deleteMultiplexProgramRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteMultiplexProgramResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteMultiplexProgramRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteMultiplexProgramRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMultiplexProgram");
            DeleteMultiplexProgramResponse deleteMultiplexProgramResponse = (DeleteMultiplexProgramResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMultiplexProgram").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteMultiplexProgramRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteMultiplexProgramRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteMultiplexProgramResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteMultiplexProgram$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNetworkResponse deleteNetwork(DeleteNetworkRequest deleteNetworkRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNetworkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNetwork");
            DeleteNetworkResponse deleteNetworkResponse = (DeleteNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNetwork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteNetworkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteNetworkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteNetwork$73((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNodeResponse deleteNode(DeleteNodeRequest deleteNodeRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNode");
            DeleteNodeResponse deleteNodeResponse = (DeleteNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteNode$75((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReservationResponse deleteReservation(DeleteReservationRequest deleteReservationRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteReservationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReservation");
            DeleteReservationResponse deleteReservationResponse = (DeleteReservationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReservation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteReservationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReservationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReservationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteReservation$77((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteScheduleResponse deleteSchedule(DeleteScheduleRequest deleteScheduleRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScheduleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSchedule");
            DeleteScheduleResponse deleteScheduleResponse = (DeleteScheduleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSchedule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteScheduleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteScheduleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteSchedule$79((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSdiSourceResponse deleteSdiSource(DeleteSdiSourceRequest deleteSdiSourceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSdiSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSdiSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteSdiSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSdiSource");
            DeleteSdiSourceResponse deleteSdiSourceResponse = (DeleteSdiSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSdiSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSdiSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSdiSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSdiSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteSdiSource$81((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSignalMapResponse deleteSignalMap(DeleteSignalMapRequest deleteSignalMapRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSignalMapResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSignalMapRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteSignalMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSignalMap");
            DeleteSignalMapResponse deleteSignalMapResponse = (DeleteSignalMapResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSignalMap").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteSignalMapRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSignalMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSignalMapResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteSignalMap$83((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, deleteTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTags");
            DeleteTagsResponse deleteTagsResponse = (DeleteTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$deleteTags$85((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountConfigurationResponse describeAccountConfiguration(DescribeAccountConfigurationRequest describeAccountConfigurationRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAccountConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeAccountConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountConfiguration");
            DescribeAccountConfigurationResponse describeAccountConfigurationResponse = (DescribeAccountConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAccountConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccountConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeAccountConfiguration$87((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeChannelResponse describeChannel(DescribeChannelRequest describeChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeChannel");
            DescribeChannelResponse describeChannelResponse = (DescribeChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeChannel$89((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeChannelPlacementGroupResponse describeChannelPlacementGroup(DescribeChannelPlacementGroupRequest describeChannelPlacementGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeChannelPlacementGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeChannelPlacementGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeChannelPlacementGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeChannelPlacementGroup");
            DescribeChannelPlacementGroupResponse describeChannelPlacementGroupResponse = (DescribeChannelPlacementGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeChannelPlacementGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeChannelPlacementGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeChannelPlacementGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeChannelPlacementGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeChannelPlacementGroup$91((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClusterResponse describeCluster(DescribeClusterRequest describeClusterRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCluster");
            DescribeClusterResponse describeClusterResponse = (DescribeClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeCluster$93((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInputResponse describeInput(DescribeInputRequest describeInputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInput");
            DescribeInputResponse describeInputResponse = (DescribeInputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeInputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeInputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeInput$95((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInputDeviceResponse describeInputDevice(DescribeInputDeviceRequest describeInputDeviceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInputDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInputDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeInputDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInputDevice");
            DescribeInputDeviceResponse describeInputDeviceResponse = (DescribeInputDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInputDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeInputDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInputDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeInputDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeInputDevice$97((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT describeInputDeviceThumbnail(DescribeInputDeviceThumbnailRequest describeInputDeviceThumbnailRequest, ResponseTransformer<DescribeInputDeviceThumbnailResponse, ReturnT> responseTransformer) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInputDeviceThumbnailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInputDeviceThumbnailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeInputDeviceThumbnailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInputDeviceThumbnail");
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInputDeviceThumbnail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeInputDeviceThumbnailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withResponseTransformer(responseTransformer).withMarshaller((Marshaller)new DescribeInputDeviceThumbnailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeInputDeviceThumbnail$99((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInputSecurityGroupResponse describeInputSecurityGroup(DescribeInputSecurityGroupRequest describeInputSecurityGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInputSecurityGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInputSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeInputSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInputSecurityGroup");
            DescribeInputSecurityGroupResponse describeInputSecurityGroupResponse = (DescribeInputSecurityGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInputSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeInputSecurityGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeInputSecurityGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeInputSecurityGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeInputSecurityGroup$101((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMultiplexResponse describeMultiplex(DescribeMultiplexRequest describeMultiplexRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMultiplexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMultiplexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeMultiplexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMultiplex");
            DescribeMultiplexResponse describeMultiplexResponse = (DescribeMultiplexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMultiplex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMultiplexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMultiplexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMultiplexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeMultiplex$103((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeMultiplexProgramResponse describeMultiplexProgram(DescribeMultiplexProgramRequest describeMultiplexProgramRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMultiplexProgramResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMultiplexProgramRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeMultiplexProgramRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMultiplexProgram");
            DescribeMultiplexProgramResponse describeMultiplexProgramResponse = (DescribeMultiplexProgramResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMultiplexProgram").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeMultiplexProgramRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeMultiplexProgramRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeMultiplexProgramResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeMultiplexProgram$105((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNetworkResponse describeNetwork(DescribeNetworkRequest describeNetworkRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNetworkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNetwork");
            DescribeNetworkResponse describeNetworkResponse = (DescribeNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNetwork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeNetworkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeNetworkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeNetwork$107((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNodeResponse describeNode(DescribeNodeRequest describeNodeRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNode");
            DescribeNodeResponse describeNodeResponse = (DescribeNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeNode$109((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeOfferingResponse describeOffering(DescribeOfferingRequest describeOfferingRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOfferingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOfferingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeOfferingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOffering");
            DescribeOfferingResponse describeOfferingResponse = (DescribeOfferingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOffering").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeOfferingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeOfferingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeOfferingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeOffering$111((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReservationResponse describeReservation(DescribeReservationRequest describeReservationRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeReservationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservation");
            DescribeReservationResponse describeReservationResponse = (DescribeReservationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeReservationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReservationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReservationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeReservation$113((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScheduleResponse describeSchedule(DescribeScheduleRequest describeScheduleRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScheduleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScheduleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSchedule");
            DescribeScheduleResponse describeScheduleResponse = (DescribeScheduleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSchedule").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeScheduleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeScheduleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeSchedule$115((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSdiSourceResponse describeSdiSource(DescribeSdiSourceRequest describeSdiSourceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSdiSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSdiSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeSdiSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSdiSource");
            DescribeSdiSourceResponse describeSdiSourceResponse = (DescribeSdiSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSdiSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeSdiSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSdiSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSdiSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeSdiSource$117((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeThumbnailsResponse describeThumbnails(DescribeThumbnailsRequest describeThumbnailsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeThumbnailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeThumbnailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, describeThumbnailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeThumbnails");
            DescribeThumbnailsResponse describeThumbnailsResponse = (DescribeThumbnailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeThumbnails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeThumbnailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeThumbnailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeThumbnailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$describeThumbnails$119((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCloudWatchAlarmTemplateResponse getCloudWatchAlarmTemplate(GetCloudWatchAlarmTemplateRequest getCloudWatchAlarmTemplateRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCloudWatchAlarmTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCloudWatchAlarmTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, getCloudWatchAlarmTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCloudWatchAlarmTemplate");
            GetCloudWatchAlarmTemplateResponse getCloudWatchAlarmTemplateResponse = (GetCloudWatchAlarmTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudWatchAlarmTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCloudWatchAlarmTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCloudWatchAlarmTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCloudWatchAlarmTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$getCloudWatchAlarmTemplate$121((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCloudWatchAlarmTemplateGroupResponse getCloudWatchAlarmTemplateGroup(GetCloudWatchAlarmTemplateGroupRequest getCloudWatchAlarmTemplateGroupRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCloudWatchAlarmTemplateGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCloudWatchAlarmTemplateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, getCloudWatchAlarmTemplateGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCloudWatchAlarmTemplateGroup");
            GetCloudWatchAlarmTemplateGroupResponse getCloudWatchAlarmTemplateGroupResponse = (GetCloudWatchAlarmTemplateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCloudWatchAlarmTemplateGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getCloudWatchAlarmTemplateGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCloudWatchAlarmTemplateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCloudWatchAlarmTemplateGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$getCloudWatchAlarmTemplateGroup$123((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEventBridgeRuleTemplateResponse getEventBridgeRuleTemplate(GetEventBridgeRuleTemplateRequest getEventBridgeRuleTemplateRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventBridgeRuleTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventBridgeRuleTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, getEventBridgeRuleTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventBridgeRuleTemplate");
            GetEventBridgeRuleTemplateResponse getEventBridgeRuleTemplateResponse = (GetEventBridgeRuleTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventBridgeRuleTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEventBridgeRuleTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEventBridgeRuleTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEventBridgeRuleTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$getEventBridgeRuleTemplate$125((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEventBridgeRuleTemplateGroupResponse getEventBridgeRuleTemplateGroup(GetEventBridgeRuleTemplateGroupRequest getEventBridgeRuleTemplateGroupRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventBridgeRuleTemplateGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventBridgeRuleTemplateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, getEventBridgeRuleTemplateGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventBridgeRuleTemplateGroup");
            GetEventBridgeRuleTemplateGroupResponse getEventBridgeRuleTemplateGroupResponse = (GetEventBridgeRuleTemplateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventBridgeRuleTemplateGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEventBridgeRuleTemplateGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEventBridgeRuleTemplateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEventBridgeRuleTemplateGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$getEventBridgeRuleTemplateGroup$127((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSignalMapResponse getSignalMap(GetSignalMapRequest getSignalMapRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSignalMapResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSignalMapRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, getSignalMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSignalMap");
            GetSignalMapResponse getSignalMapResponse = (GetSignalMapResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSignalMap").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getSignalMapRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSignalMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSignalMapResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$getSignalMap$129((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAlertsResponse listAlerts(ListAlertsRequest listAlertsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAlertsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAlertsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listAlertsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAlerts");
            ListAlertsResponse listAlertsResponse = (ListAlertsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAlerts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAlertsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAlertsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAlertsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listAlerts$131((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListChannelPlacementGroupsResponse listChannelPlacementGroups(ListChannelPlacementGroupsRequest listChannelPlacementGroupsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChannelPlacementGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listChannelPlacementGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listChannelPlacementGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListChannelPlacementGroups");
            ListChannelPlacementGroupsResponse listChannelPlacementGroupsResponse = (ListChannelPlacementGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChannelPlacementGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listChannelPlacementGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListChannelPlacementGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listChannelPlacementGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listChannelPlacementGroups$133((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChannelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listChannelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListChannels");
            ListChannelsResponse listChannelsResponse = (ListChannelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChannels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listChannelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listChannelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listChannels$135((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCloudWatchAlarmTemplateGroupsResponse listCloudWatchAlarmTemplateGroups(ListCloudWatchAlarmTemplateGroupsRequest listCloudWatchAlarmTemplateGroupsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCloudWatchAlarmTemplateGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCloudWatchAlarmTemplateGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listCloudWatchAlarmTemplateGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCloudWatchAlarmTemplateGroups");
            ListCloudWatchAlarmTemplateGroupsResponse listCloudWatchAlarmTemplateGroupsResponse = (ListCloudWatchAlarmTemplateGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCloudWatchAlarmTemplateGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCloudWatchAlarmTemplateGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCloudWatchAlarmTemplateGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCloudWatchAlarmTemplateGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listCloudWatchAlarmTemplateGroups$137((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCloudWatchAlarmTemplatesResponse listCloudWatchAlarmTemplates(ListCloudWatchAlarmTemplatesRequest listCloudWatchAlarmTemplatesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCloudWatchAlarmTemplatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCloudWatchAlarmTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listCloudWatchAlarmTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCloudWatchAlarmTemplates");
            ListCloudWatchAlarmTemplatesResponse listCloudWatchAlarmTemplatesResponse = (ListCloudWatchAlarmTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCloudWatchAlarmTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCloudWatchAlarmTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCloudWatchAlarmTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCloudWatchAlarmTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listCloudWatchAlarmTemplates$139((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClusterAlertsResponse listClusterAlerts(ListClusterAlertsRequest listClusterAlertsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClusterAlertsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listClusterAlertsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listClusterAlertsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClusterAlerts");
            ListClusterAlertsResponse listClusterAlertsResponse = (ListClusterAlertsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClusterAlerts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listClusterAlertsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListClusterAlertsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listClusterAlertsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listClusterAlerts$141((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClustersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listClustersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClusters");
            ListClustersResponse listClustersResponse = (ListClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClusters").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listClusters$143((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventBridgeRuleTemplateGroupsResponse listEventBridgeRuleTemplateGroups(ListEventBridgeRuleTemplateGroupsRequest listEventBridgeRuleTemplateGroupsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventBridgeRuleTemplateGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventBridgeRuleTemplateGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listEventBridgeRuleTemplateGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventBridgeRuleTemplateGroups");
            ListEventBridgeRuleTemplateGroupsResponse listEventBridgeRuleTemplateGroupsResponse = (ListEventBridgeRuleTemplateGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventBridgeRuleTemplateGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEventBridgeRuleTemplateGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEventBridgeRuleTemplateGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventBridgeRuleTemplateGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listEventBridgeRuleTemplateGroups$145((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventBridgeRuleTemplatesResponse listEventBridgeRuleTemplates(ListEventBridgeRuleTemplatesRequest listEventBridgeRuleTemplatesRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventBridgeRuleTemplatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventBridgeRuleTemplatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listEventBridgeRuleTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventBridgeRuleTemplates");
            ListEventBridgeRuleTemplatesResponse listEventBridgeRuleTemplatesResponse = (ListEventBridgeRuleTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventBridgeRuleTemplates").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEventBridgeRuleTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEventBridgeRuleTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventBridgeRuleTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listEventBridgeRuleTemplates$147((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInputDeviceTransfersResponse listInputDeviceTransfers(ListInputDeviceTransfersRequest listInputDeviceTransfersRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInputDeviceTransfersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInputDeviceTransfersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listInputDeviceTransfersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInputDeviceTransfers");
            ListInputDeviceTransfersResponse listInputDeviceTransfersResponse = (ListInputDeviceTransfersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInputDeviceTransfers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listInputDeviceTransfersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListInputDeviceTransfersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInputDeviceTransfersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listInputDeviceTransfers$149((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInputDevicesResponse listInputDevices(ListInputDevicesRequest listInputDevicesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInputDevicesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInputDevicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listInputDevicesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInputDevices");
            ListInputDevicesResponse listInputDevicesResponse = (ListInputDevicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInputDevices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listInputDevicesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListInputDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInputDevicesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listInputDevices$151((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInputSecurityGroupsResponse listInputSecurityGroups(ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInputSecurityGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInputSecurityGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listInputSecurityGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInputSecurityGroups");
            ListInputSecurityGroupsResponse listInputSecurityGroupsResponse = (ListInputSecurityGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInputSecurityGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listInputSecurityGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListInputSecurityGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInputSecurityGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listInputSecurityGroups$153((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInputsResponse listInputs(ListInputsRequest listInputsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInputsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInputsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listInputsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInputs");
            ListInputsResponse listInputsResponse = (ListInputsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInputs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listInputsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListInputsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInputsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listInputs$155((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMultiplexAlertsResponse listMultiplexAlerts(ListMultiplexAlertsRequest listMultiplexAlertsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMultiplexAlertsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMultiplexAlertsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listMultiplexAlertsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMultiplexAlerts");
            ListMultiplexAlertsResponse listMultiplexAlertsResponse = (ListMultiplexAlertsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMultiplexAlerts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMultiplexAlertsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMultiplexAlertsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMultiplexAlertsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listMultiplexAlerts$157((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMultiplexProgramsResponse listMultiplexPrograms(ListMultiplexProgramsRequest listMultiplexProgramsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMultiplexProgramsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMultiplexProgramsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listMultiplexProgramsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMultiplexPrograms");
            ListMultiplexProgramsResponse listMultiplexProgramsResponse = (ListMultiplexProgramsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMultiplexPrograms").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMultiplexProgramsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMultiplexProgramsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMultiplexProgramsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listMultiplexPrograms$159((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMultiplexesResponse listMultiplexes(ListMultiplexesRequest listMultiplexesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMultiplexesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listMultiplexesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listMultiplexesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMultiplexes");
            ListMultiplexesResponse listMultiplexesResponse = (ListMultiplexesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMultiplexes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listMultiplexesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMultiplexesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMultiplexesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listMultiplexes$161((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNetworksResponse listNetworks(ListNetworksRequest listNetworksRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNetworksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listNetworksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listNetworksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNetworks");
            ListNetworksResponse listNetworksResponse = (ListNetworksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNetworks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listNetworksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNetworksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNetworksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listNetworks$163((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListNodesResponse listNodes(ListNodesRequest listNodesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListNodesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listNodesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listNodesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListNodes");
            ListNodesResponse listNodesResponse = (ListNodesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListNodes").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listNodesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListNodesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listNodesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listNodes$165((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOfferingsResponse listOfferings(ListOfferingsRequest listOfferingsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOfferingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listOfferingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOfferings");
            ListOfferingsResponse listOfferingsResponse = (ListOfferingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOfferings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listOfferingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOfferingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOfferingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listOfferings$167((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReservationsResponse listReservations(ListReservationsRequest listReservationsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReservationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReservationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listReservationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReservations");
            ListReservationsResponse listReservationsResponse = (ListReservationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReservations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listReservationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReservationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReservationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listReservations$169((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSdiSourcesResponse listSdiSources(ListSdiSourcesRequest listSdiSourcesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSdiSourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSdiSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listSdiSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSdiSources");
            ListSdiSourcesResponse listSdiSourcesResponse = (ListSdiSourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSdiSources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSdiSourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSdiSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSdiSourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listSdiSources$171((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSignalMapsResponse listSignalMaps(ListSignalMapsRequest listSignalMapsRequest) throws NotFoundException, TooManyRequestsException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSignalMapsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSignalMapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listSignalMapsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSignalMaps");
            ListSignalMapsResponse listSignalMapsResponse = (ListSignalMapsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSignalMaps").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSignalMapsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSignalMapsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSignalMapsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listSignalMaps$173((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws NotFoundException, BadRequestException, InternalServerErrorException, ForbiddenException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listTagsForResource$175((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVersionsResponse listVersions(ListVersionsRequest listVersionsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, listVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVersions");
            ListVersionsResponse listVersionsResponse = (ListVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listVersionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVersionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$listVersions$177((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PurchaseOfferingResponse purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PurchaseOfferingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)purchaseOfferingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, purchaseOfferingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PurchaseOffering");
            PurchaseOfferingResponse purchaseOfferingResponse = (PurchaseOfferingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseOffering").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)purchaseOfferingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PurchaseOfferingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return purchaseOfferingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$purchaseOffering$179((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RebootInputDeviceResponse rebootInputDevice(RebootInputDeviceRequest rebootInputDeviceRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RebootInputDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rebootInputDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, rebootInputDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RebootInputDevice");
            RebootInputDeviceResponse rebootInputDeviceResponse = (RebootInputDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RebootInputDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rebootInputDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RebootInputDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rebootInputDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$rebootInputDevice$181((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectInputDeviceTransferResponse rejectInputDeviceTransfer(RejectInputDeviceTransferRequest rejectInputDeviceTransferRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectInputDeviceTransferResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectInputDeviceTransferRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, rejectInputDeviceTransferRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectInputDeviceTransfer");
            RejectInputDeviceTransferResponse rejectInputDeviceTransferResponse = (RejectInputDeviceTransferResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectInputDeviceTransfer").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rejectInputDeviceTransferRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectInputDeviceTransferRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectInputDeviceTransferResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$rejectInputDeviceTransfer$183((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestartChannelPipelinesResponse restartChannelPipelines(RestartChannelPipelinesRequest restartChannelPipelinesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestartChannelPipelinesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restartChannelPipelinesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, restartChannelPipelinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestartChannelPipelines");
            RestartChannelPipelinesResponse restartChannelPipelinesResponse = (RestartChannelPipelinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestartChannelPipelines").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)restartChannelPipelinesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestartChannelPipelinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restartChannelPipelinesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$restartChannelPipelines$185((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartChannelResponse startChannel(StartChannelRequest startChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, startChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartChannel");
            StartChannelResponse startChannelResponse = (StartChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$startChannel$187((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartDeleteMonitorDeploymentResponse startDeleteMonitorDeployment(StartDeleteMonitorDeploymentRequest startDeleteMonitorDeploymentRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDeleteMonitorDeploymentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDeleteMonitorDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, startDeleteMonitorDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDeleteMonitorDeployment");
            StartDeleteMonitorDeploymentResponse startDeleteMonitorDeploymentResponse = (StartDeleteMonitorDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDeleteMonitorDeployment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startDeleteMonitorDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartDeleteMonitorDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startDeleteMonitorDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$startDeleteMonitorDeployment$189((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartInputDeviceResponse startInputDevice(StartInputDeviceRequest startInputDeviceRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartInputDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startInputDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, startInputDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartInputDevice");
            StartInputDeviceResponse startInputDeviceResponse = (StartInputDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartInputDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startInputDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartInputDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startInputDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$startInputDevice$191((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartInputDeviceMaintenanceWindowResponse startInputDeviceMaintenanceWindow(StartInputDeviceMaintenanceWindowRequest startInputDeviceMaintenanceWindowRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartInputDeviceMaintenanceWindowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startInputDeviceMaintenanceWindowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, startInputDeviceMaintenanceWindowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartInputDeviceMaintenanceWindow");
            StartInputDeviceMaintenanceWindowResponse startInputDeviceMaintenanceWindowResponse = (StartInputDeviceMaintenanceWindowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartInputDeviceMaintenanceWindow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startInputDeviceMaintenanceWindowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartInputDeviceMaintenanceWindowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startInputDeviceMaintenanceWindowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$startInputDeviceMaintenanceWindow$193((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMonitorDeploymentResponse startMonitorDeployment(StartMonitorDeploymentRequest startMonitorDeploymentRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMonitorDeploymentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startMonitorDeploymentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, startMonitorDeploymentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMonitorDeployment");
            StartMonitorDeploymentResponse startMonitorDeploymentResponse = (StartMonitorDeploymentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMonitorDeployment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startMonitorDeploymentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartMonitorDeploymentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMonitorDeploymentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$startMonitorDeployment$195((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartMultiplexResponse startMultiplex(StartMultiplexRequest startMultiplexRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartMultiplexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startMultiplexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, startMultiplexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMultiplex");
            StartMultiplexResponse startMultiplexResponse = (StartMultiplexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMultiplex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startMultiplexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartMultiplexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startMultiplexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$startMultiplex$197((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartUpdateSignalMapResponse startUpdateSignalMap(StartUpdateSignalMapRequest startUpdateSignalMapRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartUpdateSignalMapResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startUpdateSignalMapRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, startUpdateSignalMapRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartUpdateSignalMap");
            StartUpdateSignalMapResponse startUpdateSignalMapResponse = (StartUpdateSignalMapResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartUpdateSignalMap").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startUpdateSignalMapRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartUpdateSignalMapRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startUpdateSignalMapResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$startUpdateSignalMap$199((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopChannelResponse stopChannel(StopChannelRequest stopChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, stopChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopChannel");
            StopChannelResponse stopChannelResponse = (StopChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$stopChannel$201((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopInputDeviceResponse stopInputDevice(StopInputDeviceRequest stopInputDeviceRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopInputDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopInputDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, stopInputDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopInputDevice");
            StopInputDeviceResponse stopInputDeviceResponse = (StopInputDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopInputDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopInputDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopInputDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopInputDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$stopInputDevice$203((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopMultiplexResponse stopMultiplex(StopMultiplexRequest stopMultiplexRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopMultiplexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopMultiplexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, stopMultiplexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopMultiplex");
            StopMultiplexResponse stopMultiplexResponse = (StopMultiplexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopMultiplex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopMultiplexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopMultiplexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopMultiplexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$stopMultiplex$205((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferInputDeviceResponse transferInputDevice(TransferInputDeviceRequest transferInputDeviceRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TransferInputDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)transferInputDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, transferInputDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TransferInputDevice");
            TransferInputDeviceResponse transferInputDeviceResponse = (TransferInputDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TransferInputDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)transferInputDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TransferInputDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return transferInputDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$transferInputDevice$207((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAccountConfigurationResponse updateAccountConfiguration(UpdateAccountConfigurationRequest updateAccountConfigurationRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAccountConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAccountConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateAccountConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccountConfiguration");
            UpdateAccountConfigurationResponse updateAccountConfigurationResponse = (UpdateAccountConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccountConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAccountConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAccountConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAccountConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateAccountConfiguration$209((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateChannelResponse updateChannel(UpdateChannelRequest updateChannelRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateChannel");
            UpdateChannelResponse updateChannelResponse = (UpdateChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateChannel$211((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateChannelClassResponse updateChannelClass(UpdateChannelClassRequest updateChannelClassRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateChannelClassResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateChannelClassRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateChannelClassRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateChannelClass");
            UpdateChannelClassResponse updateChannelClassResponse = (UpdateChannelClassResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateChannelClass").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateChannelClassRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateChannelClassRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateChannelClassResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateChannelClass$213((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateChannelPlacementGroupResponse updateChannelPlacementGroup(UpdateChannelPlacementGroupRequest updateChannelPlacementGroupRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateChannelPlacementGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateChannelPlacementGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateChannelPlacementGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateChannelPlacementGroup");
            UpdateChannelPlacementGroupResponse updateChannelPlacementGroupResponse = (UpdateChannelPlacementGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateChannelPlacementGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateChannelPlacementGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateChannelPlacementGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateChannelPlacementGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateChannelPlacementGroup$215((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCloudWatchAlarmTemplateResponse updateCloudWatchAlarmTemplate(UpdateCloudWatchAlarmTemplateRequest updateCloudWatchAlarmTemplateRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCloudWatchAlarmTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCloudWatchAlarmTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateCloudWatchAlarmTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCloudWatchAlarmTemplate");
            UpdateCloudWatchAlarmTemplateResponse updateCloudWatchAlarmTemplateResponse = (UpdateCloudWatchAlarmTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCloudWatchAlarmTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateCloudWatchAlarmTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCloudWatchAlarmTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCloudWatchAlarmTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateCloudWatchAlarmTemplate$217((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCloudWatchAlarmTemplateGroupResponse updateCloudWatchAlarmTemplateGroup(UpdateCloudWatchAlarmTemplateGroupRequest updateCloudWatchAlarmTemplateGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCloudWatchAlarmTemplateGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCloudWatchAlarmTemplateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateCloudWatchAlarmTemplateGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCloudWatchAlarmTemplateGroup");
            UpdateCloudWatchAlarmTemplateGroupResponse updateCloudWatchAlarmTemplateGroupResponse = (UpdateCloudWatchAlarmTemplateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCloudWatchAlarmTemplateGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateCloudWatchAlarmTemplateGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCloudWatchAlarmTemplateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCloudWatchAlarmTemplateGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateCloudWatchAlarmTemplateGroup$219((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateClusterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCluster");
            UpdateClusterResponse updateClusterResponse = (UpdateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCluster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateCluster$221((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEventBridgeRuleTemplateResponse updateEventBridgeRuleTemplate(UpdateEventBridgeRuleTemplateRequest updateEventBridgeRuleTemplateRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEventBridgeRuleTemplateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEventBridgeRuleTemplateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateEventBridgeRuleTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEventBridgeRuleTemplate");
            UpdateEventBridgeRuleTemplateResponse updateEventBridgeRuleTemplateResponse = (UpdateEventBridgeRuleTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEventBridgeRuleTemplate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateEventBridgeRuleTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEventBridgeRuleTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEventBridgeRuleTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateEventBridgeRuleTemplate$223((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEventBridgeRuleTemplateGroupResponse updateEventBridgeRuleTemplateGroup(UpdateEventBridgeRuleTemplateGroupRequest updateEventBridgeRuleTemplateGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateEventBridgeRuleTemplateGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateEventBridgeRuleTemplateGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateEventBridgeRuleTemplateGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateEventBridgeRuleTemplateGroup");
            UpdateEventBridgeRuleTemplateGroupResponse updateEventBridgeRuleTemplateGroupResponse = (UpdateEventBridgeRuleTemplateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateEventBridgeRuleTemplateGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateEventBridgeRuleTemplateGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateEventBridgeRuleTemplateGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateEventBridgeRuleTemplateGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateEventBridgeRuleTemplateGroup$225((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateInputResponse updateInput(UpdateInputRequest updateInputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInputResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateInput");
            UpdateInputResponse updateInputResponse = (UpdateInputResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateInputRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateInputResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateInput$227((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateInputDeviceResponse updateInputDevice(UpdateInputDeviceRequest updateInputDeviceRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInputDeviceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateInputDeviceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateInputDeviceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateInputDevice");
            UpdateInputDeviceResponse updateInputDeviceResponse = (UpdateInputDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInputDevice").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateInputDeviceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateInputDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateInputDeviceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateInputDevice$229((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateInputSecurityGroupResponse updateInputSecurityGroup(UpdateInputSecurityGroupRequest updateInputSecurityGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInputSecurityGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateInputSecurityGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateInputSecurityGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateInputSecurityGroup");
            UpdateInputSecurityGroupResponse updateInputSecurityGroupResponse = (UpdateInputSecurityGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInputSecurityGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateInputSecurityGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateInputSecurityGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateInputSecurityGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateInputSecurityGroup$231((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMultiplexResponse updateMultiplex(UpdateMultiplexRequest updateMultiplexRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMultiplexResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateMultiplexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateMultiplexRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMultiplex");
            UpdateMultiplexResponse updateMultiplexResponse = (UpdateMultiplexResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMultiplex").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateMultiplexRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMultiplexRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMultiplexResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateMultiplex$233((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateMultiplexProgramResponse updateMultiplexProgram(UpdateMultiplexProgramRequest updateMultiplexProgramRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMultiplexProgramResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateMultiplexProgramRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateMultiplexProgramRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMultiplexProgram");
            UpdateMultiplexProgramResponse updateMultiplexProgramResponse = (UpdateMultiplexProgramResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMultiplexProgram").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateMultiplexProgramRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateMultiplexProgramRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateMultiplexProgramResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateMultiplexProgram$235((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNetworkResponse updateNetwork(UpdateNetworkRequest updateNetworkRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNetworkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateNetworkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateNetworkRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNetwork");
            UpdateNetworkResponse updateNetworkResponse = (UpdateNetworkResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNetwork").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateNetworkRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNetworkRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNetworkResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateNetwork$237((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNodeResponse updateNode(UpdateNodeRequest updateNodeRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateNodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateNodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNode");
            UpdateNodeResponse updateNodeResponse = (UpdateNodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateNodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateNode$239((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateNodeStateResponse updateNodeState(UpdateNodeStateRequest updateNodeStateRequest) throws BadRequestException, UnprocessableEntityException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNodeStateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateNodeStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateNodeStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNodeState");
            UpdateNodeStateResponse updateNodeStateResponse = (UpdateNodeStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNodeState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateNodeStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateNodeStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateNodeStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateNodeState$241((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateReservationResponse updateReservation(UpdateReservationRequest updateReservationRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateReservationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateReservationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReservation");
            UpdateReservationResponse updateReservationResponse = (UpdateReservationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReservation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateReservationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateReservationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateReservationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateReservation$243((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSdiSourceResponse updateSdiSource(UpdateSdiSourceRequest updateSdiSourceRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, AwsServiceException, SdkClientException, MediaLiveException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSdiSourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ForbiddenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "BadGatewayException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadGatewayException").httpStatusCode(Integer.valueOf(502)).exceptionBuilderSupplier(BadGatewayException::builder).build());
                }
                case "GatewayTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GatewayTimeoutException").httpStatusCode(Integer.valueOf(504)).exceptionBuilderSupplier(GatewayTimeoutException::builder).build());
                }
                case "NotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                }
                case "UnprocessableEntityException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnprocessableEntityException").httpStatusCode(Integer.valueOf(422)).exceptionBuilderSupplier(UnprocessableEntityException::builder).build());
                }
                case "TooManyRequestsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                }
                case "BadRequestException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                }
                case "InternalServerErrorException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSdiSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaLiveClient.resolveMetricPublishers(clientConfiguration, updateSdiSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaLive");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSdiSource");
            UpdateSdiSourceResponse updateSdiSourceResponse = (UpdateSdiSourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSdiSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateSdiSourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSdiSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSdiSourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMediaLiveClient.lambda$updateSdiSource$245((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public MediaLiveWaiter waiter() {
        return MediaLiveWaiter.builder().client(this).build();
    }

    public final String serviceName() {
        return "medialive";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        MediaLiveServiceClientConfigurationBuilder serviceConfigBuilder = new MediaLiveServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MediaLiveException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final MediaLiveServiceClientConfiguration serviceClientConfiguration() {
        return new MediaLiveServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateSdiSource$245(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateReservation$243(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNodeState$241(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNode$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNetwork$237(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMultiplexProgram$235(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMultiplex$233(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateInputSecurityGroup$231(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateInputDevice$229(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateInput$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEventBridgeRuleTemplateGroup$225(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateEventBridgeRuleTemplate$223(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCluster$221(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCloudWatchAlarmTemplateGroup$219(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCloudWatchAlarmTemplate$217(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateChannelPlacementGroup$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateChannelClass$213(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateChannel$211(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccountConfiguration$209(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$transferInputDevice$207(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopMultiplex$205(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopInputDevice$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopChannel$201(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startUpdateSignalMap$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMultiplex$197(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMonitorDeployment$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startInputDeviceMaintenanceWindow$193(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startInputDevice$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDeleteMonitorDeployment$189(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startChannel$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restartChannelPipelines$185(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectInputDeviceTransfer$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rebootInputDevice$181(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$purchaseOffering$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVersions$177(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSignalMaps$173(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSdiSources$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReservations$169(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOfferings$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNodes$165(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listNetworks$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMultiplexes$161(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMultiplexPrograms$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMultiplexAlerts$157(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInputs$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInputSecurityGroups$153(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInputDevices$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInputDeviceTransfers$149(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventBridgeRuleTemplates$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEventBridgeRuleTemplateGroups$145(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClusters$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClusterAlerts$141(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCloudWatchAlarmTemplates$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCloudWatchAlarmTemplateGroups$137(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listChannels$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listChannelPlacementGroups$133(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAlerts$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSignalMap$129(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEventBridgeRuleTemplateGroup$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEventBridgeRuleTemplate$125(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCloudWatchAlarmTemplateGroup$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCloudWatchAlarmTemplate$121(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeThumbnails$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSdiSource$117(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSchedule$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservation$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOffering$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNode$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNetwork$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMultiplexProgram$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMultiplex$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInputSecurityGroup$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInputDeviceThumbnail$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInputDevice$97(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInput$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCluster$93(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeChannelPlacementGroup$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeChannel$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountConfiguration$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTags$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSignalMap$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSdiSource$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSchedule$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReservation$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNode$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNetwork$73(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMultiplexProgram$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMultiplex$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInputSecurityGroup$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInput$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEventBridgeRuleTemplateGroup$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEventBridgeRuleTemplate$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCloudWatchAlarmTemplateGroup$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCloudWatchAlarmTemplate$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteChannelPlacementGroup$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteChannel$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTags$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSignalMap$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSdiSource$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createPartnerInput$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNodeRegistrationScript$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNode$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNetwork$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMultiplexProgram$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMultiplex$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInputSecurityGroup$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInput$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEventBridgeRuleTemplateGroup$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createEventBridgeRuleTemplate$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCloudWatchAlarmTemplateGroup$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCloudWatchAlarmTemplate$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createChannelPlacementGroup$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createChannel$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$claimDevice$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelInputDeviceTransfer$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdateSchedule$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchStop$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchStart$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDelete$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptInputDeviceTransfer$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

