/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.MediaPackageV2GroupSettings;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaPackageGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaPackageGroupSettings> {
    private static final SdkField<OutputLocationRef> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(MediaPackageGroupSettings.getter(MediaPackageGroupSettings::destination)).setter(MediaPackageGroupSettings.setter(Builder::destination)).constructor(OutputLocationRef::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<MediaPackageV2GroupSettings> MEDIAPACKAGE_V2_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediapackageV2GroupSettings").getter(MediaPackageGroupSettings.getter(MediaPackageGroupSettings::mediapackageV2GroupSettings)).setter(MediaPackageGroupSettings.setter(Builder::mediapackageV2GroupSettings)).constructor(MediaPackageV2GroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediapackageV2GroupSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_FIELD, MEDIAPACKAGE_V2_GROUP_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaPackageGroupSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final OutputLocationRef destination;
    private final MediaPackageV2GroupSettings mediapackageV2GroupSettings;

    private MediaPackageGroupSettings(BuilderImpl builder) {
        this.destination = builder.destination;
        this.mediapackageV2GroupSettings = builder.mediapackageV2GroupSettings;
    }

    public final OutputLocationRef destination() {
        return this.destination;
    }

    public final MediaPackageV2GroupSettings mediapackageV2GroupSettings() {
        return this.mediapackageV2GroupSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediapackageV2GroupSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaPackageGroupSettings)) {
            return false;
        }
        MediaPackageGroupSettings other = (MediaPackageGroupSettings)obj;
        return Objects.equals(this.destination(), other.destination()) && Objects.equals(this.mediapackageV2GroupSettings(), other.mediapackageV2GroupSettings());
    }

    public final String toString() {
        return ToString.builder((String)"MediaPackageGroupSettings").add("Destination", (Object)this.destination()).add("MediapackageV2GroupSettings", (Object)this.mediapackageV2GroupSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "MediapackageV2GroupSettings": {
                return Optional.ofNullable(clazz.cast(this.mediapackageV2GroupSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("destination", DESTINATION_FIELD);
        map.put("mediapackageV2GroupSettings", MEDIAPACKAGE_V2_GROUP_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaPackageGroupSettings, T> g) {
        return obj -> g.apply((MediaPackageGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OutputLocationRef destination;
        private MediaPackageV2GroupSettings mediapackageV2GroupSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaPackageGroupSettings model) {
            this.destination(model.destination);
            this.mediapackageV2GroupSettings(model.mediapackageV2GroupSettings);
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final MediaPackageV2GroupSettings.Builder getMediapackageV2GroupSettings() {
            return this.mediapackageV2GroupSettings != null ? this.mediapackageV2GroupSettings.toBuilder() : null;
        }

        public final void setMediapackageV2GroupSettings(MediaPackageV2GroupSettings.BuilderImpl mediapackageV2GroupSettings) {
            this.mediapackageV2GroupSettings = mediapackageV2GroupSettings != null ? mediapackageV2GroupSettings.build() : null;
        }

        @Override
        public final Builder mediapackageV2GroupSettings(MediaPackageV2GroupSettings mediapackageV2GroupSettings) {
            this.mediapackageV2GroupSettings = mediapackageV2GroupSettings;
            return this;
        }

        public MediaPackageGroupSettings build() {
            return new MediaPackageGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaPackageGroupSettings> {
        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().applyMutation(destination)).build());
        }

        public Builder mediapackageV2GroupSettings(MediaPackageV2GroupSettings var1);

        default public Builder mediapackageV2GroupSettings(Consumer<MediaPackageV2GroupSettings.Builder> mediapackageV2GroupSettings) {
            return this.mediapackageV2GroupSettings((MediaPackageV2GroupSettings)((MediaPackageV2GroupSettings.Builder)MediaPackageV2GroupSettings.builder().applyMutation(mediapackageV2GroupSettings)).build());
        }
    }
}

