/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.HlsAutoSelect;
import software.amazon.awssdk.services.medialive.model.HlsDefault;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaPackageV2DestinationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaPackageV2DestinationSettings> {
    private static final SdkField<String> AUDIO_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioGroupId").getter(MediaPackageV2DestinationSettings.getter(MediaPackageV2DestinationSettings::audioGroupId)).setter(MediaPackageV2DestinationSettings.setter(Builder::audioGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioGroupId").build()}).build();
    private static final SdkField<String> AUDIO_RENDITION_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioRenditionSets").getter(MediaPackageV2DestinationSettings.getter(MediaPackageV2DestinationSettings::audioRenditionSets)).setter(MediaPackageV2DestinationSettings.setter(Builder::audioRenditionSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioRenditionSets").build()}).build();
    private static final SdkField<String> HLS_AUTO_SELECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HlsAutoSelect").getter(MediaPackageV2DestinationSettings.getter(MediaPackageV2DestinationSettings::hlsAutoSelectAsString)).setter(MediaPackageV2DestinationSettings.setter(Builder::hlsAutoSelect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsAutoSelect").build()}).build();
    private static final SdkField<String> HLS_DEFAULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HlsDefault").getter(MediaPackageV2DestinationSettings.getter(MediaPackageV2DestinationSettings::hlsDefaultAsString)).setter(MediaPackageV2DestinationSettings.setter(Builder::hlsDefault)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsDefault").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_GROUP_ID_FIELD, AUDIO_RENDITION_SETS_FIELD, HLS_AUTO_SELECT_FIELD, HLS_DEFAULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaPackageV2DestinationSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String audioGroupId;
    private final String audioRenditionSets;
    private final String hlsAutoSelect;
    private final String hlsDefault;

    private MediaPackageV2DestinationSettings(BuilderImpl builder) {
        this.audioGroupId = builder.audioGroupId;
        this.audioRenditionSets = builder.audioRenditionSets;
        this.hlsAutoSelect = builder.hlsAutoSelect;
        this.hlsDefault = builder.hlsDefault;
    }

    public final String audioGroupId() {
        return this.audioGroupId;
    }

    public final String audioRenditionSets() {
        return this.audioRenditionSets;
    }

    public final HlsAutoSelect hlsAutoSelect() {
        return HlsAutoSelect.fromValue(this.hlsAutoSelect);
    }

    public final String hlsAutoSelectAsString() {
        return this.hlsAutoSelect;
    }

    public final HlsDefault hlsDefault() {
        return HlsDefault.fromValue(this.hlsDefault);
    }

    public final String hlsDefaultAsString() {
        return this.hlsDefault;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioRenditionSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsAutoSelectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsDefaultAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaPackageV2DestinationSettings)) {
            return false;
        }
        MediaPackageV2DestinationSettings other = (MediaPackageV2DestinationSettings)obj;
        return Objects.equals(this.audioGroupId(), other.audioGroupId()) && Objects.equals(this.audioRenditionSets(), other.audioRenditionSets()) && Objects.equals(this.hlsAutoSelectAsString(), other.hlsAutoSelectAsString()) && Objects.equals(this.hlsDefaultAsString(), other.hlsDefaultAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MediaPackageV2DestinationSettings").add("AudioGroupId", (Object)this.audioGroupId()).add("AudioRenditionSets", (Object)this.audioRenditionSets()).add("HlsAutoSelect", (Object)this.hlsAutoSelectAsString()).add("HlsDefault", (Object)this.hlsDefaultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioGroupId": {
                return Optional.ofNullable(clazz.cast(this.audioGroupId()));
            }
            case "AudioRenditionSets": {
                return Optional.ofNullable(clazz.cast(this.audioRenditionSets()));
            }
            case "HlsAutoSelect": {
                return Optional.ofNullable(clazz.cast(this.hlsAutoSelectAsString()));
            }
            case "HlsDefault": {
                return Optional.ofNullable(clazz.cast(this.hlsDefaultAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("audioGroupId", AUDIO_GROUP_ID_FIELD);
        map.put("audioRenditionSets", AUDIO_RENDITION_SETS_FIELD);
        map.put("hlsAutoSelect", HLS_AUTO_SELECT_FIELD);
        map.put("hlsDefault", HLS_DEFAULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaPackageV2DestinationSettings, T> g) {
        return obj -> g.apply((MediaPackageV2DestinationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioGroupId;
        private String audioRenditionSets;
        private String hlsAutoSelect;
        private String hlsDefault;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaPackageV2DestinationSettings model) {
            this.audioGroupId(model.audioGroupId);
            this.audioRenditionSets(model.audioRenditionSets);
            this.hlsAutoSelect(model.hlsAutoSelect);
            this.hlsDefault(model.hlsDefault);
        }

        public final String getAudioGroupId() {
            return this.audioGroupId;
        }

        public final void setAudioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
        }

        @Override
        public final Builder audioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
            return this;
        }

        public final String getAudioRenditionSets() {
            return this.audioRenditionSets;
        }

        public final void setAudioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
        }

        @Override
        public final Builder audioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
            return this;
        }

        public final String getHlsAutoSelect() {
            return this.hlsAutoSelect;
        }

        public final void setHlsAutoSelect(String hlsAutoSelect) {
            this.hlsAutoSelect = hlsAutoSelect;
        }

        @Override
        public final Builder hlsAutoSelect(String hlsAutoSelect) {
            this.hlsAutoSelect = hlsAutoSelect;
            return this;
        }

        @Override
        public final Builder hlsAutoSelect(HlsAutoSelect hlsAutoSelect) {
            this.hlsAutoSelect(hlsAutoSelect == null ? null : hlsAutoSelect.toString());
            return this;
        }

        public final String getHlsDefault() {
            return this.hlsDefault;
        }

        public final void setHlsDefault(String hlsDefault) {
            this.hlsDefault = hlsDefault;
        }

        @Override
        public final Builder hlsDefault(String hlsDefault) {
            this.hlsDefault = hlsDefault;
            return this;
        }

        @Override
        public final Builder hlsDefault(HlsDefault hlsDefault) {
            this.hlsDefault(hlsDefault == null ? null : hlsDefault.toString());
            return this;
        }

        public MediaPackageV2DestinationSettings build() {
            return new MediaPackageV2DestinationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaPackageV2DestinationSettings> {
        public Builder audioGroupId(String var1);

        public Builder audioRenditionSets(String var1);

        public Builder hlsAutoSelect(String var1);

        public Builder hlsAutoSelect(HlsAutoSelect var1);

        public Builder hlsDefault(String var1);

        public Builder hlsDefault(HlsDefault var1);
    }
}

