/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.ChannelAlert;
import software.amazon.awssdk.services.medialive.model.ListAlertsRequest;
import software.amazon.awssdk.services.medialive.model.ListAlertsResponse;

public class ListAlertsPublisher
implements SdkPublisher<ListAlertsResponse> {
    private final MediaLiveAsyncClient client;
    private final ListAlertsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAlertsPublisher(MediaLiveAsyncClient client, ListAlertsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAlertsPublisher(MediaLiveAsyncClient client, ListAlertsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAlertsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAlertsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ChannelAlert> alerts() {
        Function<ListAlertsResponse, Iterator> getIterator = response -> {
            if (response != null && response.alerts() != null) {
                return response.alerts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAlertsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAlertsResponseFetcher
    implements AsyncPageFetcher<ListAlertsResponse> {
        private ListAlertsResponseFetcher() {
        }

        public boolean hasNextPage(ListAlertsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAlertsResponse> nextPage(ListAlertsResponse previousPage) {
            if (previousPage == null) {
                return ListAlertsPublisher.this.client.listAlerts(ListAlertsPublisher.this.firstRequest);
            }
            return ListAlertsPublisher.this.client.listAlerts((ListAlertsRequest)((Object)ListAlertsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

