/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.mediapackage.model.ListOfOriginEndpointCopier;
import software.amazon.awssdk.services.mediapackage.model.MediaPackageResponse;
import software.amazon.awssdk.services.mediapackage.model.OriginEndpoint;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListOriginEndpointsResponse
extends MediaPackageResponse
implements ToCopyableBuilder<Builder, ListOriginEndpointsResponse> {
    private final String nextToken;
    private final List<OriginEndpoint> originEndpoints;

    private ListOriginEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.originEndpoints = builder.originEndpoints;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<OriginEndpoint> originEndpoints() {
        return this.originEndpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.originEndpoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOriginEndpointsResponse)) {
            return false;
        }
        ListOriginEndpointsResponse other = (ListOriginEndpointsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.originEndpoints(), other.originEndpoints());
    }

    public String toString() {
        return ToString.builder((String)"ListOriginEndpointsResponse").add("NextToken", (Object)this.nextToken()).add("OriginEndpoints", this.originEndpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "OriginEndpoints": {
                return Optional.of(clazz.cast(this.originEndpoints()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaPackageResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<OriginEndpoint> originEndpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOriginEndpointsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.originEndpoints(model.originEndpoints);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<OriginEndpoint.Builder> getOriginEndpoints() {
            return this.originEndpoints != null ? (Collection)this.originEndpoints.stream().map(OriginEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder originEndpoints(Collection<OriginEndpoint> originEndpoints) {
            this.originEndpoints = ListOfOriginEndpointCopier.copy(originEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originEndpoints(OriginEndpoint ... originEndpoints) {
            this.originEndpoints(Arrays.asList(originEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originEndpoints(Consumer<OriginEndpoint.Builder> ... originEndpoints) {
            this.originEndpoints(Stream.of(originEndpoints).map(c -> (OriginEndpoint)((OriginEndpoint.Builder)OriginEndpoint.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOriginEndpoints(Collection<OriginEndpoint.BuilderImpl> originEndpoints) {
            this.originEndpoints = ListOfOriginEndpointCopier.copyFromBuilder(originEndpoints);
        }

        @Override
        public ListOriginEndpointsResponse build() {
            return new ListOriginEndpointsResponse(this);
        }
    }

    public static interface Builder
    extends MediaPackageResponse.Builder,
    CopyableBuilder<Builder, ListOriginEndpointsResponse> {
        public Builder nextToken(String var1);

        public Builder originEndpoints(Collection<OriginEndpoint> var1);

        public Builder originEndpoints(OriginEndpoint ... var1);

        public Builder originEndpoints(Consumer<OriginEndpoint.Builder> ... var1);
    }
}

