/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.MssEncryption;
import software.amazon.awssdk.services.mediapackage.model.StreamSelection;
import software.amazon.awssdk.services.mediapackage.transform.MssPackageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MssPackage
implements StructuredPojo,
ToCopyableBuilder<Builder, MssPackage> {
    private final MssEncryption encryption;
    private final Integer manifestWindowSeconds;
    private final Integer segmentDurationSeconds;
    private final StreamSelection streamSelection;

    private MssPackage(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.streamSelection = builder.streamSelection;
    }

    public MssEncryption encryption() {
        return this.encryption;
    }

    public Integer manifestWindowSeconds() {
        return this.manifestWindowSeconds;
    }

    public Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public StreamSelection streamSelection() {
        return this.streamSelection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSelection());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MssPackage)) {
            return false;
        }
        MssPackage other = (MssPackage)obj;
        return Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.manifestWindowSeconds(), other.manifestWindowSeconds()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds()) && Objects.equals(this.streamSelection(), other.streamSelection());
    }

    public String toString() {
        return ToString.builder((String)"MssPackage").add("Encryption", (Object)this.encryption()).add("ManifestWindowSeconds", (Object)this.manifestWindowSeconds()).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).add("StreamSelection", (Object)this.streamSelection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encryption": {
                return Optional.of(clazz.cast(this.encryption()));
            }
            case "ManifestWindowSeconds": {
                return Optional.of(clazz.cast(this.manifestWindowSeconds()));
            }
            case "SegmentDurationSeconds": {
                return Optional.of(clazz.cast(this.segmentDurationSeconds()));
            }
            case "StreamSelection": {
                return Optional.of(clazz.cast(this.streamSelection()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MssPackageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private MssEncryption encryption;
        private Integer manifestWindowSeconds;
        private Integer segmentDurationSeconds;
        private StreamSelection streamSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(MssPackage model) {
            this.encryption(model.encryption);
            this.manifestWindowSeconds(model.manifestWindowSeconds);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
            this.streamSelection(model.streamSelection);
        }

        public final MssEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(MssEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(MssEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getManifestWindowSeconds() {
            return this.manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return this.streamSelection != null ? this.streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        public MssPackage build() {
            return new MssPackage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MssPackage> {
        public Builder encryption(MssEncryption var1);

        default public Builder encryption(Consumer<MssEncryption.Builder> encryption) {
            return this.encryption((MssEncryption)((MssEncryption.Builder)MssEncryption.builder().apply(encryption)).build());
        }

        public Builder manifestWindowSeconds(Integer var1);

        public Builder segmentDurationSeconds(Integer var1);

        public Builder streamSelection(StreamSelection var1);

        default public Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return this.streamSelection((StreamSelection)((StreamSelection.Builder)StreamSelection.builder().apply(streamSelection)).build());
        }
    }
}

