/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.mediapackage.MediaPackageAsyncClient;
import software.amazon.awssdk.services.mediapackage.model.Channel;
import software.amazon.awssdk.services.mediapackage.model.ListChannelsRequest;
import software.amazon.awssdk.services.mediapackage.model.ListChannelsResponse;

public class ListChannelsPublisher
implements SdkPublisher<ListChannelsResponse> {
    private final MediaPackageAsyncClient client;
    private final ListChannelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChannelsPublisher(MediaPackageAsyncClient client, ListChannelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChannelsPublisher(MediaPackageAsyncClient client, ListChannelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChannelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChannelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Channel> channels() {
        Function<ListChannelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.channels() != null) {
                return response.channels().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListChannelsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListChannelsPublisher resume(ListChannelsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListChannelsPublisher(this.client, (ListChannelsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListChannelsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListChannelsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListChannelsResponseFetcher
    implements AsyncPageFetcher<ListChannelsResponse> {
        private ListChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListChannelsResponse> nextPage(ListChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelsPublisher.this.client.listChannels(ListChannelsPublisher.this.firstRequest);
            }
            return ListChannelsPublisher.this.client.listChannels((ListChannelsRequest)((Object)ListChannelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

