/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.mediapackage.MediaPackageClient;
import software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsRequest;
import software.amazon.awssdk.services.mediapackage.model.ListOriginEndpointsResponse;
import software.amazon.awssdk.services.mediapackage.model.OriginEndpoint;

public class ListOriginEndpointsIterable
implements SdkIterable<ListOriginEndpointsResponse> {
    private final MediaPackageClient client;
    private final ListOriginEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOriginEndpointsIterable(MediaPackageClient client, ListOriginEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListOriginEndpointsResponseFetcher();
    }

    public Iterator<ListOriginEndpointsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<OriginEndpoint> originEndpoints() {
        Function<ListOriginEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.originEndpoints() != null) {
                return response.originEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListOriginEndpointsIterable resume(ListOriginEndpointsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListOriginEndpointsIterable(this.client, (ListOriginEndpointsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListOriginEndpointsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListOriginEndpointsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListOriginEndpointsResponseFetcher
    implements SyncPageFetcher<ListOriginEndpointsResponse> {
        private ListOriginEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListOriginEndpointsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListOriginEndpointsResponse nextPage(ListOriginEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListOriginEndpointsIterable.this.client.listOriginEndpoints(ListOriginEndpointsIterable.this.firstRequest);
            }
            return ListOriginEndpointsIterable.this.client.listOriginEndpoints((ListOriginEndpointsRequest)((Object)ListOriginEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

