/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediapackage.model.HlsPackage;
import software.amazon.awssdk.services.mediapackage.transform.HlsEncryptionUnmarshaller;
import software.amazon.awssdk.services.mediapackage.transform.StreamSelectionUnmarshaller;

public class HlsPackageUnmarshaller
implements Unmarshaller<HlsPackage, JsonUnmarshallerContext> {
    private static final HlsPackageUnmarshaller INSTANCE = new HlsPackageUnmarshaller();

    public HlsPackage unmarshall(JsonUnmarshallerContext context) throws Exception {
        HlsPackage.Builder hlsPackageBuilder = HlsPackage.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("adMarkers", targetDepth)) {
                    context.nextToken();
                    hlsPackageBuilder.adMarkers((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("encryption", targetDepth)) {
                    context.nextToken();
                    hlsPackageBuilder.encryption(HlsEncryptionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("includeIframeOnlyStream", targetDepth)) {
                    context.nextToken();
                    hlsPackageBuilder.includeIframeOnlyStream((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("playlistType", targetDepth)) {
                    context.nextToken();
                    hlsPackageBuilder.playlistType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("playlistWindowSeconds", targetDepth)) {
                    context.nextToken();
                    hlsPackageBuilder.playlistWindowSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("programDateTimeIntervalSeconds", targetDepth)) {
                    context.nextToken();
                    hlsPackageBuilder.programDateTimeIntervalSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("segmentDurationSeconds", targetDepth)) {
                    context.nextToken();
                    hlsPackageBuilder.segmentDurationSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("streamSelection", targetDepth)) {
                    context.nextToken();
                    hlsPackageBuilder.streamSelection(StreamSelectionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("useAudioRenditionGroup", targetDepth)) {
                    context.nextToken();
                    hlsPackageBuilder.useAudioRenditionGroup((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (HlsPackage)hlsPackageBuilder.build();
    }

    public static HlsPackageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

