/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.transform;

import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.OriginEndpoint;
import software.amazon.awssdk.utils.Validate;

/**
 * {@link OriginEndpoint} Marshaller
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class OriginEndpointMarshaller {
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").isBinary(false).build();

    private static final MarshallingInfo<String> CHANNELID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelId").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> DASHPACKAGE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dashPackage")
            .isBinary(false).build();

    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> HLSPACKAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsPackage").isBinary(false).build();

    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();

    private static final MarshallingInfo<String> MANIFESTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestName").isBinary(false).build();

    private static final MarshallingInfo<StructuredPojo> MSSPACKAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mssPackage").isBinary(false).build();

    private static final MarshallingInfo<Integer> STARTOVERWINDOWSECONDS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("startoverWindowSeconds").isBinary(false).build();

    private static final MarshallingInfo<Integer> TIMEDELAYSECONDS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeDelaySeconds").isBinary(false).build();

    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").isBinary(false).build();

    private static final MarshallingInfo<List> WHITELIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("whitelist").isBinary(false).build();

    private static final OriginEndpointMarshaller INSTANCE = new OriginEndpointMarshaller();

    private OriginEndpointMarshaller() {
    }

    public static OriginEndpointMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object
     */
    public void marshall(OriginEndpoint originEndpoint, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull(originEndpoint, "originEndpoint");
        Validate.paramNotNull(protocolMarshaller, "protocolMarshaller");
        try {
            protocolMarshaller.marshall(originEndpoint.arn(), ARN_BINDING);
            protocolMarshaller.marshall(originEndpoint.channelId(), CHANNELID_BINDING);
            protocolMarshaller.marshall(originEndpoint.dashPackage(), DASHPACKAGE_BINDING);
            protocolMarshaller.marshall(originEndpoint.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(originEndpoint.hlsPackage(), HLSPACKAGE_BINDING);
            protocolMarshaller.marshall(originEndpoint.id(), ID_BINDING);
            protocolMarshaller.marshall(originEndpoint.manifestName(), MANIFESTNAME_BINDING);
            protocolMarshaller.marshall(originEndpoint.mssPackage(), MSSPACKAGE_BINDING);
            protocolMarshaller.marshall(originEndpoint.startoverWindowSeconds(), STARTOVERWINDOWSECONDS_BINDING);
            protocolMarshaller.marshall(originEndpoint.timeDelaySeconds(), TIMEDELAYSECONDS_BINDING);
            protocolMarshaller.marshall(originEndpoint.url(), URL_BINDING);
            protocolMarshaller.marshall(originEndpoint.whitelist(), WHITELIST_BINDING);
        } catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause(e).build();
        }
    }
}
