/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.SpekeKeyProvider;
import software.amazon.awssdk.services.mediapackage.transform.DashEncryptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashEncryption
implements StructuredPojo,
ToCopyableBuilder<Builder, DashEncryption> {
    private final Integer keyRotationIntervalSeconds;
    private final SpekeKeyProvider spekeKeyProvider;

    private DashEncryption(BuilderImpl builder) {
        this.keyRotationIntervalSeconds = builder.keyRotationIntervalSeconds;
        this.spekeKeyProvider = builder.spekeKeyProvider;
    }

    public Integer keyRotationIntervalSeconds() {
        return this.keyRotationIntervalSeconds;
    }

    public SpekeKeyProvider spekeKeyProvider() {
        return this.spekeKeyProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyRotationIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.spekeKeyProvider());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashEncryption)) {
            return false;
        }
        DashEncryption other = (DashEncryption)obj;
        return Objects.equals(this.keyRotationIntervalSeconds(), other.keyRotationIntervalSeconds()) && Objects.equals(this.spekeKeyProvider(), other.spekeKeyProvider());
    }

    public String toString() {
        return ToString.builder((String)"DashEncryption").add("KeyRotationIntervalSeconds", (Object)this.keyRotationIntervalSeconds()).add("SpekeKeyProvider", (Object)this.spekeKeyProvider()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyRotationIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.keyRotationIntervalSeconds()));
            }
            case "SpekeKeyProvider": {
                return Optional.ofNullable(clazz.cast(this.spekeKeyProvider()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DashEncryptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer keyRotationIntervalSeconds;
        private SpekeKeyProvider spekeKeyProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(DashEncryption model) {
            this.keyRotationIntervalSeconds(model.keyRotationIntervalSeconds);
            this.spekeKeyProvider(model.spekeKeyProvider);
        }

        public final Integer getKeyRotationIntervalSeconds() {
            return this.keyRotationIntervalSeconds;
        }

        @Override
        public final Builder keyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
            return this;
        }

        public final void setKeyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return this.spekeKeyProvider != null ? this.spekeKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        public DashEncryption build() {
            return new DashEncryption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DashEncryption> {
        public Builder keyRotationIntervalSeconds(Integer var1);

        public Builder spekeKeyProvider(SpekeKeyProvider var1);

        default public Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return this.spekeKeyProvider((SpekeKeyProvider)((SpekeKeyProvider.Builder)SpekeKeyProvider.builder().applyMutation(spekeKeyProvider)).build());
        }
    }
}

