/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.mediapackage.model.Channel;
import software.amazon.awssdk.services.mediapackage.model.ListOfChannelCopier;
import software.amazon.awssdk.services.mediapackage.model.MediaPackageResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChannelsResponse
extends MediaPackageResponse
implements ToCopyableBuilder<Builder, ListChannelsResponse> {
    private final List<Channel> channels;
    private final String nextToken;

    private ListChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.channels = builder.channels;
        this.nextToken = builder.nextToken;
    }

    public List<Channel> channels() {
        return this.channels;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channels());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChannelsResponse)) {
            return false;
        }
        ListChannelsResponse other = (ListChannelsResponse)((Object)obj);
        return Objects.equals(this.channels(), other.channels()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListChannelsResponse").add("Channels", this.channels()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Channels": {
                return Optional.ofNullable(clazz.cast(this.channels()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaPackageResponse.BuilderImpl
    implements Builder {
        private List<Channel> channels = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChannelsResponse model) {
            super(model);
            this.channels(model.channels);
            this.nextToken(model.nextToken);
        }

        public final Collection<Channel.Builder> getChannels() {
            return this.channels != null ? (Collection)this.channels.stream().map(Channel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ListOfChannelCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel ... channels) {
            this.channels(Arrays.asList(channels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Consumer<Channel.Builder> ... channels) {
            this.channels(Stream.of(channels).map(c -> (Channel)((Channel.Builder)Channel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setChannels(Collection<Channel.BuilderImpl> channels) {
            this.channels = ListOfChannelCopier.copyFromBuilder(channels);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListChannelsResponse build() {
            return new ListChannelsResponse(this);
        }
    }

    public static interface Builder
    extends MediaPackageResponse.Builder,
    CopyableBuilder<Builder, ListChannelsResponse> {
        public Builder channels(Collection<Channel> var1);

        public Builder channels(Channel ... var1);

        public Builder channels(Consumer<Channel.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

