/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.CreateOriginEndpointRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateOriginEndpointRequestModelMarshaller {
    private static final MarshallingInfo<String> CHANNELID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("channelId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DASHPACKAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dashPackage").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> HLSPACKAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsPackage").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final MarshallingInfo<String> MANIFESTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> MSSPACKAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mssPackage").isBinary(false).build();
    private static final MarshallingInfo<Integer> STARTOVERWINDOWSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startoverWindowSeconds").isBinary(false).build();
    private static final MarshallingInfo<Integer> TIMEDELAYSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeDelaySeconds").isBinary(false).build();
    private static final MarshallingInfo<List> WHITELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("whitelist").isBinary(false).build();
    private static final CreateOriginEndpointRequestModelMarshaller INSTANCE = new CreateOriginEndpointRequestModelMarshaller();

    private CreateOriginEndpointRequestModelMarshaller() {
    }

    public static CreateOriginEndpointRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateOriginEndpointRequest createOriginEndpointRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createOriginEndpointRequest), (String)"createOriginEndpointRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createOriginEndpointRequest.channelId(), CHANNELID_BINDING);
            protocolMarshaller.marshall((Object)createOriginEndpointRequest.dashPackage(), DASHPACKAGE_BINDING);
            protocolMarshaller.marshall((Object)createOriginEndpointRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createOriginEndpointRequest.hlsPackage(), HLSPACKAGE_BINDING);
            protocolMarshaller.marshall((Object)createOriginEndpointRequest.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)createOriginEndpointRequest.manifestName(), MANIFESTNAME_BINDING);
            protocolMarshaller.marshall((Object)createOriginEndpointRequest.mssPackage(), MSSPACKAGE_BINDING);
            protocolMarshaller.marshall((Object)createOriginEndpointRequest.startoverWindowSeconds(), STARTOVERWINDOWSECONDS_BINDING);
            protocolMarshaller.marshall((Object)createOriginEndpointRequest.timeDelaySeconds(), TIMEDELAYSECONDS_BINDING);
            protocolMarshaller.marshall(createOriginEndpointRequest.whitelist(), WHITELIST_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

