/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediapackage.model.HlsIngest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class HlsIngestMarshaller {
    private static final MarshallingInfo<List> INGESTENDPOINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ingestEndpoints").isBinary(false).build();
    private static final HlsIngestMarshaller INSTANCE = new HlsIngestMarshaller();

    private HlsIngestMarshaller() {
    }

    public static HlsIngestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(HlsIngest hlsIngest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)hlsIngest, (String)"hlsIngest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(hlsIngest.ingestEndpoints(), INGESTENDPOINTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

