/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediapackage.model.IngestEndpoint;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class IngestEndpointMarshaller {
    private static final MarshallingInfo<String> PASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("password").isBinary(false).build();
    private static final MarshallingInfo<String> URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("url").isBinary(false).build();
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("username").isBinary(false).build();
    private static final IngestEndpointMarshaller INSTANCE = new IngestEndpointMarshaller();

    private IngestEndpointMarshaller() {
    }

    public static IngestEndpointMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(IngestEndpoint ingestEndpoint, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ingestEndpoint, (String)"ingestEndpoint");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ingestEndpoint.password(), PASSWORD_BINDING);
            protocolMarshaller.marshall((Object)ingestEndpoint.url(), URL_BINDING);
            protocolMarshaller.marshall((Object)ingestEndpoint.username(), USERNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

