/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A Dynamic Adaptive Streaming over HTTP (DASH) packaging configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashPackage implements SdkPojo, Serializable, ToCopyableBuilder<DashPackage.Builder, DashPackage> {
    private static final SdkField<DashEncryption> ENCRYPTION_FIELD = SdkField.<DashEncryption> builder(MarshallingType.SDK_POJO)
            .getter(getter(DashPackage::encryption)).setter(setter(Builder::encryption)).constructor(DashEncryption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DashPackage::manifestWindowSeconds)).setter(setter(Builder::manifestWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestWindowSeconds").build())
            .build();

    private static final SdkField<Integer> MIN_BUFFER_TIME_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DashPackage::minBufferTimeSeconds)).setter(setter(Builder::minBufferTimeSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTimeSeconds").build())
            .build();

    private static final SdkField<Integer> MIN_UPDATE_PERIOD_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DashPackage::minUpdatePeriodSeconds)).setter(setter(Builder::minUpdatePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minUpdatePeriodSeconds").build())
            .build();

    private static final SdkField<String> PROFILE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashPackage::profileAsString)).setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()).build();

    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DashPackage::segmentDurationSeconds)).setter(setter(Builder::segmentDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build())
            .build();

    private static final SdkField<StreamSelection> STREAM_SELECTION_FIELD = SdkField
            .<StreamSelection> builder(MarshallingType.SDK_POJO).getter(getter(DashPackage::streamSelection))
            .setter(setter(Builder::streamSelection)).constructor(StreamSelection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamSelection").build()).build();

    private static final SdkField<Integer> SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DashPackage::suggestedPresentationDelaySeconds))
            .setter(setter(Builder::suggestedPresentationDelaySeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestedPresentationDelaySeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD,
            MANIFEST_WINDOW_SECONDS_FIELD, MIN_BUFFER_TIME_SECONDS_FIELD, MIN_UPDATE_PERIOD_SECONDS_FIELD, PROFILE_FIELD,
            SEGMENT_DURATION_SECONDS_FIELD, STREAM_SELECTION_FIELD, SUGGESTED_PRESENTATION_DELAY_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DashEncryption encryption;

    private final Integer manifestWindowSeconds;

    private final Integer minBufferTimeSeconds;

    private final Integer minUpdatePeriodSeconds;

    private final String profile;

    private final Integer segmentDurationSeconds;

    private final StreamSelection streamSelection;

    private final Integer suggestedPresentationDelaySeconds;

    private DashPackage(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
        this.minUpdatePeriodSeconds = builder.minUpdatePeriodSeconds;
        this.profile = builder.profile;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.streamSelection = builder.streamSelection;
        this.suggestedPresentationDelaySeconds = builder.suggestedPresentationDelaySeconds;
    }

    /**
     * Returns the value of the Encryption property for this object.
     * 
     * @return The value of the Encryption property for this object.
     */
    public DashEncryption encryption() {
        return encryption;
    }

    /**
     * Time window (in seconds) contained in each manifest.
     * 
     * @return Time window (in seconds) contained in each manifest.
     */
    public Integer manifestWindowSeconds() {
        return manifestWindowSeconds;
    }

    /**
     * Minimum duration (in seconds) that a player will buffer media before starting the presentation.
     * 
     * @return Minimum duration (in seconds) that a player will buffer media before starting the presentation.
     */
    public Integer minBufferTimeSeconds() {
        return minBufferTimeSeconds;
    }

    /**
     * Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP (DASH) Media
     * Presentation Description (MPD).
     * 
     * @return Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP
     *         (DASH) Media Presentation Description (MPD).
     */
    public Integer minUpdatePeriodSeconds() {
        return minUpdatePeriodSeconds;
    }

    /**
     * The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant output
     * is enabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link Profile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5
     *         compliant output is enabled.
     * @see Profile
     */
    public Profile profile() {
        return Profile.fromValue(profile);
    }

    /**
     * The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant output
     * is enabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profile} will
     * return {@link Profile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profileAsString}.
     * </p>
     * 
     * @return The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5
     *         compliant output is enabled.
     * @see Profile
     */
    public String profileAsString() {
        return profile;
    }

    /**
     * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source
     * segment duration.
     *
     * @return Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the
     *         source segment duration.
     */
    public Integer segmentDurationSeconds() {
        return segmentDurationSeconds;
    }

    /**
     * Returns the value of the StreamSelection property for this object.
     * 
     * @return The value of the StreamSelection property for this object.
     */
    public StreamSelection streamSelection() {
        return streamSelection;
    }

    /**
     * Duration (in seconds) to delay live content before presentation.
     * 
     * @return Duration (in seconds) to delay live content before presentation.
     */
    public Integer suggestedPresentationDelaySeconds() {
        return suggestedPresentationDelaySeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(minBufferTimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(minUpdatePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(streamSelection());
        hashCode = 31 * hashCode + Objects.hashCode(suggestedPresentationDelaySeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashPackage)) {
            return false;
        }
        DashPackage other = (DashPackage) obj;
        return Objects.equals(encryption(), other.encryption())
                && Objects.equals(manifestWindowSeconds(), other.manifestWindowSeconds())
                && Objects.equals(minBufferTimeSeconds(), other.minBufferTimeSeconds())
                && Objects.equals(minUpdatePeriodSeconds(), other.minUpdatePeriodSeconds())
                && Objects.equals(profileAsString(), other.profileAsString())
                && Objects.equals(segmentDurationSeconds(), other.segmentDurationSeconds())
                && Objects.equals(streamSelection(), other.streamSelection())
                && Objects.equals(suggestedPresentationDelaySeconds(), other.suggestedPresentationDelaySeconds());
    }

    @Override
    public String toString() {
        return ToString.builder("DashPackage").add("Encryption", encryption())
                .add("ManifestWindowSeconds", manifestWindowSeconds()).add("MinBufferTimeSeconds", minBufferTimeSeconds())
                .add("MinUpdatePeriodSeconds", minUpdatePeriodSeconds()).add("Profile", profileAsString())
                .add("SegmentDurationSeconds", segmentDurationSeconds()).add("StreamSelection", streamSelection())
                .add("SuggestedPresentationDelaySeconds", suggestedPresentationDelaySeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "ManifestWindowSeconds":
            return Optional.ofNullable(clazz.cast(manifestWindowSeconds()));
        case "MinBufferTimeSeconds":
            return Optional.ofNullable(clazz.cast(minBufferTimeSeconds()));
        case "MinUpdatePeriodSeconds":
            return Optional.ofNullable(clazz.cast(minUpdatePeriodSeconds()));
        case "Profile":
            return Optional.ofNullable(clazz.cast(profileAsString()));
        case "SegmentDurationSeconds":
            return Optional.ofNullable(clazz.cast(segmentDurationSeconds()));
        case "StreamSelection":
            return Optional.ofNullable(clazz.cast(streamSelection()));
        case "SuggestedPresentationDelaySeconds":
            return Optional.ofNullable(clazz.cast(suggestedPresentationDelaySeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashPackage, T> g) {
        return obj -> g.apply((DashPackage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashPackage> {
        /**
         * Sets the value of the Encryption property for this object.
         *
         * @param encryption
         *        The new value for the Encryption property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(DashEncryption encryption);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * This is a convenience that creates an instance of the {@link DashEncryption.Builder} avoiding the need to
         * create one manually via {@link DashEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link DashEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(DashEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link DashEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(DashEncryption)
         */
        default Builder encryption(Consumer<DashEncryption.Builder> encryption) {
            return encryption(DashEncryption.builder().applyMutation(encryption).build());
        }

        /**
         * Time window (in seconds) contained in each manifest.
         * 
         * @param manifestWindowSeconds
         *        Time window (in seconds) contained in each manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestWindowSeconds(Integer manifestWindowSeconds);

        /**
         * Minimum duration (in seconds) that a player will buffer media before starting the presentation.
         * 
         * @param minBufferTimeSeconds
         *        Minimum duration (in seconds) that a player will buffer media before starting the presentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minBufferTimeSeconds(Integer minBufferTimeSeconds);

        /**
         * Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP (DASH)
         * Media Presentation Description (MPD).
         * 
         * @param minUpdatePeriodSeconds
         *        Minimum duration (in seconds) between potential changes to the Dynamic Adaptive Streaming over HTTP
         *        (DASH) Media Presentation Description (MPD).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minUpdatePeriodSeconds(Integer minUpdatePeriodSeconds);

        /**
         * The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant
         * output is enabled.
         * 
         * @param profile
         *        The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5
         *        compliant output is enabled.
         * @see Profile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Profile
         */
        Builder profile(String profile);

        /**
         * The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5 compliant
         * output is enabled.
         * 
         * @param profile
         *        The Dynamic Adaptive Streaming over HTTP (DASH) profile type. When set to "HBBTV_1_5", HbbTV 1.5
         *        compliant output is enabled.
         * @see Profile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Profile
         */
        Builder profile(Profile profile);

        /**
         * Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the source
         * segment duration.
         *
         * @param segmentDurationSeconds
         *        Duration (in seconds) of each segment. Actual segments will be rounded to the nearest multiple of the
         *        source segment duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDurationSeconds(Integer segmentDurationSeconds);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * @param streamSelection
         *        The new value for the StreamSelection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSelection(StreamSelection streamSelection);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * This is a convenience that creates an instance of the {@link StreamSelection.Builder} avoiding the need to
         * create one manually via {@link StreamSelection#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamSelection.Builder#build()} is called immediately and its
         * result is passed to {@link #streamSelection(StreamSelection)}.
         * 
         * @param streamSelection
         *        a consumer that will call methods on {@link StreamSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSelection(StreamSelection)
         */
        default Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return streamSelection(StreamSelection.builder().applyMutation(streamSelection).build());
        }

        /**
         * Duration (in seconds) to delay live content before presentation.
         * 
         * @param suggestedPresentationDelaySeconds
         *        Duration (in seconds) to delay live content before presentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds);
    }

    static final class BuilderImpl implements Builder {
        private DashEncryption encryption;

        private Integer manifestWindowSeconds;

        private Integer minBufferTimeSeconds;

        private Integer minUpdatePeriodSeconds;

        private String profile;

        private Integer segmentDurationSeconds;

        private StreamSelection streamSelection;

        private Integer suggestedPresentationDelaySeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DashPackage model) {
            encryption(model.encryption);
            manifestWindowSeconds(model.manifestWindowSeconds);
            minBufferTimeSeconds(model.minBufferTimeSeconds);
            minUpdatePeriodSeconds(model.minUpdatePeriodSeconds);
            profile(model.profile);
            segmentDurationSeconds(model.segmentDurationSeconds);
            streamSelection(model.streamSelection);
            suggestedPresentationDelaySeconds(model.suggestedPresentationDelaySeconds);
        }

        public final DashEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(DashEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(DashEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getManifestWindowSeconds() {
            return manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        public final Integer getMinBufferTimeSeconds() {
            return minBufferTimeSeconds;
        }

        @Override
        public final Builder minBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
            return this;
        }

        public final void setMinBufferTimeSeconds(Integer minBufferTimeSeconds) {
            this.minBufferTimeSeconds = minBufferTimeSeconds;
        }

        public final Integer getMinUpdatePeriodSeconds() {
            return minUpdatePeriodSeconds;
        }

        @Override
        public final Builder minUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
            return this;
        }

        public final void setMinUpdatePeriodSeconds(Integer minUpdatePeriodSeconds) {
            this.minUpdatePeriodSeconds = minUpdatePeriodSeconds;
        }

        public final String getProfile() {
            return profile;
        }

        @Override
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public final Builder profile(Profile profile) {
            this.profile(profile.toString());
            return this;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        public final Integer getSegmentDurationSeconds() {
            return segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return streamSelection != null ? streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        public final Integer getSuggestedPresentationDelaySeconds() {
            return suggestedPresentationDelaySeconds;
        }

        @Override
        public final Builder suggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
            return this;
        }

        public final void setSuggestedPresentationDelaySeconds(Integer suggestedPresentationDelaySeconds) {
            this.suggestedPresentationDelaySeconds = suggestedPresentationDelaySeconds;
        }

        @Override
        public DashPackage build() {
            return new DashPackage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
