/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * An HTTP Live Streaming (HLS) ingest resource configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsIngest implements SdkPojo, Serializable, ToCopyableBuilder<HlsIngest.Builder, HlsIngest> {
    private static final SdkField<List<IngestEndpoint>> INGEST_ENDPOINTS_FIELD = SdkField
            .<List<IngestEndpoint>> builder(MarshallingType.LIST)
            .getter(getter(HlsIngest::ingestEndpoints))
            .setter(setter(Builder::ingestEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IngestEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(IngestEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGEST_ENDPOINTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<IngestEndpoint> ingestEndpoints;

    private HlsIngest(BuilderImpl builder) {
        this.ingestEndpoints = builder.ingestEndpoints;
    }

    /**
     * A list of endpoints to which the source stream should be sent.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of endpoints to which the source stream should be sent.
     */
    public List<IngestEndpoint> ingestEndpoints() {
        return ingestEndpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ingestEndpoints());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsIngest)) {
            return false;
        }
        HlsIngest other = (HlsIngest) obj;
        return Objects.equals(ingestEndpoints(), other.ingestEndpoints());
    }

    @Override
    public String toString() {
        return ToString.builder("HlsIngest").add("IngestEndpoints", ingestEndpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IngestEndpoints":
            return Optional.ofNullable(clazz.cast(ingestEndpoints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsIngest, T> g) {
        return obj -> g.apply((HlsIngest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsIngest> {
        /**
         * A list of endpoints to which the source stream should be sent.
         * 
         * @param ingestEndpoints
         *        A list of endpoints to which the source stream should be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestEndpoints(Collection<IngestEndpoint> ingestEndpoints);

        /**
         * A list of endpoints to which the source stream should be sent.
         * 
         * @param ingestEndpoints
         *        A list of endpoints to which the source stream should be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestEndpoints(IngestEndpoint... ingestEndpoints);

        /**
         * A list of endpoints to which the source stream should be sent. This is a convenience that creates an instance
         * of the {@link List<IngestEndpoint>.Builder} avoiding the need to create one manually via {@link List
         * <IngestEndpoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IngestEndpoint>.Builder#build()} is called immediately and
         * its result is passed to {@link #ingestEndpoints(List<IngestEndpoint>)}.
         * 
         * @param ingestEndpoints
         *        a consumer that will call methods on {@link List<IngestEndpoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ingestEndpoints(List<IngestEndpoint>)
         */
        Builder ingestEndpoints(Consumer<IngestEndpoint.Builder>... ingestEndpoints);
    }

    static final class BuilderImpl implements Builder {
        private List<IngestEndpoint> ingestEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HlsIngest model) {
            ingestEndpoints(model.ingestEndpoints);
        }

        public final Collection<IngestEndpoint.Builder> getIngestEndpoints() {
            return ingestEndpoints != null ? ingestEndpoints.stream().map(IngestEndpoint::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder ingestEndpoints(Collection<IngestEndpoint> ingestEndpoints) {
            this.ingestEndpoints = ListOfIngestEndpointCopier.copy(ingestEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestEndpoints(IngestEndpoint... ingestEndpoints) {
            ingestEndpoints(Arrays.asList(ingestEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingestEndpoints(Consumer<IngestEndpoint.Builder>... ingestEndpoints) {
            ingestEndpoints(Stream.of(ingestEndpoints).map(c -> IngestEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIngestEndpoints(Collection<IngestEndpoint.BuilderImpl> ingestEndpoints) {
            this.ingestEndpoints = ListOfIngestEndpointCopier.copyFromBuilder(ingestEndpoints);
        }

        @Override
        public HlsIngest build() {
            return new HlsIngest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
