/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.transform.MssPackageMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A Microsoft Smooth Streaming (MSS) packaging configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public class MssPackage implements StructuredPojo, ToCopyableBuilder<MssPackage.Builder, MssPackage> {
    private final MssEncryption encryption;

    private final Integer manifestWindowSeconds;

    private final Integer segmentDurationSeconds;

    private final StreamSelection streamSelection;

    private MssPackage(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.streamSelection = builder.streamSelection;
    }

    /**
     * Returns the value of the Encryption property for this object.
     * 
     * @return The value of the Encryption property for this object.
     */
    public MssEncryption encryption() {
        return encryption;
    }

    /**
     * The time window (in seconds) contained in each manifest.
     * 
     * @return The time window (in seconds) contained in each manifest.
     */
    public Integer manifestWindowSeconds() {
        return manifestWindowSeconds;
    }

    /**
     * The duration (in seconds) of each segment.
     * 
     * @return The duration (in seconds) of each segment.
     */
    public Integer segmentDurationSeconds() {
        return segmentDurationSeconds;
    }

    /**
     * Returns the value of the StreamSelection property for this object.
     * 
     * @return The value of the StreamSelection property for this object.
     */
    public StreamSelection streamSelection() {
        return streamSelection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(manifestWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(streamSelection());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MssPackage)) {
            return false;
        }
        MssPackage other = (MssPackage) obj;
        return Objects.equals(encryption(), other.encryption())
                && Objects.equals(manifestWindowSeconds(), other.manifestWindowSeconds())
                && Objects.equals(segmentDurationSeconds(), other.segmentDurationSeconds())
                && Objects.equals(streamSelection(), other.streamSelection());
    }

    @Override
    public String toString() {
        return ToString.builder("MssPackage").add("Encryption", encryption())
                .add("ManifestWindowSeconds", manifestWindowSeconds()).add("SegmentDurationSeconds", segmentDurationSeconds())
                .add("StreamSelection", streamSelection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Encryption":
            return Optional.of(clazz.cast(encryption()));
        case "ManifestWindowSeconds":
            return Optional.of(clazz.cast(manifestWindowSeconds()));
        case "SegmentDurationSeconds":
            return Optional.of(clazz.cast(segmentDurationSeconds()));
        case "StreamSelection":
            return Optional.of(clazz.cast(streamSelection()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MssPackageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, MssPackage> {
        /**
         * Sets the value of the Encryption property for this object.
         *
         * @param encryption
         *        The new value for the Encryption property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(MssEncryption encryption);

        /**
         * Sets the value of the Encryption property for this object.
         *
         * This is a convenience that creates an instance of the {@link MssEncryption.Builder} avoiding the need to
         * create one manually via {@link MssEncryption#builder()}.
         *
         * When the {@link Consumer} completes, {@link MssEncryption.Builder#build()} is called immediately and its
         * result is passed to {@link #encryption(MssEncryption)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link MssEncryption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(MssEncryption)
         */
        default Builder encryption(Consumer<MssEncryption.Builder> encryption) {
            return encryption(MssEncryption.builder().apply(encryption).build());
        }

        /**
         * The time window (in seconds) contained in each manifest.
         * 
         * @param manifestWindowSeconds
         *        The time window (in seconds) contained in each manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestWindowSeconds(Integer manifestWindowSeconds);

        /**
         * The duration (in seconds) of each segment.
         * 
         * @param segmentDurationSeconds
         *        The duration (in seconds) of each segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDurationSeconds(Integer segmentDurationSeconds);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * @param streamSelection
         *        The new value for the StreamSelection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamSelection(StreamSelection streamSelection);

        /**
         * Sets the value of the StreamSelection property for this object.
         *
         * This is a convenience that creates an instance of the {@link StreamSelection.Builder} avoiding the need to
         * create one manually via {@link StreamSelection#builder()}.
         *
         * When the {@link Consumer} completes, {@link StreamSelection.Builder#build()} is called immediately and its
         * result is passed to {@link #streamSelection(StreamSelection)}.
         * 
         * @param streamSelection
         *        a consumer that will call methods on {@link StreamSelection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamSelection(StreamSelection)
         */
        default Builder streamSelection(Consumer<StreamSelection.Builder> streamSelection) {
            return streamSelection(StreamSelection.builder().apply(streamSelection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MssEncryption encryption;

        private Integer manifestWindowSeconds;

        private Integer segmentDurationSeconds;

        private StreamSelection streamSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(MssPackage model) {
            encryption(model.encryption);
            manifestWindowSeconds(model.manifestWindowSeconds);
            segmentDurationSeconds(model.segmentDurationSeconds);
            streamSelection(model.streamSelection);
        }

        public final MssEncryption.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(MssEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(MssEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getManifestWindowSeconds() {
            return manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        public final Integer getSegmentDurationSeconds() {
            return segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final StreamSelection.Builder getStreamSelection() {
            return streamSelection != null ? streamSelection.toBuilder() : null;
        }

        @Override
        public final Builder streamSelection(StreamSelection streamSelection) {
            this.streamSelection = streamSelection;
            return this;
        }

        public final void setStreamSelection(StreamSelection.BuilderImpl streamSelection) {
            this.streamSelection = streamSelection != null ? streamSelection.build() : null;
        }

        @Override
        public MssPackage build() {
            return new MssPackage(this);
        }
    }
}
