/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.mediapackage.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * StreamSelectionMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class StreamSelectionMarshaller {

    private static final MarshallingInfo<Integer> MAXVIDEOBITSPERSECOND_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("maxVideoBitsPerSecond").build();
    private static final MarshallingInfo<Integer> MINVIDEOBITSPERSECOND_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("minVideoBitsPerSecond").build();
    private static final MarshallingInfo<String> STREAMORDER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamOrder").build();

    private static final StreamSelectionMarshaller INSTANCE = new StreamSelectionMarshaller();

    public static StreamSelectionMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(StreamSelection streamSelection, ProtocolMarshaller protocolMarshaller) {

        if (streamSelection == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(streamSelection.maxVideoBitsPerSecond(), MAXVIDEOBITSPERSECOND_BINDING);

            protocolMarshaller.marshall(streamSelection.minVideoBitsPerSecond(), MINVIDEOBITSPERSECOND_BINDING);

            protocolMarshaller.marshall(streamSelection.streamOrderString(), STREAMORDER_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
