/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.transform;

import java.util.List;
import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.mediapackage.model.*;

import software.amazon.awssdk.core.protocol.*;
import software.amazon.awssdk.annotations.SdkInternalApi;

/**
 * UpdateOriginEndpointRequestMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class UpdateOriginEndpointRequestModelMarshaller {

    private static final MarshallingInfo<StructuredPojo> DASHPACKAGE_BINDING = MarshallingInfo
            .builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dashPackage")
            .build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<StructuredPojo> HLSPACKAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hlsPackage").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PATH).marshallLocationName("id").build();
    private static final MarshallingInfo<String> MANIFESTNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("manifestName").build();
    private static final MarshallingInfo<StructuredPojo> MSSPACKAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mssPackage").build();
    private static final MarshallingInfo<Integer> STARTOVERWINDOWSECONDS_BINDING = MarshallingInfo
            .builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("startoverWindowSeconds").build();
    private static final MarshallingInfo<Integer> TIMEDELAYSECONDS_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeDelaySeconds").build();
    private static final MarshallingInfo<List> WHITELIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("whitelist").build();

    private static final UpdateOriginEndpointRequestModelMarshaller INSTANCE = new UpdateOriginEndpointRequestModelMarshaller();

    public static UpdateOriginEndpointRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UpdateOriginEndpointRequest updateOriginEndpointRequest, ProtocolMarshaller protocolMarshaller) {

        if (updateOriginEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(updateOriginEndpointRequest.dashPackage(), DASHPACKAGE_BINDING);

            protocolMarshaller.marshall(updateOriginEndpointRequest.description(), DESCRIPTION_BINDING);

            protocolMarshaller.marshall(updateOriginEndpointRequest.hlsPackage(), HLSPACKAGE_BINDING);

            protocolMarshaller.marshall(updateOriginEndpointRequest.id(), ID_BINDING);

            protocolMarshaller.marshall(updateOriginEndpointRequest.manifestName(), MANIFESTNAME_BINDING);

            protocolMarshaller.marshall(updateOriginEndpointRequest.mssPackage(), MSSPACKAGE_BINDING);

            protocolMarshaller.marshall(updateOriginEndpointRequest.startoverWindowSeconds(), STARTOVERWINDOWSECONDS_BINDING);

            protocolMarshaller.marshall(updateOriginEndpointRequest.timeDelaySeconds(), TIMEDELAYSECONDS_BINDING);

            protocolMarshaller.marshall(updateOriginEndpointRequest.whitelist(), WHITELIST_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
