/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.EncryptionMethod;
import software.amazon.awssdk.services.mediapackage.model.SpekeKeyProvider;
import software.amazon.awssdk.services.mediapackage.transform.HlsEncryptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsEncryption
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsEncryption> {
    private final String constantInitializationVector;
    private final String encryptionMethod;
    private final Integer keyRotationIntervalSeconds;
    private final Boolean repeatExtXKey;
    private final SpekeKeyProvider spekeKeyProvider;

    private HlsEncryption(BuilderImpl builder) {
        this.constantInitializationVector = builder.constantInitializationVector;
        this.encryptionMethod = builder.encryptionMethod;
        this.keyRotationIntervalSeconds = builder.keyRotationIntervalSeconds;
        this.repeatExtXKey = builder.repeatExtXKey;
        this.spekeKeyProvider = builder.spekeKeyProvider;
    }

    public String constantInitializationVector() {
        return this.constantInitializationVector;
    }

    public EncryptionMethod encryptionMethod() {
        return EncryptionMethod.fromValue(this.encryptionMethod);
    }

    public String encryptionMethodString() {
        return this.encryptionMethod;
    }

    public Integer keyRotationIntervalSeconds() {
        return this.keyRotationIntervalSeconds;
    }

    public Boolean repeatExtXKey() {
        return this.repeatExtXKey;
    }

    public SpekeKeyProvider spekeKeyProvider() {
        return this.spekeKeyProvider;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constantInitializationVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionMethodString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyRotationIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.repeatExtXKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.spekeKeyProvider());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsEncryption)) {
            return false;
        }
        HlsEncryption other = (HlsEncryption)obj;
        return Objects.equals(this.constantInitializationVector(), other.constantInitializationVector()) && Objects.equals(this.encryptionMethodString(), other.encryptionMethodString()) && Objects.equals(this.keyRotationIntervalSeconds(), other.keyRotationIntervalSeconds()) && Objects.equals(this.repeatExtXKey(), other.repeatExtXKey()) && Objects.equals(this.spekeKeyProvider(), other.spekeKeyProvider());
    }

    public String toString() {
        return ToString.builder((String)"HlsEncryption").add("ConstantInitializationVector", (Object)this.constantInitializationVector()).add("EncryptionMethod", (Object)this.encryptionMethodString()).add("KeyRotationIntervalSeconds", (Object)this.keyRotationIntervalSeconds()).add("RepeatExtXKey", (Object)this.repeatExtXKey()).add("SpekeKeyProvider", (Object)this.spekeKeyProvider()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConstantInitializationVector": {
                return Optional.of(clazz.cast(this.constantInitializationVector()));
            }
            case "EncryptionMethod": {
                return Optional.of(clazz.cast(this.encryptionMethodString()));
            }
            case "KeyRotationIntervalSeconds": {
                return Optional.of(clazz.cast(this.keyRotationIntervalSeconds()));
            }
            case "RepeatExtXKey": {
                return Optional.of(clazz.cast(this.repeatExtXKey()));
            }
            case "SpekeKeyProvider": {
                return Optional.of(clazz.cast(this.spekeKeyProvider()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsEncryptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String constantInitializationVector;
        private String encryptionMethod;
        private Integer keyRotationIntervalSeconds;
        private Boolean repeatExtXKey;
        private SpekeKeyProvider spekeKeyProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsEncryption model) {
            this.constantInitializationVector(model.constantInitializationVector);
            this.encryptionMethod(model.encryptionMethod);
            this.keyRotationIntervalSeconds(model.keyRotationIntervalSeconds);
            this.repeatExtXKey(model.repeatExtXKey);
            this.spekeKeyProvider(model.spekeKeyProvider);
        }

        public final String getConstantInitializationVector() {
            return this.constantInitializationVector;
        }

        @Override
        public final Builder constantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
            return this;
        }

        public final void setConstantInitializationVector(String constantInitializationVector) {
            this.constantInitializationVector = constantInitializationVector;
        }

        public final String getEncryptionMethod() {
            return this.encryptionMethod;
        }

        @Override
        public final Builder encryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
            return this;
        }

        @Override
        public final Builder encryptionMethod(EncryptionMethod encryptionMethod) {
            this.encryptionMethod(encryptionMethod.toString());
            return this;
        }

        public final void setEncryptionMethod(String encryptionMethod) {
            this.encryptionMethod = encryptionMethod;
        }

        public final Integer getKeyRotationIntervalSeconds() {
            return this.keyRotationIntervalSeconds;
        }

        @Override
        public final Builder keyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
            return this;
        }

        public final void setKeyRotationIntervalSeconds(Integer keyRotationIntervalSeconds) {
            this.keyRotationIntervalSeconds = keyRotationIntervalSeconds;
        }

        public final Boolean getRepeatExtXKey() {
            return this.repeatExtXKey;
        }

        @Override
        public final Builder repeatExtXKey(Boolean repeatExtXKey) {
            this.repeatExtXKey = repeatExtXKey;
            return this;
        }

        public final void setRepeatExtXKey(Boolean repeatExtXKey) {
            this.repeatExtXKey = repeatExtXKey;
        }

        public final SpekeKeyProvider.Builder getSpekeKeyProvider() {
            return this.spekeKeyProvider != null ? this.spekeKeyProvider.toBuilder() : null;
        }

        @Override
        public final Builder spekeKeyProvider(SpekeKeyProvider spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider;
            return this;
        }

        public final void setSpekeKeyProvider(SpekeKeyProvider.BuilderImpl spekeKeyProvider) {
            this.spekeKeyProvider = spekeKeyProvider != null ? spekeKeyProvider.build() : null;
        }

        public HlsEncryption build() {
            return new HlsEncryption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsEncryption> {
        public Builder constantInitializationVector(String var1);

        public Builder encryptionMethod(String var1);

        public Builder encryptionMethod(EncryptionMethod var1);

        public Builder keyRotationIntervalSeconds(Integer var1);

        public Builder repeatExtXKey(Boolean var1);

        public Builder spekeKeyProvider(SpekeKeyProvider var1);

        default public Builder spekeKeyProvider(Consumer<SpekeKeyProvider.Builder> spekeKeyProvider) {
            return this.spekeKeyProvider((SpekeKeyProvider)((SpekeKeyProvider.Builder)SpekeKeyProvider.builder().apply(spekeKeyProvider)).build());
        }
    }
}

