/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.mediapackage.MediaPackageClient;
import software.amazon.awssdk.services.mediapackage.model.Channel;
import software.amazon.awssdk.services.mediapackage.model.ListChannelsRequest;
import software.amazon.awssdk.services.mediapackage.model.ListChannelsResponse;

public final class ListChannelsPaginator
implements SdkIterable<ListChannelsResponse> {
    private final MediaPackageClient client;
    private final ListChannelsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListChannelsPaginator(MediaPackageClient client, ListChannelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListChannelsResponseFetcher();
    }

    public Iterator<ListChannelsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Channel> channels() {
        Function<ListChannelsResponse, Iterator> getIterator = response -> response != null ? response.channels().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListChannelsResponseFetcher
    implements NextPageFetcher<ListChannelsResponse> {
        private ListChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListChannelsResponse nextPage(ListChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelsPaginator.this.client.listChannels(ListChannelsPaginator.this.firstRequest);
            }
            return ListChannelsPaginator.this.client.listChannels((ListChannelsRequest)((Object)ListChannelsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

