/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.mediapackage.model.DashEncryption;

@SdkInternalApi
public class DashEncryptionMarshaller {
    private static final MarshallingInfo<Integer> KEYROTATIONINTERVALSECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("keyRotationIntervalSeconds").build();
    private static final MarshallingInfo<StructuredPojo> SPEKEKEYPROVIDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spekeKeyProvider").build();
    private static final DashEncryptionMarshaller INSTANCE = new DashEncryptionMarshaller();

    public static DashEncryptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DashEncryption dashEncryption, ProtocolMarshaller protocolMarshaller) {
        if (dashEncryption == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dashEncryption.keyRotationIntervalSeconds(), KEYROTATIONINTERVALSECONDS_BINDING);
            protocolMarshaller.marshall((Object)dashEncryption.spekeKeyProvider(), SPEKEKEYPROVIDER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

