/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediapackage.model.HlsEncryption;
import software.amazon.awssdk.services.mediapackage.transform.SpekeKeyProviderUnmarshaller;

public class HlsEncryptionUnmarshaller
implements Unmarshaller<HlsEncryption, JsonUnmarshallerContext> {
    private static final HlsEncryptionUnmarshaller INSTANCE = new HlsEncryptionUnmarshaller();

    public HlsEncryption unmarshall(JsonUnmarshallerContext context) throws Exception {
        HlsEncryption.Builder hlsEncryptionBuilder = HlsEncryption.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("constantInitializationVector", targetDepth)) {
                    context.nextToken();
                    hlsEncryptionBuilder.constantInitializationVector((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("encryptionMethod", targetDepth)) {
                    context.nextToken();
                    hlsEncryptionBuilder.encryptionMethod((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("keyRotationIntervalSeconds", targetDepth)) {
                    context.nextToken();
                    hlsEncryptionBuilder.keyRotationIntervalSeconds((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("repeatExtXKey", targetDepth)) {
                    context.nextToken();
                    hlsEncryptionBuilder.repeatExtXKey((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("spekeKeyProvider", targetDepth)) {
                    context.nextToken();
                    hlsEncryptionBuilder.spekeKeyProvider(SpekeKeyProviderUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (HlsEncryption)hlsEncryptionBuilder.build();
    }

    public static HlsEncryptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

