/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackage.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * A new Channel configuration.
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateChannelRequest extends MediaPackageRequest implements
        ToCopyableBuilder<CreateChannelRequest.Builder, CreateChannelRequest> {
    private final String description;

    private final String id;

    private CreateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.id = builder.id;
    }

    /**
     * A short text description of the Channel.
     * 
     * @return A short text description of the Channel.
     */
    public String description() {
        return description;
    }

    /**
     * The ID of the Channel. The ID must be unique within the region and it cannot be changed after a Channel is
     * created.
     *
     * @return The ID of the Channel. The ID must be unique within the region and it cannot be changed after a Channel
     *         is created.
     */
    public String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelRequest)) {
            return false;
        }
        CreateChannelRequest other = (CreateChannelRequest) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(id(), other.id());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateChannelRequest").add("Description", description()).add("Id", id()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "Id":
            return Optional.of(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends MediaPackageRequest.Builder, CopyableBuilder<Builder, CreateChannelRequest> {
        /**
         * A short text description of the Channel.
         * 
         * @param description
         *        A short text description of the Channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * The ID of the Channel. The ID must be unique within the region and it cannot be changed after a Channel is
         * created.
         *
         * @param id
         *        The ID of the Channel. The ID must be unique within the region and it cannot be changed after a
         *        Channel is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends MediaPackageRequest.BuilderImpl implements Builder {
        private String description;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChannelRequest model) {
            description(model.description);
            id(model.id);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateChannelRequest build() {
            return new CreateChannelRequest(this);
        }
    }
}
